<?
class Model_shop_order extends MY_Model {
    /**
     * TKD shop_order MODEL
     *
     * @package     shop_order Model
     * @author      Dalton Lambert (dalton.developer@gmail.com)
     * @version     2.0
     * @since       2014 / Amazingly corrupt models Corporation Inc.
     */

    protected $_table    = 'shop_order';
    protected $_field_prefix    = 'order_';
    protected $_pk    = 'order_id';
    protected $_status_field    = 'order_status';
    public $relations = array();
    public $pagination_params = array();
    public $dt_params = array();
    public $_per_page    = 20;
    
    function __construct()
    {
        // Call the Model constructor
        
        $this->pagination_params['fields'] = "{pre}shop_order.order_id, 
                                                UCASE({pre}shop_order.order_billing_fname) ,
                                                UCASE({pre}shop_order.order_billing_lname) ,
                                                order_billing_email,
                                                CONCAT('$ ', ROUND(SUM({pre}shop_item.item_price)+{pre}shop_order.order_shipping_amount-{pre}shop_order.order_discount_amount+{pre}shop_order.order_tax_amount , 2)) as invoice_price , 
                                                {pre}shop_order.order_payment_status ,
                                                {pre}shop_order.order_delivery_status";

        $this->pagination_params['joins'][] = array(
                                                'table'=>'shop_item',
                                                'joint'=>'shop_order.order_id = shop_item.item_order_id');

        
        $this->pagination_params['group'] = 'shop_order.order_id';
        
        if(!PAYMENT_MODE_IS_TEST)
            $this->pagination_params['where']["order_is_sandbox"] = 0;

        // if(ENVIRONMENT != 'development')
        //     $this->pagination_params['where_string'] = 'order_payment_status > 0';
        
        parent::__construct();
    }


    public function find_invoice_amount_by_order_id($order_id)
    {
        $total = 0;

        // Item Total
        $items_total = $this->model_shop_item->find_total_item_amount_by_order_id($order_id);
        if(isset($items_total))
            $total += $items_total;

        $order = $this->find_by_pk($order_id);
        // Included Amount
        if(isset($order) AND array_filled($order))
        {
            $total += $order['order_shipping_amount'];
            $total += $order['order_tax_amount'];
            $total -= $order['order_discount_amount'];
        }

        return $total;
    }



    public function find_invoice_amount_by_order_id2($order_id)
    {
        $total = 0;

        // Item Total
        $items_total = $this->model_shop_item->find_total_item_amount_by_order_id($order_id);
        if(isset($items_total))
            $total += $items_total;

        $order = $this->find_by_pk($order_id);
        // Included Amount
        if(isset($order) AND array_filled($order))
        {
            $total -= $order['order_discount_amount'];

            $var['subtotal'] = $total;
            $var['shipping'] = $order['order_shipping_amount'];
            $var['tax'] = $order['order_tax_amount'];

        }

        return $var;
    }


    public function get_data($vars)
    {
        return $this->model_shop_order->find_all($vars);
    }

    // Save Order Data
    public function save_order_status($data)
    {
        if(isset($data['order_id']))
        {
            $this->db->where('order_id',$data['order_id']);
            $this->db->update('shop_order',$data);
            return  true;
        }
        else
        {
            unset($data['order_id']);
            $this->db->insert('shop_order',$data);
            return $this->db->insert_id();
        }
    }



    //public function get_order($user_id)
    public function get_order_by_user_id($user_id,$is_paid=false)
    {
        $param['fields'] = 'order_id , order_ondate as order_date ,SUM(item_price) as price , order_payment_status , order_status,
                    order_shipping_amount , order_tax_amount , order_discount_amount , order_delivery_status,order_paypal_ipn_track_id';

        $param['joins'][] = array(
                'table'=>'shop_item',
                'joint'=>'shop_order.order_id = shop_item.item_order_id');

        $param['where']["order_user_id"] = $user_id;
        $param['group'] = 'order_id';
    
        if(!PAYMENT_MODE_IS_TEST)
            $param['where']["order_is_sandbox"] = 0;

        if($is_paid)
            $param['where']["order_payment_status"] = 1;


        $data = $this->find_all_active($param);

        if(isset($data) AND array_filled($data)) {
            foreach($data as $key=>$value) {
                $data[$key]['items'] = $this->model_shop_item->find_all(
                    array(
                        'where'=>array('item_order_id'=>$value['order_id'])
                    ));
            }
        }

        return $data;
    }


    //public function get_order($user_id)
    public function get_order_by_pk($order_id,$param=array())
    {
        $param['fields'] = 'order_id ,order_billing_fname,order_billing_lname,order_billing_email, order_ondate as order_date ,SUM(item_price) as price , order_payment_status , order_status,
                    order_shipping_amount , order_tax_amount , order_discount_amount , order_delivery_status';

        $param['joins'][] = array(
                'table'=>'shop_item',
                'joint'=>'shop_order.order_id = shop_item.item_order_id');

    
        if(!PAYMENT_MODE_IS_TEST)
            $param['where']["order_is_sandbox"] = 0;
        
        $data = $this->find_by_pk($order_id,false,$param);

        if(isset($data) AND array_filled($data)) {
            $data['items'] = $this->model_shop_item->find_all(
                array(
                    'where'=>array('item_order_id'=>$data['order_id'])
                ));
        }

        return $data;
    }



    //public function get_order($user_id)
    private function _get_order_list($user_id)
    {
        $param = array();
        $param['fields'] = 'order_id,order_paypal_date,item_id,item_product_id';

        $param['joins'][] = array(
                'table'=>'shop_item',
                'joint'=>'shop_order.order_id = shop_item.item_order_id');

        $param['where']["order_user_id"] = $user_id;
        $param['where']["order_payment_status"] = 1;
        return $this->find_all_active($param);        
    }

    public function get_suppliers($user_id)
    {
        $order_list = $this->_get_order_list($user_id);
        $suppliers = array();
        if(isset($order_list) AND array_filled($order_list)) {
            foreach($order_list as $value) {
                $data = $this->model_product->get_product_owner($value['item_product_id']);
                $suppliers[$value['item_product_id']]['order_id'] = $value['order_id'];
                $suppliers[$value['item_product_id']]['order_item_id'] = $value['item_id'];
                $suppliers[$value['item_product_id']]['order_date'] = $value['order_paypal_date'];

                // Product Info
                $suppliers[$value['item_product_id']]['product_id'] = $value['item_product_id'];
                $suppliers[$value['item_product_id']]['product_name'] = $data['product_name'];
                // Supplier Info
                $suppliers[$value['item_product_id']]['supplier_id'] = $data['user_id'];
                $suppliers[$value['item_product_id']]['supplier_name'] = ucfirst($data['user_firstname'] ." ". $data['user_lastname']);
                $suppliers[$value['item_product_id']]['supplier_username'] = $data['user_username'];
                $suppliers[$value['item_product_id']]['supplier_email'] = $data['user_email'];
            }
        }
        return $suppliers;
    }

    private function _get_order_list_all($user_id)
    {
        $param = array();
        $param['joins'][] = array(
                'table'=>'shop_item',
                'joint'=>'shop_order.order_id = shop_item.item_order_id');

        $param['where']["order_user_id"] = $user_id;
        $param['where']["order_payment_status"] = 1;
        return $this->find_all_active($param);        
    }
    public function get_supplier_orders($spplier_id)
    {
        $order_list = $this->_get_order_list_all($spplier_id);
        $data = array();
        if(isset($order_list) AND array_filled($order_list)) {
            foreach($order_list as $key=>$value) {
// Order Detail                
$data[$value['order_id']]['order_id'] = $value['order_id'];
$data[$value['order_id']]['order_user_id'] = $value['order_user_id'];
$data[$value['order_id']]['order_payment_status'] = $value['order_payment_status'];
$data[$value['order_id']]['order_ondate'] = $value['order_ondate'];
$data[$value['order_id']]['order_paypal_date'] = $value['order_paypal_date'];
$data[$value['order_id']]['order_billing_fname'] = $value['order_billing_fname'];
$data[$value['order_id']]['order_billing_lname'] = $value['order_billing_lname'];
$data[$value['order_id']]['order_billing_phone'] = $value['order_billing_phone'];
$data[$value['order_id']]['order_billing_email'] = $value['order_billing_email'];
$data[$value['order_id']]['order_billing_address'] = $value['order_billing_address'];
$data[$value['order_id']]['order_billing_city'] = $value['order_billing_city'];
$data[$value['order_id']]['order_billing_country'] = $value['order_billing_country'];
$data[$value['order_id']]['order_billing_zip_code'] = $value['order_billing_zip_code'];
// Items Array
$data[$value['order_id']]['items'][$value['item_id']]['item_id'] = $value['item_id'];
$data[$value['order_id']]['items'][$value['item_id']]['item_order_id'] = $value['item_order_id'];
$data[$value['order_id']]['items'][$value['item_id']]['item_product_id'] = $value['item_product_id'];
$data[$value['order_id']]['items'][$value['item_id']]['item_product_name'] = $value['item_product_name'];
$data[$value['order_id']]['items'][$value['item_id']]['item_product_img'] = $value['item_product_img'];
$data[$value['order_id']]['items'][$value['item_id']]['item_qty'] = $value['item_qty'];
$data[$value['order_id']]['items'][$value['item_id']]['item_rate'] = $value['item_rate'];
$data[$value['order_id']]['items'][$value['item_id']]['item_price'] = $value['item_price'];
$data[$value['order_id']]['items'][$value['item_id']]['item_postage_type'] = $value['item_postage_type'];
$data[$value['order_id']]['items'][$value['item_id']]['item_postage_type_msg'] = $value['item_postage_type_msg'];
$data[$value['order_id']]['items'][$value['item_id']]['item_postage_charges'] = $value['item_postage_charges'];

$data[$value['order_id']]['items'][$value['item_id']]['item_supplier_amount'] = $value['item_supplier_amount'];
$data[$value['order_id']]['items'][$value['item_id']]['item_admin_amount'] = $value['item_admin_amount'];
$data[$value['order_id']]['items'][$value['item_id']]['item_is_paid_supplier'] = $value['item_is_paid_supplier'];
$data[$value['order_id']]['items'][$value['item_id']]['item_shipping_status'] = $value['item_shipping_status'];

            }
        }

        return $data;
    }



    public function get_supplier_orders1($spplier_id)
    {
        $order_list = $this->_get_order_list_all($spplier_id);
        return $order_list;
    }


    public function get_total_transaction()
    {
        $param = array();
        $param['where']['order_user_id'] = $this->userid;
        if(PAYMENT_MODE_IS_TEST == FALSE)
            $param['where']['order_payment_status'] = 1;
        
        return $this->find_count($param);
    }

    /*
    * table             Table Name
    * Name              FIeld Name
    * label             Field Label / Textual Representation in form and DT headings
    * type              Field type : hidden, text, textarea, editor, etc etc. 
    *                                 Implementation in form_generator.php
    * type_dt           Type used by prepare_datatables method in controller to prepare DT value
    *                                 If left blank, prepare_datatable Will opt to use 'type'
    * type_filter_dt    Used by DT FILTER PREPRATION IN datatables.php
    * attributes        HTML Field Attributes
    * js_rules          Rules to be aplied in JS (form validation)
    * rules             Server side Validation. Supports CI Native rules

    * list_data         For dropdown etc, data in key-value pair that will populate dropdown 
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    * list_data_key     For dropdown etc, if you want to define list_data in CONTROLLER (public _list_data[$key]) list_data_key is the $key which identifies it
    *                   -----Incase list_data_key is not defined, it will look for field_name as a $key
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    */
    public function get_fields( $specific_field = "" )
    {
        $fields = array(
        
              'order_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_id',
                     'label'   => 'id #',
                     'type'   => 'hidden',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),

              'order_user_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_user_id',
                     'label'   => 'User ID',
                     'type'   => 'hidden',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),

              'order_payment_type' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_payment_type',
                     'label'   => 'Payment Type',
                     'type'   => 'hidden',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),


               'order_is_sandbox' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_is_sandbox',
                     'label'   => 'Status?',
                     'type'   => 'switch',
                     'type_dt'   => 'dropdown',
                     'type_filter_dt' => 'dropdown',
                     'list_data_key' => "order_is_sandbox" ,
                     'list_data' => array(),
                     'default'   => '1',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"7%"),
                     'rules'   => 'trim'
                  ),
 
             
              'order_agreed_terms_status' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_agreed_terms_status',
                     'label'   => 'Agreed terms status?',
                     'type'   => 'switch',
                     'type_dt'   => 'dropdown',
                     'type_filter_dt' => 'dropdown',
                     'list_data_key' => "order_agreed_terms_status" ,
                     'list_data' => array(),
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"7%"),
                     'rules'   => 'trim'
                  ),

              'order_payment_status' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_payment_status',
                     'label'   => 'Payment Status',
                     'type'   => 'dropdown',
                     'list_data'    => array(
                                        0 => "<span class=\"label label-danger\">Not Approved</span>" ,  
                                        1 => "<span class=\"label label-success\">Payment approved</span>"  ,
                                        2 => "<span class=\"label label-danger\">Declined</span>"  ,
                                        3 => "<span class=\"label label-danger\">Error</span>"  ,
                                        4 => "<span class=\"label label-danger\">Held for Review</span>" ,
                                        11=> "<span class=\"label label-danger\">Fruad Cause</span>",
                                        ) ,
                     'attributes'   => array(),
                     'js_rules'   => 'required',
                     'rules'   => 'required',
                  ),

                'order_delivery_status' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_delivery_status',
                     'label'   => 'Delivery Status',
                     'type'   => 'dropdown',
                     'list_data'    => array(
                                        0 =>  "<span class=\"label label-primary\">In Process</span>"  ,
                                        1 =>  "<span class=\"label label-success\">New order</span>"  ,
                                        2 =>  "<span class=\"label label-info\">Shipped</span>"  ,
                                        3 =>  "<span class=\"label label-warning\">On Hold</span>"  ,
                                        4 =>  "<span class=\"label label-danger\">Denied</span>" ,
                                        5 =>  "<span class=\"label label-danger\">Reject</span>" ,
                                        ) ,
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => '',
                  ),


                'order_shipping_type' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_shipping_type',
                     'label'   => 'Shipping type',
                     'type'   => 'dropdown',
                     'list_data'    => array(
                                        0 =>  "<span class=\"label label-success\">No Shipping Charges</span>"  ,
                                        1 =>  "<span class=\"label label-success\">Free</span>"  ,
                                        2 =>  "<span class=\"label label-success\">Pick in store</span>"  ,
                                        3 =>  "<span class=\"label label-success\">Cash on Delivery</span>"  ,
                                        4 =>  "<span class=\"label label-success\">DHL charges</span>"  ,
                                        ) ,
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => '',
                  ),

                'order_shipping_amount' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_shipping_amount',
                     'label'   => 'Shipping charges',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

                'order_tax_amount' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_tax_amount',
                     'label'   => 'Tax charges',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),
                
                'order_tax_percentage' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_tax_percentage',
                     'label'   => 'Tax Percentage',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

                'order_discount_amount' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_discount_amount',
                     'label'   => 'Discount Amount',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

                'order_coupon' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_coupon',
                     'label'   => 'Coupon',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

                'order_redeem_points' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_redeem_points',
                     'label'   => 'Redeem Points',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),
                'order_redeem_points_amount' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_redeem_points_amount',
                     'label'   => 'Redeem Points Amount',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

                'product_price' => array(
                     'table'   => $this->_table,
                     'name'   => 'product_price',
                     'label'   => 'Product Price',
                     'type'   => 'none',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

                'invoice_price' => array(
                     'table'   => $this->_table,
                     'name'   => 'invoice_price',
                     'label'   => 'Invoice Amount',
                     'type'   => 'none',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

                'order_billing_fname' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_billing_fname',
                     'label'   => 'Billing<br />First Name',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => 'required',
                     'rules'   => 'required|trim|htmlentities'
                  ),

                'order_billing_lname' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_billing_lname',
                     'label'   => 'Billing<br />Last Name',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => 'required',
                     'rules'   => 'required|trim|htmlentities'
                  ),

                'order_billing_phone' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_billing_phone',
                     'label'   => 'Billing<br />Phone',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities|max_length[15]'
                  ),

                'order_billing_email' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_billing_email',
                     'label'   => 'Billing<br />Email',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => 'required',
                     'rules'   => 'required|valid_email|strtolower|trim|htmlentities'
                  ),

                // 'order_billing_address' => array(
                //      'table'   => $this->_table,
                //      'name'   => 'order_billing_address',
                //      'label'   => 'Billing Address # 1',
                //      'type'   => 'text',
                //      'attributes'   => array(),
                //      'js_rules'   => 'required',
                //      'rules'   => 'required|trim|htmlentities'
                //   ),

                // 'order_billing_address2' => array(
                //      'table'   => $this->_table,
                //      'name'   => 'order_billing_address2',
                //      'label'   => 'Billing Address # 2',
                //      'type'   => 'text',
                //      'attributes'   => array(),
                //      'js_rules'   => '',
                //      'rules'   => 'trim|htmlentities'
                //   ),

                // 'order_billing_city' => array(
                //      'table'   => $this->_table,
                //      'name'   => 'order_billing_city',
                //      'label'   => 'Billing city',
                //      'type'   => 'text',
                //      'attributes'   => array(),
                //      'js_rules'   => '',
                //      'rules'   => 'trim|htmlentities'
                //   ),

                // 'order_billing_state' => array(
                //      'table'   => $this->_table,
                //      'name'   => 'order_billing_state',
                //      'label'   => 'Billing State',
                //      'type'   => 'text',
                //      'attributes'   => array(),
                //      'js_rules'   => '',
                //      'rules'   => 'trim|htmlentities'
                //   ),

                // 'order_billing_country' => array(
                //      'table'   => $this->_table,
                //      'name'   => 'order_billing_country',
                //      'label'   => 'Billing Country',
                //      'type'   => 'text',
                //      'attributes'   => array(),
                //      'js_rules'   => 'required',
                //      'rules'   => 'required|trim|htmlentities'
                //   ),

                // 'order_billing_zip_code' => array(
                //      'table'   => $this->_table,
                //      'name'   => 'order_billing_zip_code',
                //      'label'   => 'Billing Postal code',
                //      'type'   => 'text',
                //      'attributes'   => array(),
                //      'js_rules'   => '',
                //      'rules'   => 'trim|htmlentities|max_length[20]'
                //   ),

                'order_shipping_fname' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_shipping_fname',
                     'label'   => 'Shipping Frist Name',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

                'order_shipping_lname' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_shipping_lname',
                     'label'   => 'Shipping Last Name',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

                'order_shipping_phone' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_shipping_phone',
                     'label'   => 'Shipping Phone',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

                'order_shipping_email' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_shipping_email',
                     'label'   => 'Shipping Email',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'valid_email|strtolower|trim|htmlentities'
                  ),

                'order_shipping_address' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_shipping_address',
                     'label'   => 'Shipping Address # 1',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

                'order_shipping_address2' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_shipping_address2',
                     'label'   => 'Shipping Address # 2',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

                'order_shipping_city' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_shipping_city',
                     'label'   => 'Shipping city',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

                'order_shipping_state' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_shipping_state',
                     'label'   => 'Shipping State',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

                'order_shipping_country' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_shipping_country',
                     'label'   => 'Shipping Country',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

                'order_shipping_zip_code' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_shipping_zip_code',
                     'label'   => 'Shipping postal/zip code',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

                'order_shipping_order_description' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_shipping_order_description',
                     'label'   => 'order Note',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

                'order_notes' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_notes',
                     'label'   => 'Notes',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

              'order_paypal_mc_gross' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_paypal_mc_gross',
                     'label'   => 'Paypal gross',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

              'order_paypal_date' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_paypal_date',
                     'label'   => 'Paypal Date',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

              'order_paypal_payment_status' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_paypal_payment_status',
                     'label'   => 'Paypal Status',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

              'order_paypal_pending_reason' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_paypal_pending_reason',
                     'label'   => 'Paypal Pending reason',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

              'order_paypal_ReasonCode' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_paypal_ReasonCode',
                     'label'   => 'Paypal reason code',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

              'order_paypal_verify_sign' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_paypal_verify_sign',
                     'label'   => 'Paypal verify sign',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

              'order_paypal_txn_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_paypal_txn_id',
                     'label'   => 'Paypal txn id',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

              'order_paypal_payer_email' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_paypal_payer_email',
                     'label'   => 'Paypal Payer email id',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

              'order_paypal_ipn_track_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_paypal_ipn_track_id',
                     'label'   => 'Paypal<br />Invoice ID',//'Paypal Payer IPN id',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

              'order_payment_post' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_payment_post',
                     'label'   => 'Paypal payment post',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

              

              'order_status' => array(
                     'table'   => $this->_table,
                     'name'   => 'order_status',
                     'label'   => 'Order status?',
                     'type'   => 'switch',
                     'type_dt'   => 'dropdown',
                     'type_filter_dt' => 'dropdown',
                     'list_data_key' => "order_status" ,
                     'list_data' => array(),
                     'default'   => '1',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"7%"),
                     'rules'   => 'trim'
                  ),

              
            );
        
        if($specific_field)
            return $fields[ $specific_field ];
        else
            return $fields;
    }

}
?>