<?
class Model_shop_item extends MY_Model {
    /**
     * TKD shop_order MODEL
     *
     * @package     shop_order Model
     * @author      Muhammad Uzair Khan (Muhammad.Uzair@tradekey.com)
     * @version     2.0
     * @since       2014 / Amazingly corrupt models Corporation Inc.
     */

    protected $_table    = 'shop_item';
    protected $_field_prefix    = 'item_';
    protected $_pk    = 'item_id';
    protected $_status_field    = '';
    public $relations = array();
    public $pagination_params = array();
    public $dt_params = array();
    public $_per_page    = 20;
    
    function __construct()
    {
        // Call the Model constructor
        //$this->pagination_params['fields'] = "id,shipping_name,SUM(product_price) as product_price,status";
        
        // $this->pagination_params['fields'] = "ch_shop_order.id,ch_shop_order.shipping_name,
        //                                         CONCAT('$ ', SUM(ch_shop_item.product_price)+ch_shop_order.shipping_amount-ch_shop_order.discount_amount+ch_shop_order.tax_amount) as product_price , 
        //                                         ch_shop_order.payment_type , ch_shop_order.payment_status";

        // $this->pagination_params['joins'][] = array(
        //                                         'table'=>'shop_item',
        //                                         'joint'=>'ch_shop_order.id = ch_shop_item.order_id');

        // $this->pagination_params['group'] = 'ch_shop_order.id';

        parent::__construct();
    }


    public function get_data($vars)
    {
        return $this->find_all($vars);
    }
    
    public function find_order($course_id,$user_id)
    {
         
        if (!$user_id) {
            // Handle the case where user_id is not available
            return false;
        }
    
        $this->db->select('si.item_id, si.item_product_id, si.item_product_name, so.order_id');
        $this->db->from('shop_item si');
        $this->db->join('shop_order so', 'si.item_order_id = so.order_id', 'right'); // Right join to get all items
        $this->db->where('si.item_product_id', $course_id);
        $this->db->where('so.order_user_id', $user_id);
        $this->db->where('so.order_payment_status', 1); // Approved status
        
        $query = $this->db->get();
    
        // Check if the query returned any rows
        if ($query->num_rows() > 0) {
            return $query->row(); // Return the row data
        } else {
            return false; // No purchase found
        }
    }

    public function find_by_order_id($order_id)
    {
        $param=array();
        $param['where']['item_order_id'] = $order_id;
        return $this->find_all($param);
    }

    public function find_total_item_amount_by_order_id($order_id)
    {
        $data = $this->find_by_order_id($order_id);
        
        $total = 0;
        if(isset($data) AND array_filled($data))
        {
            foreach ($data as $key => $value) {
                $total += $value['item_price'];
            }
        }

        return $total;
    }    



    public function get_seller_detail($order_id)
    {
        $params[ 'joins' ] = array(
            array(
                "table" => "product",
                "joint" => "{pre}shop_item.item_product_id = {pre}product.product_id",
            ),
            array(
                "table" => "user",
                "joint" => "{pre}product.product_user_id = {pre}user.user_id AND {pre}user.user_connected_status = 1 AND {pre}user.user_status = 1",
            ),
        );


        $params[ 'where' ] = array(
            'item_order_id' =>  $order_id ,
        );

        $data = $this->find_all($params);


        $config_info = $this->model_config->find_by_pk(23);
        $admin_order_commision = isset($config_info['config_value']) ? $config_info['config_value'] : 5; //g('db.admin.admin_order_commision')


        $seller_data = array();
        if(isset($data) AND array_filled($data)) {
            $i = 0;
            foreach($data as $key=>$value){
                $seller_data[$value['user_id']]['user_id'] = $value['user_id'];
                $seller_data[$value['user_id']]['user_email'] = $value['user_email'];
                $seller_data[$value['user_id']]['seller_name'] = trim($value['user_firstname']." " . $value['user_lastname']);
                $seller_data[$value['user_id']]['user_connected_id'] = $value['user_connected_id'];
                $seller_data[$value['user_id']]['user_status'] = $value['user_status'];
                $seller_data[$value['user_id']]['user_connected_status'] = $value['user_connected_status'];

                $seller_data[$value['user_id']]['product'][$i]['item_id'] = $value['item_id'];
                $seller_data[$value['user_id']]['product'][$i]['item_stripe_id'] = $value['item_stripe_id'];

                $seller_data[$value['user_id']]['product'][$i]['item_product_id'] = $value['item_product_id'];
                $seller_data[$value['user_id']]['product'][$i]['item_product_name'] = $value['item_product_name'];
                $seller_data[$value['user_id']]['product'][$i]['item_product_img'] = $value['item_product_img'];
                $seller_data[$value['user_id']]['product'][$i]['item_qty'] = $value['item_qty'];
                $seller_data[$value['user_id']]['product'][$i]['item_rate'] = $value['item_rate'];
                $seller_data[$value['user_id']]['product'][$i]['item_price'] = $value['item_price'];
                
                $seller_data[$value['user_id']]['product'][$i]['admin_fees'] = $admin_fees = ($value['item_price']*$admin_order_commision)/100;
                $seller_data[$value['user_id']]['product'][$i]['seller_amount'] = $value['item_price']-$admin_fees;

                $i++;
            }
        }

        return $seller_data;
    }

    /*
    * table             Table Name
    * Name              FIeld Name
    * label             Field Label / Textual Representation in form and DT headings
    * type              Field type : hidden, text, textarea, editor, etc etc. 
    *                                 Implementation in form_generator.php
    * type_dt           Type used by prepare_datatables method in controller to prepare DT value
    *                                 If left blank, prepare_datatable Will opt to use 'type'
    * type_filter_dt    Used by DT FILTER PREPRATION IN datatables.php
    * attributes        HTML Field Attributes
    * js_rules          Rules to be aplied in JS (form validation)
    * rules             Server side Validation. Supports CI Native rules

    * list_data         For dropdown etc, data in key-value pair that will populate dropdown 
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    * list_data_key     For dropdown etc, if you want to define list_data in CONTROLLER (public _list_data[$key]) list_data_key is the $key which identifies it
    *                   -----Incase list_data_key is not defined, it will look for field_name as a $key
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    */
    public function get_fields( $specific_field = "" )
    {
        $fields = array(
        
              'item_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'item_id',
                     'label'   => 'id #',
                     'type'   => 'hidden',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),

              'item_order_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'item_order_id',
                     'label'   => 'Order ID #',
                     'type'   => 'hidden',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),

              'item_product_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'item_product_id',
                     'label'   => 'Product ID #',
                     'type'   => 'hidden',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),


              'item_product_name' => array(
                     'table'   => $this->_table,
                     'name'   => 'item_product_name',
                     'label'   => 'Product Name',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

              'item_product_img' => array(
                     'table'   => $this->_table,
                     'name'   => 'item_product_img',
                     'label'   => 'Product Img',
                     'type'   => 'textarea',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),


              'item_qty' => array(
                     'table'   => $this->_table,
                     'name'   => 'item_qty',
                     'label'   => 'Item Qty',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

              'item_rate' => array(
                     'table'   => $this->_table,
                     'name'   => 'item_rate',
                     'label'   => 'Item Qty',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

              'item_price' => array(
                     'table'   => $this->_table,
                     'name'   => 'item_price',
                     'label'   => 'Item Price',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

              'item_serialize' => array(
                     'table'   => $this->_table,
                     'name'   => 'item_serialize',
                     'label'   => 'Serialize',
                     'type'   => 'textarea',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

              'item_stripe_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'item_stripe_id',
                     'label'   => 'Stripe ID',
                     'type'   => 'textarea',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

              'item_stripe_data' => array(
                     'table'   => $this->_table,
                     'name'   => 'item_stripe_data',
                     'label'   => 'Stripe Data Serialize',
                     'type'   => 'textarea',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),


              'item_type' => array(
                     'table'   => $this->_table,
                     'name'   => 'item_type',
                     'label'   => 'Type?',
                     'list_data'    => array(
                            1 =>  "<span class=\"label label-success\">Pack Size Product</span>"  ,
                            2 =>  "<span class=\"label label-primary\">Size Product</span>"  ,
                            ) ,
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => '',
                  ),
            );
        
        if($specific_field)
            return $fields[ $specific_field ];
        else
            return $fields;
    }

}
?>