<?
class Model_service_quote extends MY_Model
{
    /**
     * Service Profile MODEL
     *
     * @package     Service Profile Model
     * @version     1.0
     * @since       2018
     */

    protected $_table = 'service_quote';
    protected $_field_prefix = 'sq_';
    protected $_pk = 'sq_id';
    protected $_status_field = 'sq_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page = 20;

    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "sq_id,sq_profile_id,sq_service_id,sq_client_id,sq_phone,sq_status";
        parent::__construct();
    }

    public function get_by_pk_email_notification($id)
    {
        $param = array();
        $param['fields'] = 'sq_id,sq_profile_id,sq_service_id,sq_client_id,sq_schedule,sq_name as client_name,sq_phone as client_phone,
        sq_email as client_email,sq_description as client_desc,sq_status,sq_createdon,
        user_id as provider_id,{pre}user.user_email as provider_email,{pre}user.user_firstname as provider_name,
        {pre}product.product_name as service_name';
        $param['joins'][] = array(
                        'table' => '{pre}user',
                        'joint' => '{pre}user.user_id = {pre}service_quote.sq_profile_id',
                        'type' => 'INNER');
        $param['joins'][] = array(
                        'table' => '{pre}product',
                        'joint' => '{pre}service_quote.sq_service_id = {pre}product.product_id',
                        'type' => 'INNER');
        return $this->find_by_pk($id,false,$param);
    }
    
    public function get_quote_by_profile_id($profile_id)
    {
        $param['where']['sq_profile_id'] = $profile_id;
        $param['joins'][] = array(
                        'table' => '{pre}user',
                        'joint' => '{pre}user.user_id = {pre}service_quote.sq_client_id',
                        'type' => 'INNER');
        $param['joins'][] = array(
                        'table' => '{pre}service',
                        'joint' => '{pre}service.s_id = {pre}service_quote.sq_service_id',
                        'type' => 'INNER');
        return $this->find_all($param);
    }

    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */
    public function get_fields($specific_field = "")
    {
        $fields = array(

            'sq_id' => array(
                'table' => $this->_table,
                'name' => 'sq_id',
                'label' => 'id #',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => 'trim'
            ),

            'sq_profile_id' => array(
                   'table'   => $this->_table,
                   'name'   => 'sq_profile_id',
                   'label'   => 'Profile',
                   'type'   => 'dropdown',
                   'attributes'   => array(),
                   'js_rules'   => 'required',
                   'rules'   => 'required|trim',
                ),

            'sq_service_id' => array(
                   'table'   => $this->_table,
                   'name'   => 'sq_service_id',
                   'label'   => 'Service',
                   'type'   => 'dropdown',
                   'attributes'   => array(),
                   'js_rules'   => 'required',
                   'rules'   => 'required|trim',
                ),

            'sq_client_id' => array(
                   'table'   => $this->_table,
                   'name'   => 'sq_client_id',
                   'label'   => 'Client',
                   'type'   => 'dropdown',
                   'attributes'   => array(),
                   'js_rules'   => 'required',
                   'rules'   => 'required|trim',
                ),

            'sq_name' => array(
                'table' => $this->_table,
                'name' => 'sq_name',
                'label' => 'Client Name',
                'type' => 'text',
                'attributes' => array(),
                'js_rules'   => 'required',
                'rules'   => 'required|trim',
            ),


            'sq_phone' => array(
                'table' => $this->_table,
                'name' => 'sq_phone',
                'label' => 'Phone',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),


            'sq_email' => array(
                'table' => $this->_table,
                'name' => 'sq_email',
                'label' => 'Email',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities|valid_email'
            ),


            'sq_schedule' => array(
                'table' => $this->_table,
                'name' => 'sq_schedule',
                'label' => 'Schedule',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),


            'sq_description' => array(
                'table' => $this->_table,
                'name' => 'sq_description',
                'label' => 'Description',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            
            'sq_status' => array(
                'table' => $this->_table,
                'name' => 'sq_status',
                'label' => 'Status?',
                'type' => 'switch',
                'type_dt' => 'switch',
                'type_filter_dt' => 'dropdown',
                'list_data' => array(),
                'default' => '1',
                'attributes' => array(),
                'dt_attributes' => array("width" => "7%"),
                'rules' => 'trim'
            ),

        );

        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;

    }

}

?>