<?
class Model_result_quiz extends MY_Model
{
    /**
     * banner MODEL
     *
     * @package     banner Model
     * @version     1.0
     * @since       2017
     */

    protected $_table = 'result_quiz';
    protected $_field_prefix = 'rq_';
    protected $_pk = 'rq_id';
    protected $_status_field = 'rq_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page = 20;

    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "";

        parent::__construct();
    }


    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */
    public function get_fields($specific_field = "")
    {

        $fields = array(
            'rq_id' => array(
                'table' => $this->_table,
                'name' => 'rq_id',
                'label' => 'id #',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => 'trim'
            ),

            'rq_result_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'rq_result_id',
                     'label'   => 'Result #',
                     'type'   => 'dropdown',
                     'type_dt'   => 'text',
                     'type_filter_dt'   => 'dropdown',
                     'js_rules'   => '',
                     'rules'   => 'trim',
                ),

            'rq_course_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'rq_course_id',
                     'label'   => 'Course #',
                     'type'   => 'dropdown',
                     'type_dt'   => 'text',
                     'type_filter_dt'   => 'dropdown',
                     'js_rules'   => '',
                     'rules'   => 'trim',
                ),

            'rq_subject_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'rq_subject_id',
                     'label'   => 'Subject #',
                     'type'   => 'dropdown',
                     'type_dt'   => 'text',
                     'type_filter_dt'   => 'dropdown',
                     'js_rules'   => '',
                     'rules'   => 'trim',
                ),

            'rq_question_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'rq_question_id',
                     'label'   => 'Question #',
                     'type'   => 'dropdown',
                     'type_dt'   => 'text',
                     'type_filter_dt'   => 'dropdown',
                     'js_rules'   => '',
                     'rules'   => 'trim',
                ),

            'rq_answer' => array(
                'table' => $this->_table,
                'name' => 'rq_answer',
                'label' => 'Your Answer',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            'rq_points' => array(
                'table' => $this->_table,
                'name' => 'rq_points',
                'label' => 'Points',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),
            
            'rq_feedback' => array(
                'table' => $this->_table,
                'name' => 'rq_feedback',
                'label' => 'Teacher Feedback',
                'type' => 'textarea',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            
            'rq_is_correct_asnwer' => array(
                     'table'   => $this->_table,
                     'name'   => 'rq_is_correct_asnwer',
                     'label'   => 'Is Correct Answer?',
                     'type'   => 'switch',
                     'type_dt'   => 'dropdown',
                     'type_filter_dt' => 'dropdown',
                     'list_data_key' => "product_status" ,
                     'list_data'    => array(
                                    1 => "PASS",
                                    0 => "FAIL",
                                ) ,
                     'default'   => '0',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"7%"),
                     'rules'   => 'trim'
            ),

        );

        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;

    }

    /**
     * Get all answers for a given user and quiz, including correct answers from question_bank
     * @param int $user_id
     * @param int $quiz_id
     * @return array
     */
    public function get_user_quiz_answers($user_id, $quiz_id) {
        $this->db->select('rq.rq_question_id as qb_id, rq.rq_answer as user_answer, qb.qb_correct_answer as correct_answer');
        $this->db->from('result_quiz rq');
        $this->db->join('quiz_questions qq', 'qq.qq_question_id = rq.rq_question_id AND qq.qq_quiz_id = rq.rq_quiz_id', 'left');
        $this->db->join('question_bank qb', 'qb.qb_id = rq.rq_question_id', 'left');
        $this->db->where('rq.rq_user_id', $user_id);
        $this->db->where('rq.rq_quiz_id', $quiz_id);
        $query = $this->db->get();
        return $query->result_array();
    }

}

?>