<?
class Model_result extends MY_Model
{
    /**
     * banner MODEL
     *
     * @package     banner Model
     * @version     1.0
     * @since       2017
     */

    protected $_table = 'result';
    protected $_field_prefix = 'r_';
    protected $_pk = 'r_id';
    protected $_status_field = 'r_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page = 20;

    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "";

        parent::__construct();
    }

    public function join_user($type="" , $append_joint ="" , $prepend_joint = "")
    {
        $joint = $prepend_joint . "r_user_id = user_id " . $append_joint ; 
        return $this->prep_join("user" , $joint, $type );
    }

    public function join_course($type="" , $append_joint ="" , $prepend_joint = "")
    {
        $joint = $prepend_joint . "r_course_id = course_id " . $append_joint ; 
        return $this->prep_join("course" , $joint, $type );
    }

    public function get_attempt_course_listing($user_id)
    {
        $param['joins'][] = $this->join_course();
        $param['where']['r_user_id'] = $user_id;
        $param['group'] = 'r_course_id';
        $data = $this->find_all_active($param);
        
        $var = array();
        if(isset($data) AND array_filled($data))
        {
            foreach($data as $key=>$value) {
                $var[$key]['result_id'] = $value['r_id'];
                $var[$key]['course_id'] = $value['course_id'];
                $var[$key]['course_name'] = $value['course_name'];
            }
        }
        return $var;        
    }
//mtech
    public function get_attempt_course_quiz($user_id, $quiz_id)
    {
        $param['joins'][] = $this->join_course();
        $param['where']['r_user_id'] = $user_id;
        $param['where']['r_quiz_id'] = $quiz_id;
     
        $data = $this->find_all_active($param);
        
        $var = array();
        if(isset($data) AND array_filled($data))
        {
            foreach($data as $key=>$value) {
                $var[$key]['result_id'] = $value['r_id'];
                $var[$key]['course_id'] = $value['course_id'];
                $var[$key]['course_name'] = $value['course_name'];
            }
        }
        $row_count = isset($data) ? count($data) : 0;

        $arr['row_count'] = $row_count;        
        return $arr;        
    }
//mtech
    // Widget LeaderBoard for COURSES
    public function get_leaderboard_course($course_id)
    {
        $param['fields']  = 'ps_result.r_avg,TIMEDIFF(ps_result.r_end_date,ps_result.r_start_date) AS duration,ps_user.user_firstname,ps_user.user_lastname,ps_user_info.ui_country_id';
        $param['joins'][] = $this->join_user();
        $param['joins'][] = array(
                        'table' => 'ps_user_info',
                        'joint' => 'ps_user.user_id = ps_user_info.ui_user_id',
                            );

        $param['where']['r_course_id'] = $course_id;
        $param['where']['r_is_pass'] = 1;
        $param['group'] = 'ps_user.user_id';
        $param['order'] = 'ps_result.r_avg DESC,duration ASC';
        $param['limit'] = 10;
        return $this->find_all_active($param);
        // $data = $this->find_all_active($param);
        // debug($this->db->last_query(),1);
    }


    public function get_result_ranking($course_id)
    {
        $param['fields']  = 'ps_result.r_avg,ps_user.user_id,ps_user.user_firstname,ps_user.user_lastname,ps_user_info.ui_country_id';
        $param['joins'][] = $this->join_user();
        $param['joins'][] = array(
                        'table' => 'ps_user_info',
                        'joint' => 'ps_user.user_id = ps_user_info.ui_user_id',
                            );

        $param['where']['r_course_id'] = $course_id;
        $param['where']['r_is_pass'] = 1;
        $param['group'] = 'ps_user.user_id';
        $param['order'] = 'ps_result.r_avg DESC';
        //$param['limit'] = 10;
        return $this->find_all_active($param);
    }


    public function user_ranking($userid,$course_id)
    {
      $result_data = $this->get_result_ranking($course_id);
      $ranking = '-';
      $total = '-';
      if (isset($result_data) AND array_filled($result_data)) {
        $i=1;
       foreach($result_data as $value) {
        if($value['user_id'] == $userid) {
          $ranking = $i;
        }
        $total = $i;
        $i++;
       }
      }

      $data = array();
      $data['total'] = $total;
      $data['ranking'] = $ranking;
      return $data;
    }


    public function get_data_by_pk($result_id)
    {
        $param = array();
        $data = $this->find_by_pk_active($result_id);
        if(isset($data) AND array_filled($data))
        {
            $param = array();
            $param['where']['rq_result_id'] = $result_id;
            $data['result'] = $this->model_result_quiz->find_all($param);
        }
        return $data;
    }

    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */
    public function get_fields($specific_field = "")
    {

        $fields = array(
            'r_id' => array(
                'table' => $this->_table,
                'name' => 'r_id',
                'label' => 'id #',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => 'trim'
            ),

            'r_user_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'r_user_id',
                     'label'   => 'User',
                     'type'   => 'dropdown',
                     'type_dt'   => 'text',
                     'type_filter_dt'   => 'dropdown',
                     'js_rules'   => '',
                     'rules'   => 'trim',
                ),

            'r_course_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'r_course_id',
                     'label'   => 'Course #',
                     'type'   => 'dropdown',
                     'type_dt'   => 'text',
                     'type_filter_dt'   => 'dropdown',
                     'js_rules'   => '',
                     'rules'   => 'trim',
                ),

            'r_quiz_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'r_quiz_id',
                     'label'   => 'Course #',
                     'type'   => 'dropdown',
                     'type_dt'   => 'text',
                     'type_filter_dt'   => 'dropdown',
                     'js_rules'   => '',
                     'rules'   => 'trim',
                ),

            'r_start_date' => array(
                'table' => $this->_table,
                'name' => 'r_start_date',
                'label' => 'Start Date',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            'r_end_date' => array(
                'table' => $this->_table,
                'name' => 'r_end_date',
                'label' => 'End Date',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            'r_total_quiz' => array(
                'table' => $this->_table,
                'name' => 'r_total_quiz',
                'label' => 'Total Quiz',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            'r_correct' => array(
                'table' => $this->_table,
                'name' => 'r_correct',
                'label' => 'Correct Answer',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            'r_wrong' => array(
                'table' => $this->_table,
                'name' => 'r_wrong',
                'label' => 'Wrong Answer',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            'r_avg' => array(
                'table' => $this->_table,
                'name' => 'r_avg',
                'label' => 'Avg',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            'r_points' => array(
                'table' => $this->_table,
                'name' => 'r_points',
                'label' => 'Total Points',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),
            
            'r_time_spent' => array(
                'table' => $this->_table,
                'name' => 'r_time_spent',
                'label' => 'Total Time Spent',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            'r_is_pass' => array(
                     'table'   => $this->_table,
                     'name'   => 'r_is_pass',
                     'label'   => 'Is Pass?',
                     'type'   => 'switch',
                     'type_dt'   => 'dropdown',
                     'type_filter_dt' => 'dropdown',
                     'list_data_key' => "r_is_pass" ,
                     'list_data'    => array(
                                    1 => "PASS",
                                    0 => "FAIL",
                                ) ,
                     'default'   => '0',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"7%"),
                     'rules'   => 'trim'
                  ),

            'r_status' => array(
                     'table'   => $this->_table,
                     'name'   => 'r_status',
                     'label'   => 'Status?',
                     'type'   => 'switch',
                     'type_dt'   => 'dropdown',
                     'type_filter_dt' => 'dropdown',
                     'list_data_key' => "product_status" ,
                     'list_data'    => array(
                                0 => "<span class=\"label label-default\">NO</span>" ,  
                                1 =>  "<span class=\"label label-primary\">YES</span>"  
                                ) ,
                     'default'   => '0',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"7%"),
                     'rules'   => 'trim'
                  ),

        );

        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;

    }

}

?>