<?
class Model_quiz_user_assignment extends MY_Model
{
    /**
     * @package     quiz_user_assignment Model
     * @version     1.0
     * @since       2025
     */

    protected $_table = 'quiz_user_assignment';
    protected $_field_prefix = '';
    protected $_pk = 'id';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page = 20;

    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "id,quiz_id,user_id,group_id,due_date,penalty_rate";
        parent::__construct();
    }

    /*
    * Obtener asignaciones de quiz para un usuario específico
    */
    public function get_assignments_by_user($user_id)
    {
        $params = array();
        $params['where']['user_id'] = $user_id;
        return $this->find_all($params);
    }
    
    /*
     * Verificar si un quiz está asignado a un estudiante (directamente o mediante grupo)
     */
    public function is_quiz_assigned_to_user($quiz_id, $user_id)
    {
        // Buscar asignación directa
        $params = array();
        $params['where']['quiz_id'] = $quiz_id;
        $params['where']['user_id'] = $user_id;
        $direct_assignment = $this->find_one($params);
        
        if ($direct_assignment) {
            return $direct_assignment;
        }
        
        // Buscar asignación por grupo
        $this->load->model('model_assignment_group_member');
        
        // Obtener grupos del usuario
        $user_groups = $this->model_assignment_group_member->get_user_groups($user_id);
        
        if (!empty($user_groups)) {
            $group_ids = array();
            foreach ($user_groups as $group) {
                $group_ids[] = $group->assignment_group_id;
            }
            
            if (!empty($group_ids)) {
                // Buscar asignaciones por grupo
                $this->db->where('quiz_id', $quiz_id);
                $this->db->where_in('group_id', $group_ids);
                $group_assignment = $this->db->get($this->_table)->row();
                
                if ($group_assignment) {
                    return $group_assignment;
                }
            }
        }
        
        return false;
    }

    /*
     * Obtener todos los quizzes asignados a un usuario (directamente o por grupo)
     */
    public function get_all_assignments_for_user($user_id)
    {
        // Primero obtenemos asignaciones directas
        $direct_assignments = $this->get_assignments_by_user($user_id);
        
        // Luego obtenemos asignaciones por grupo
        $this->load->model('model_assignment_group_member');
        $user_groups = $this->model_assignment_group_member->get_user_groups($user_id);
        
        $all_assignments = $direct_assignments;
        
        if (!empty($user_groups)) {
            $group_ids = array();
            foreach ($user_groups as $group) {
                $group_ids[] = $group->assignment_group_id;
            }
            
            if (!empty($group_ids)) {
                // Obtener asignaciones por grupo
                $this->db->where_in('group_id', $group_ids);
                $group_assignments = $this->db->get($this->_table)->result();
                
                if (!empty($group_assignments)) {
                    // Combinar todas las asignaciones
                    $all_assignments = array_merge($all_assignments, $group_assignments);
                }
            }
        }
        
        return $all_assignments;
    }

    /*
    * Obtener asignaciones de quiz para un grupo específico
    */
    public function get_assignments_by_group($group_id)
    {
        $params = array();
        $params['where']['group_id'] = $group_id;
        return $this->find_all($params);
    }

    /*
    * Obtener asignaciones para un quiz específico
    */
    public function get_assignments_by_quiz($quiz_id)
    {
        $params = array();
        $params['where']['quiz_id'] = $quiz_id;
        return $this->find_all($params);
    }

    /*
    * Calcular penalización por entrega tardía
    */
    public function calculate_penalty($quiz_id, $user_id, $submission_date)
    {
        // Obtener la asignación específica para este usuario y quiz
        $params = array();
        $params['where']['quiz_id'] = $quiz_id;
        $params['where']['user_id'] = $user_id;
        $assignment = $this->find_one($params);
        
        // Si no hay asignación específica para el usuario, verificar si pertenece a un grupo
        if (!$assignment) {
            // Aquí se podría buscar por grupo, pero necesitaríamos saber a qué grupos pertenece el usuario
            // Por ahora, obtener el quiz general
            $this->load->model('model_quiz');
            $quiz = $this->model_quiz->find_by_pk($quiz_id);
            
            if (!$quiz) {
                return 0; // No hay penalización si no hay quiz
            }
            
            // Usar la fecha de vencimiento y penalización estándar del quiz
            $due_date = $quiz->quiz_enddate;
            $penalty_rate = $quiz->quiz_daily_penalty;
        } else {
            // Usar la fecha de vencimiento y penalización personalizada
            $due_date = $assignment->due_date;
            $penalty_rate = $assignment->penalty_rate;
        }
        
        // Si no hay fecha de vencimiento o la penalización es 0, no hay penalización
        if (!$due_date || $penalty_rate <= 0) {
            return 0;
        }
        
        // Convertir fechas a objetos DateTime
        $due_date = new DateTime($due_date);
        $submission_date = new DateTime($submission_date);
        
        // Calcular días de retraso
        $interval = $due_date->diff($submission_date);
        $days_late = $interval->days;
        
        // Si la entrega es antes de la fecha de vencimiento, no hay penalización
        if ($submission_date <= $due_date) {
            return 0;
        }
        
        // Calcular penalización
        $penalty = $days_late * $penalty_rate / 100; // Convertir porcentaje a decimal
        
        // Limitar la penalización al 100%
        return min($penalty, 1);
    }

    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */
    public function get_fields($specific_field = "")
    {
        $fields = array(
            'id' => array(
                'table' => $this->_table,
                'name' => 'id',
                'label' => 'ID #',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => 'trim'
            ),

            'quiz_id' => array(
                'table' => $this->_table,
                'name' => 'quiz_id',
                'label' => 'Quiz',
                'type' => 'dropdown',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim'
            ),

            'user_id' => array(
                'table' => $this->_table,
                'name' => 'user_id',
                'label' => 'User',
                'type' => 'dropdown',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim'
            ),

            'group_id' => array(
                'table' => $this->_table,
                'name' => 'group_id',
                'label' => 'Group',
                'type' => 'dropdown',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim'
            ),

            'due_date' => array(
                'table' => $this->_table,
                'name' => 'due_date',
                'label' => 'Due Date',
                'type' => 'date',
                'attributes' => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim'
            ),

            'penalty_rate' => array(
                'table' => $this->_table,
                'name' => 'penalty_rate',
                'label' => 'Penalty Rate (%)',
                'type' => 'number',
                'attributes' => array('min' => '0', 'max' => '100', 'step' => '0.1'),
                'js_rules' => '',
                'rules' => 'trim'
            ),
        );

        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;
    }
}
?>
