<?
class Model_quiz_bank extends MY_Model
{
    /**
     * @package     quiz Model
     * @version     1.0
     * @since       2018
     */

    protected $_table = 'quiz';
    protected $_field_prefix = 'quiz_';
    protected $_pk = 'quiz_id';
    protected $_status_field = 'quiz_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page = 20;

    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "quiz_id,quiz_course_id,quiz_subject_id,quiz_name,quiz_status";
        parent::__construct();
    }

    public function get_data_by_id($id)
    {
        $status_fld = $this->get_table_status_field();
        $param = array();
        $param['where']['quiz_subject_id'] = $id;
        $param['order'] = 'quiz_id DESC';
        $param['where']["$status_fld !="] = 2 ;
        return $this->find_all($param);
    }


    
    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */
    public function get_fields($specific_field = "")
    {
        // Use when edit
        $is_required_image = (($this->uri->segment(4)!=null) && intval($this->uri->segment(4)))?'':'required';

        $fields = array(

            'quiz_id' => array(
                'table' => $this->_table,
                'name' => 'quiz_id',
                'label' => 'id #',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => 'trim'
            ),


            'quiz_course_id' => array(
                'table' => $this->_table,
                'name' => 'quiz_course_id',
                'label' => 'Course #',
                'type' => 'dropdown',
                'attributes'   => array(
                    "class"=>"ajax-populate",
                    "additional" => 'data-target="quiz-quiz_subject_id"'
                ),
                // 'list_data'    => array(
                //         "1"=>"Measure Your Energy Levels",
                //         "2"=>"Dosha Quiz",
                //         "3"=>"Measure Your Well-Being",) ,
                //'attributes'   => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),

            'quiz_subject_id' => array(
                   'table'   => $this->_table,
                   'name'   => 'quiz_subject_id',
                   'label'   => 'Subject',
                   'type'   => 'dropdown',
                   'type_dt'   => 'dropdown',
                   'type_filter_dt'   => 'dropdown',
                   'attributes'   => array("class"=>"ajax-populate",
                                           "additional" => ' 
                                                data-populate-uri="get_list"
                                                data-uri="quiz"
                                                data-dd_key="course_subject_id"
                                                data-dd_value="course_subject_name"'
                                      ),
                   'js_rules'   => 'required',
                   'rules'   => 'required|trim'
                ),



            'quiz_name' => array(
                'table' => $this->_table,
                'name' => 'quiz_name',
                'label' => 'Name',
                'type' => 'text',
                'attributes'   => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),

            'quiz_startdate' => array(
                'table' => $this->_table,
                'name' => 'quiz_startdate',
                'label' => 'Release date',//'Start date',
                'type' => 'date',
                'attributes' => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),
            'quiz_enddate' => array(
                'table' => $this->_table,
                'name' => 'quiz_enddate',
                'label' => 'Due date',//'End Date',
                'type' => 'date',
                'attributes'   => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),

            'quiz_status' => array(
                'table' => $this->_table,
                'name' => 'quiz_status',
                'label' => 'Status?',
                'type' => 'switch',
                'type_dt' => 'switch',
                'type_filter_dt' => 'dropdown',
                'list_data' => array(),
                'default' => '1',
                'attributes' => array(),
                'dt_attributes' => array("width" => "7%"),
                'rules' => 'trim'
            ),
        );

        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;

    }

}

?>