<?
class Model_quiz extends MY_Model
{
    /**
     * @package     quiz Model
     * @version     1.0
     * @since       2018
     */

    protected $_table = 'quiz';
    protected $_field_prefix = 'quiz_';
    protected $_pk = 'quiz_id';
    protected $_status_field = 'quiz_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page = 20;

    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "quiz_id,quiz_course_id,quiz_subject_id,assignment,quiz_name,quiz_status";


        parent::__construct();
    }

    public function get_data_by_id($id)
    {
        $status_fld = $this->get_table_status_field();
        $param = array();
        $param['where']['quiz_subject_id'] = $id;
        $param['order'] = 'quiz_id DESC';
        $param['where']["$status_fld !="] = 2 ;
        return $this->find_all($param);
    }


    
    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */
    public function get_fields($specific_field = "")
    {
        // Use when edit
        $is_required_image = (($this->uri->segment(4)!=null) && intval($this->uri->segment(4)))?'':'required';

        $fields = array(

            'quiz_id' => array(
                'table' => $this->_table,
                'name' => 'quiz_id',
                'label' => 'id #',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => 'trim'
            ),


            'quiz_course_id' => array(
                'table' => $this->_table,
                'name' => 'quiz_course_id',
                'label' => 'Course #',
                'type' => 'dropdown',
                'attributes'   => array(
                    "class"=>"ajax-populate",
                    "additional" => 'data-target="quiz-assignment,quiz-quiz_subject_id"'
                ),
                // 'list_data'    => array(
                //         "1"=>"Measure Your Energy Levels",
                //         "2"=>"Dosha Quiz",
                //         "3"=>"Measure Your Well-Being",) ,
                //'attributes'   => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),

            'quiz_subject_id' => array(
                   'table'   => $this->_table,
                   'name'   => 'quiz_subject_id',
                   'label'   => 'Subject',
                   'type'   => 'dropdown',
                   'type_dt'   => 'dropdown',
                   'type_filter_dt'   => 'dropdown',
                   'attributes'   => array("class"=>"ajax-populate",
                                           "additional" => ' 
                                                data-populate-uri="get_list"
                                                data-uri="quiz"
                                                data-dd_key="course_subject_id"
                                                data-dd_value="course_subject_name"'
                                      ),
                   'js_rules'   => 'required',
                   'rules'   => 'required|trim'
                ),



            'quiz_name' => array(
                'table' => $this->_table,
                'name' => 'quiz_name',
                'label' => 'Name',
                'type' => 'text',
                'attributes'   => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),

            'quiz_startdate' => array(
                'table' => $this->_table,
                'name' => 'quiz_startdate',
                'label' => 'Available From',//'Start date',
                'type' => 'date',
                'attributes' => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),
            'quiz_enddate' => array(
                'table' => $this->_table,
                'name' => 'quiz_enddate',
                'label' => 'Due ',//'End Date',
                'type' => 'date',
                'attributes'   => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),
            'quiz_untildate' => array(
                'table' => $this->_table,
                'name' => 'quiz_untildate',
                'label' => 'Until',//'Extended End Date',
                'type' => 'date',
                'attributes' => array('default' => 'NULL', 'exclude_today' => true, 'not_required' => true),
                'js_rules' => '',
                'rules' => 'trim'
            ),
            'quiz_type' => array(
                'table' => $this->_table,
                'name' => 'quiz_type',
                'label' => 'Quiz Type',
                'type' => 'dropdown',
                'list_data' => array(
                    "1" => "Practice Quiz",
                    "2" => "Graded Quiz",
                ),
                'default' => '1', 
                'attributes' => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),
            'assignment' => array(
                'table' => $this->_table,
                'name' => 'assignment',
                'label' => 'Assignment',
                'type' => 'dropdown',
                // 'list_data' => array(
                //     "1" => "Gateway Survey",
                //     "2" => "Perusall Assignment",
                //     "3" => "Weekly Quizzes",
                //     "4" => "Class Activities",
                //     "5" => "Major Exams (3 total)",
                //     "6" => "Final Exam",
                // ),
                'attributes'   => array("class"=>"ajax-populate",
                                           "additional" => ' 
                                                data-populate-uri="get_list"
                                                data-uri="assignment_group"
                                                data-dd_key="assignment_group_id"
                                                data-dd_value="assignment_group_name"'
                                      ),
                'js_rules' => 'required',
                'rules' => 'trim'
            ),
        
            'quiz_status' => array(
                'table' => $this->_table,
                'name' => 'quiz_status',
                'label' => 'Status?',
                'type' => 'switch',
                'type_dt' => 'switch',
                'type_filter_dt' => 'dropdown',
                'list_data' => array(),
                'default' => '1',
                'attributes' => array(),
                'dt_attributes' => array("width" => "7%"),
                'rules' => 'trim'
            ),
            
            'quiz_shuffle_answers' => array(
            'table' => $this->_table,
            'name' => 'quiz_shuffle_answers',
            'label' => 'Shuffle Answers?',
            'type' => 'dropdown',
            'list_data' => array(
                "1" => "Yes",
                "0" => "No",
            ),
            'default' => '0',
            'attributes' => array('default' => '0'),
            'rules' => 'trim'
        ),
        'quiz_time_limit' => array(
            'table' => $this->_table,
            'name' => 'quiz_time_limit',
            'label' => 'Time Limit?',
            'type' => 'dropdown',
            'list_data' => array(
                "1" => "Yes",
                "0" => "No",
            ),
            'default' => '0',
            'attributes' => array('id' => 'time_limit','default' => '0'),
            'rules' => 'trim'
        ),
             'quiz_time_limit_minutes' => array(
                'table' => $this->_table,
                'name' => 'quiz_time_limit_minutes',
                'label' => 'Time Limit (minutes)',
                'type' => 'number',
                'attributes' => array('min' => '0', 'class' => 'form-control', 'style' => 'width: auto; display: inline-block; margin-left: 10px;', 'id' => 'time_limit_minutes'),
                'js_rules' => '',
                'rules' => 'trim',
                'depends_on' => 'quiz_time_limit'
            ),
        'quiz_require_access_code' => array(
            'table' => $this->_table,
            'name' => 'quiz_require_access_code',
            'label' => 'Require Access Code?',
            'type' => 'dropdown',
            'list_data' => array(
                "1" => "Yes",
                "0" => "No",
            ),
            'default' => '0',
            'attributes' => array('id' => 'require_access_code', 'default' => '0'),
            'rules' => 'trim'
        ),
        'quiz_access_code' => array(
                'table' => $this->_table,
                'name' => 'quiz_access_code',
                'label' => 'Access Code',
                'type' => 'text',
                'attributes' => array('min' => '0', 'class' => 'form-control', 'style' => 'width: auto; display: inline-block; margin-left: 10px;', 'id' => 'access_code'),
                'js_rules' => '',
                'rules' => 'trim',
                'depends_on' => 'quiz_require_access_code'
            ),
        'score' => array(
                'table' => $this->_table,
                'name' => 'score',
                'label' => 'Quiz Score To Keep',
                'type' => 'dropdown',
                'list_data' => array(
                    "1" => "Highest",
                    "2" => "Latest",
                    "3" => "Average",
                ),
                'attributes' => array(),
                'js_rules' => 'required',
                'rules' => 'trim'
            ),
        'quiz_multiple_attempts' => array(
            'table' => $this->_table,
            'name' => 'quiz_multiple_attempts',
            'label' => 'Multiple Attempts?',
            'type' => 'dropdown',
            'list_data' => array(
                "1" => "Yes",
                "0" => "No",
            ),
            'default' => '0',
            'attributes' => array('id' => 'multiple_attempts','default' => '0'),
            'rules' => 'trim'
        ),
             'quiz_attempt_count' => array(
                'table' => $this->_table,
                'name' => 'quiz_attempt_count',
                'label' => 'Allowed Attempts',
                'type' => 'dropdown',
                'list_data' => array(
                    "1" => "1 Attempt",
                    "2" => "2 Attempts",
                    "3" => "3 Attempts",
                    "-1" => "Unlimited"
                ),
                'default' => '1',
                'attributes' => array('class' => 'form-control', 'style' => 'width: auto; display: inline-block; margin-left: 10px;', 'id' => 'attempt_count'),
                'js_rules' => '',
                'rules' => 'trim',
                'depends_on' => 'quiz_multiple_attempts'
            ),
            'quiz_daily_penalty' => array(
                'table' => $this->_table,
                'name' => 'quiz_daily_penalty',
                'label' => 'Daily Penalty (%)',
                'type' => 'number',
                'attributes' => array('min' => '0', 'max' => '100', 'step' => '0.1', 'class' => 'form-control', 'style' => 'width: auto;'),
                'js_rules' => '',
                'rules' => 'trim'
            ),
  
        'quiz_filter_ip_address' => array(
            'table' => $this->_table,
            'name' => 'quiz_filter_ip_address',
            'label' => 'Filter by IP Address?',
            'type' => 'dropdown',
            'list_data' => array(
                "1" => "Yes",
                "0" => "No",
            ),
            'default' => '0',
            'attributes' => array('default' => '0'),
            'rules' => 'trim'
        ),
           
       
    
           
        
        
        );

        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;

    }

}

?>