<?
class Model_product_rating extends MY_Model {
    /**
     * Product Rating MODEL
     *
     * @package     Product Rating Model
     * @author      Dalton Lambert (dalton.developer@gmail.com)
     * @version     2.0
     * @since       2017 / Amazingly corrupt models Corporation Inc.
     */

    protected $_table    = 'product_rating';
    protected $_field_prefix    = 'pr_';
    protected $_pk    = 'pr_id';
    protected $_status_field    = 'pr_status';
    public $relations = array();
    public $pagination_params = array();
    public $dt_params = array();
    public $_per_page    = 20;
    
    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "pr_id,pr_name, pr_product_id,pr_rating ,pr_email, pr_status";

        //$this->pagination_params['joins'][] = $this->join_product();
        parent::__construct();
    }

    public function join_product($type="" , $append_joint ="AND product_status = 1" , $prepend_joint = "")
    {
        $joint = $prepend_joint . "pr_product_id = course_id " . $append_joint ; 
        return $this->prep_join("course" , $joint, $type );
    }

    public function join_user($type="" , $append_joint ="AND user_status = 1" , $prepend_joint = "")
    {
        $joint = $prepend_joint . "pr_user_id = user_id " . $append_joint ; 
        return $this->prep_join("user" , $joint, $type );
    }


    public function get_data_by_product_id($product_id)
    {
        //$param['joins'][] = $this->join_product("LEFT");
        $param['joins'][] = $this->join_user("LEFT");
        $param['where']['pr_product_id'] = $product_id;
        //$param['order'] = 'pr_rating DESC';
        return $this->find_all_active($param);
    }

    public function already_review($pid,$uid)
    {
        $param['where']['pr_product_id'] = $pid;
        $param['where']['pr_user_id'] = $uid;
        $d = $this->find_one($param);

        return (isset($d['pr_id'])) ? true : false;
    }

    public function avg_rating_by_product($product_id)
    {
        $param['fields'] = 'AVG(pr_rating) as rating';
        $param['where']['pr_product_id'] = $product_id;
        $data = $this->find_all_active($param);
        
        if(isset($data[0]['rating']))
            return (empty($data[0]['rating']) ? 0 : round($data[0]['rating']));
        else
            return 0; 
    }


    public function avg_rating_by_vendor($vendor_id)
    {
        $param['fields'] = 'AVG(pr_rating) as rating';
        $param['where']['pr_vendor_id'] = $vendor_id;
        $data = $this->find_all_active($param);
        
        if(isset($data[0]['rating']))
            return (empty($data[0]['rating']) ? 0 : round($data[0]['rating']));
        else
            return 0; 
    }

    public function total_comments_by_product($product_id)
    {
        $param = array();
        $param['where']['pr_product_id'] = $product_id;
        return $this->find_count_active($param);
    }

    /*




   



    public function get_data_against_post_id($post_id , $limit = 5)
    {
      $param = array();
      $param['where']['comments_product_id'] = $post_id;
      $param['joins'][] = $this->join_user("LEFT");
      $param['limit'] = $limit;
      $param['order'] = 'comments_id DESC';

      return $this->find_all_active($param);
    }

    

    


    
    */

    /*
    * table             Table Name
    * Name              FIeld Name
    * label             Field Label / Textual Representation in form and DT headings
    * type              Field type : hidden, text, textarea, editor, etc etc. 
    *                                 Implementation in form_generator.php
    * type_dt           Type used by prepare_datatables method in controller to prepare DT value
    *                                 If left blank, prepare_datatable Will opt to use 'type'
    * type_filter_dt    Used by DT FILTER PREPRATION IN datatables.php
    * attributes        HTML Field Attributes
    * js_rules          Rules to be aplied in JS (form validation)
    * rules             Server side Validation. Supports CI Native rules

    * list_data         For dropdown etc, data in key-value pair that will populate dropdown 
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    * list_data_key     For dropdown etc, if you want to define list_data in CONTROLLER (public _list_data[$key]) list_data_key is the $key which identifies it
    *                   -----Incase list_data_key is not defined, it will look for field_name as a $key
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    */
    public function get_fields( $specific_field = "" )
    {

        $fields = array(
        
              'pr_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'pr_id',
                     'label'   => 'id #',
                     'type'   => 'hidden',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),

            
              'pr_product_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'pr_product_id',
                     'label'   => 'Course #',
                     'type'   => 'dropdown',
                     'type_dt'   => 'dropdown',
                     'type_filter_dt'   => 'dropdown',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"10%"),
                     'js_rules'   => 'required',
                     'rules'   => 'required|trim'
                ),


            //   'pr_vendor_id' => array(
            //          'table'   => $this->_table,
            //          'name'   => 'pr_vendor_id',
            //          'label'   => 'Vendor',
            //          'type'   => 'dropdown',
            //          'type_dt'   => 'dropdown',
            //          'type_filter_dt'   => 'dropdown',
            //          'attributes'   => array(),
            //          'dt_attributes'   => array("width"=>"10%"),
            //          'js_rules'   => '',
            //          'rules'   => 'trim'
            //     ),


              'pr_user_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'pr_user_id',
                     'label'   => 'User',
                     'type'   => 'hidden',
                     'type_dt'   => 'text',
                     'type_filter_dt'   => 'dropdown',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"10%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),

              'pr_rating' => array(
                     'table'   => $this->_table,
                     'name'   => 'pr_rating',
                     'label'   => 'Rating',
                     'type'   => 'dropdown',
                     'list_data'    => array("1"=>"1","2"=>"2","3"=>"3","4"=>"4", "5"=>"5") ,
                     'attributes'   => array(),
                     'js_rules'   => 'required',
                     'rules'   => 'required',
                  ),

              'pr_name' => array(
                     'table'   => $this->_table,
                     'name'   => 'pr_name',
                     'label'   => 'Name',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => 'required',
                     'rules'   => 'required|trim|htmlentities'
                  ),



              'pr_email'  => array(
                  'table'   => $this->_table,
                  'name'   => 'pr_email',
                  'label'   => 'Email',
                  'type'   => 'text',
                  'attributes'   => array(),
                  'js_rules'   => array(),
                  'rules'   => 'required|htmlentities|valid_email'
              ),


              'pr_description' => array(
                     'table'   => $this->_table,
                     'name'   => 'pr_description',
                     'label'   => 'Description',
                     'type'   => 'textarea',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'required|trim|htmlentities'
                  ),

              
              'pr_status' => array(
                     'table'   => $this->_table,
                     'name'   => 'pr_status',
                     'label'   => 'Status?',
                     'type'   => 'switch',
                     'type_dt'   => 'dropdown',
                     'type_filter_dt' => 'dropdown',
                     'list_data_key' => "pr_status" ,
                     'list_data' => array(),
                     'default'   => '1',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"7%"),
                     'rules'   => 'trim'
                  ),
              
            );
        
        if($specific_field)
            return $fields[ $specific_field ];
        else
            return $fields;
    }

}
?>