<?php
class Model_product extends MY_Model {
    /**
     * TKD product MODEL
     *
     * @package     product Model
     * 
     * @version     2.0
     * @since       2014 / Amazingly corrupt models Corporation Inc.
     */

    protected $_table    = 'product';
    protected $_field_prefix    = 'product_';
    protected $_pk    = 'product_id';
    protected $_status_field    = 'product_status';
    public $relations = array();
    public $pagination_params = array();
    public $dt_params = array();
    public $_per_page    = 20;
    
    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "
        product_id,
        product_name, 
        product_category_id,
        product_brand_id,
        CONCAT ('$',product_price) AS product_price,
        CONCAT (pi_image_path,pi_image) AS product_image,
        product_is_featured,product_is_availability,
        product_status";

       $this->pagination_params['joins'][] = array(
                                    "table"=>"product_image" , 
                                    "joint"=>"product_image.pi_product_id = product.product_id and pi_is_featured=1",
                                    "type" => "left"

                                    );
        
       // multiple sizes
        $this->relations['product_color'] = array(
                        "type"=>"has_many", 
                        "own_key"=>"pc_product_id", 
                        "other_key"=>"pc_color_id",
        );

        parent::__construct();

    }

    public function join_category($type="" , $append_joint ="" , $prepend_joint = "")
    {
        $joint = $prepend_joint . "product_parent_category_id = category_id" . $append_joint ; 
        return $this->prep_join("category" , $joint, $type );
    }

    public function join_sub_category($type="" , $append_joint ="" , $prepend_joint = "")
    {
        $joint = $prepend_joint . "product_category_id = subcat.category_id" . $append_joint ; 
        return $this->prep_join("category as subcat" , $joint, $type );
    }

    public function join_user($type="" , $append_joint ="" , $prepend_joint = "")
    {
        $joint = $prepend_joint . "product_user_id = user_id" . $append_joint ; 
        return $this->prep_join("user" , $joint, $type );
    }
    
    public function join_brand($type="" , $append_joint ="" , $prepend_joint = "")
    {
        $joint = $prepend_joint . "product_brand_id = brand_id" . $append_joint ; 
        return $this->prep_join("brand" , $joint, $type );
    }

    public function join_product_image($type="" , $append_joint ="" , $prepend_joint = "")
    {
        $joint = $prepend_joint . "product_id = pi_product_id " . $append_joint ; 
        return $this->prep_join("product_image" , $joint, $type );
    }

    // WHEN All Product Call
    public function get_products($params=array() , $list = false)
    {
      // $params['fields'] = 'product_id,product_category_id,product_parent_category_id,product_user_id,
      //   product_name,product_slug,product_price,product_short_desc,product_desc,product_is_featured,product_status,product_createdon,
      //   category.category_name as parent_category_name,
      //   subcat.category_name as sub_category_name,
      //   pi_image,pi_image_path,pi_image_thumb';



      $params['fields'] = 'product_id,product_category_id,
        product_name,product_slug,product_slogan,product_selling_price,product_price,product_short_desc,product_desc,product_is_featured,product_status,product_createdon,
        subcat.category_name as category_name,product_qty,
        pi_image,pi_image_path,pi_image_thumb';

        if($this->session->userdata['logged_in_front']['user_type'] == VENDOR_USER){
            $params['fields'] .=',product_price_retailers as product_price';
        }
        if($this->session->userdata['logged_in_front']['user_type'] == WHOLESALER_USER){
            $params['fields'] .=',product_price_wholesaler as product_price';
        }

        $params['joins'][] = $this->join_product_image("left" , " AND pi_is_featured = 1");
        //$params['joins'][] = $this->join_category();
        $params['joins'][] = $this->join_sub_category();
        //$params['joins'][] = $this->join_user("INNER"," AND user_connected_status = 1");

        if($list)
            $data = $this->find_all_list_active($params , "product_name");
        else
            $data = $this->find_all_active($params);

        return $data; 
    }

    // WHen individual Product Call
    public function get_details($params = array())
    {
        // $params['fields'] = 'product_id,product_category_id,
        // product_parent_category_id,product_user_id,
        // product_name,product_slug,product_selling_price,product_price,product_short_desc,product_specification,product_desc,product_is_featured,product_status,product_createdon,
        // category.category_name as parent_category_name,
        // subcat.category_name as sub_category_name';

        $params['fields'] = 'product_id,product_category_id,
        product_name,product_slug,product_selling_price,product_price,product_short_desc,product_specification,product_desc,product_is_featured,product_status,product_createdon,product_is_availability,
        subcat.category_name as category_name,brand.brand_name as brand_name';

        if($this->session->userdata['logged_in_front']['user_type'] == VENDOR_USER){
            $params['fields'] .=',product_price_retailers as product_price';
        }
        if($this->session->userdata['logged_in_front']['user_type'] == WHOLESALER_USER){
            $params['fields'] .=',product_price_wholesaler as product_price';
        }

        $params['joins'][] = $this->join_sub_category();
        $params['joins'][] = $this->join_brand();
        //$params['joins'][] = $this->join_user("INNER"," AND user_connected_status = 1");
        $product = $this->find_one_active($params);
        

        if($product)
        {
            $prdimg_params = array();
            $prdimg_params['where']['pi_product_id'] = $product['product_id'] ;
            $prdimg_params['order'] = 'pi_is_featured DESC';
            $product['pi_images'] = $this->model_product_image->find_all($prdimg_params);

            // Get Addons
            $product['color'] = $this->model_product_color->find_all_product_color($product['product_id']);

            // Get Attributes
            //$product['attributes'] = $this->model_product_attribute->get_product_attributes($product['product_id']);

            // Get Category
            //$product['category'] = $this->model_product_category->get_product_categorys($product['product_id']);
            
            // Get Attributes
            // if( $product[ 'product_stitched' ] )
            //     $pis_params['where']['pis_qty - pis_qty_sold >'] = 0 ;
            // $product['item_sets'] = $this->model_product_item_set->get_product_set( $product['product_id'] , $pis_params );
        }
        return $product;
    }

    public function get_featured_products($params=array())
    {
        $params['fields'] = 'product_id,product_name,product_slug,product_price,pi_image,pi_image_thumb,pi_image_path,category_name,category_slug';
        $params['where']['product_is_featured'] = 1 ;
        $params['order'] = "product_id DESC";
        $data = $this->get_products($params);
        return $data;
    }

    public function get_related_products($category_id,$product_id)
    {
        $params = array();
        $params['where']['product_id !='] = $product_id ;
        $params['where']['product_category_id'] = $category_id ;
        $params['order'] = "product_id DESC";
        $params['limit'] = 4;
        $data = $this->get_products($params);
        return $data;
    }

    

    public function get_details_by_slug($slug = '')
    {
        // Return product by slug
        $slug = trim($slug);
        if(!$slug)
            return false;
        $params['where']['product_slug'] = $slug;
        return $this->get_details($params);
    }




    /* ----------------------------------- Queries Start ----------------------------------- */
    public function get_home_featured_products()
    {
        $params = array();
        //$params['limit'] = 8;
        $data = $this->get_featured_products($params);
        return $data;
    }

    private function _pagination_filter($param = array())
    {
        //  Filters Start
        if(isset($_GET['category_id']) AND intval($_GET['category_id']) > 0){
            $param['where']['product_parent_category_id'] = $this->input->get('category_id');
        }

        if(isset($_GET['brand_id']) AND intval($_GET['brand_id']) > 0){
            $param['where']['product_brand_id'] = $this->input->get('brand_id');
        }

        if(isset($_GET['sub_cat_ids']) AND intval($_GET['sub_cat_ids']) > 0) {
            $param['where']['product_category_id'] = $this->input->get('sub_cat_ids');
        }

        if(isset($_GET['search']) AND (!empty($_GET['search']))){
            $search = trim($_GET['search']);
            $param['where_like'][] = array('column'=>'product_name','value'=>$search,'type'=>'both');
        }


        if(isset($_GET['sorting']) AND (!empty($_GET['sorting']))){
            switch ($_GET['sorting']) {
                case 'by_price_ASC':
                    $param['order'] = "product_price ASC";
                    break;
                case 'by_price_DESC':
                    $param['order'] = "product_price DESC";
                    break;
                
                default:
                    $param['order'] = "product_id ASC";
                    break;
            }
        }
        else{
            $param['order'] = "product_id ASC";
        }

        
        //  Filters End
        if(isset($_GET['price']))
        {
            $price = explode(";", $_GET['price']);
            $min = $price[0];
            $max = $price[1];

            $param['where_string'] = "product_price >= $min AND product_price <= $max";
        }

        return $param;
    }

    // Pagination Start
    public function get_pagination_total_count($paginate_param)
    {
        $param = array();
        $param = $this->_pagination_filter($paginate_param);
        //$data = $this->find_count_active($param);
        $data = count($this->get_products($param));
        return $data;
    }

    public function get_pagination_data($limit = '', $offset = '',$paginate_param)
    {
        $param = array();

        //$param['order'] = 'product_id DESC';
        $param['limit'] = $limit;

        //  Filters Start
        $param = $this->_pagination_filter($paginate_param);
        
        $param['limit'] = $limit;
        $param['offset'] = $offset;
        return $this->get_products($param);
    }
    // Pagination END


    public function get_all_products($type = 1)
    {
      $param = array();
      //$param['where']['product_type_id'] = $type;

      if(isset($_GET['maincat']) AND intval($_GET['maincat']) > 0) {
        $param['where']['product_parent_category_id'] = $_GET['maincat'];
      }

      if(isset($_GET['subcat']) AND intval($_GET['subcat']) > 0) {
        $param['where']['product_category_id'] = $_GET['subcat'];
      }

      if(isset($_GET['search'])) {
        $param['where_like'][] = array('column'=>'product_name','value'=>trim($_GET['search']),'type'=>'both');
      }

      if(isset($_GET['date'])) {
        $date = $_GET['date'];
        $param['where_string'] = "product_createdon BETWEEN '{$date} 00:01' AND '{$date} 23:59:59'";
      }
      
      return $this->get_products($param);
    }


    public function get_all_featured_products($type = 1)
    {
      $param = array();
      //$param['where']['product_type_id'] = $type;

      if(isset($_GET['maincat']) AND intval($_GET['maincat']) > 0) {
        $param['where']['product_parent_category_id'] = $_GET['maincat'];
      }

      if(isset($_GET['subcat']) AND intval($_GET['subcat']) > 0) {
        $param['where']['product_category_id'] = $_GET['subcat'];
      }
      $param['order'] = "RAND()";
      $param['limit'] = 3;
      return $this->get_products($param);
    }


    public function get_review($product_id)
    {
        return rand(0,5);
    }

    public function update_relations($id)
    {
        if(!array_filled($this->relations))
        {
            // No RELATIONS Defined....
            return true;
        }
        foreach ($this->relations as $table => $relate) {
            
            /*  
                If this relation needs to be updated from this model, 
                it must have relative field defined in get_fields();
             */
            $field = $this->get_fields($table);
            if(!$field)
                continue; 

            $model_obj = $this->{"model_".$table};
            switch ($relate['type']) {
                case 'has_many':
                    $multi_rec = array();
                    //debug($_POST[$table],1);
                    //if(is_array($_POST[$table][ $relate['other_key'] ])){
                    if(isset($_POST[$table][ $relate['other_key'] ]) AND array_filled($_POST[$table][ $relate['other_key'] ])) {
                        foreach ($_POST[$table][ $relate['other_key'] ] as $foreign_id) { 
                            $user_data = array();
                            $user_data[ $relate['other_key'] ] = $foreign_id;
                            $user_data[ $relate['own_key']   ] = $id;
                            $multi_rec[] = $user_data;
                        }
                    }
                    break;
                
                default:
                    # code...
                    break;

            } // END- RELATION TYPE Switch
            //debug($model_obj);
            //debug($multi_rec,1);
            if(isset($multi_rec) AND array_filled($multi_rec))
            {
                $where_relation = array();
                $where_relation[ $relate['own_key'] ] = $id;
                $model_obj->delete_record($where_relation);
                $update_table = $model_obj->insert_batch_record($multi_rec); 
            }

        }  // END-FOREACH - Relation 
    }



    public function get_data_by_user_id($userid)
    {
        $param = array();
        $param['where']['product_user_id'] = $userid;
        $param['joins'][] = $this->join_category();
        return $this->get_all_data($param);
    }

    /* ----------------------------------- Queries End ----------------------------------- */

    /*
    * table             Table Name
    * Name              FIeld Name
    * label             Field Label / Textual Representation in form and DT headings
    * type              Field type : hidden, text, textarea, editor, etc etc. 
    *                                 Implementation in form_generator.php
    * type_dt           Type used by prepare_datatables method in controller to prepare DT value
    *                                 If left blank, prepare_datatable Will opt to use 'type'
    * type_filter_dt    Used by DT FILTER PREPRATION IN datatables.php
    * attributes        HTML Field Attributes
    * js_rules          Rules to be aplied in JS (form validation)
    * rules             Server side Validation. Supports CI Native rules

    * list_data         For dropdown etc, data in key-value pair that will populate dropdown 
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    * list_data_key     For dropdown etc, if you want to define list_data in CONTROLLER (public _list_data[$key]) list_data_key is the $key which identifies it
    *                   -----Incase list_data_key is not defined, it will look for field_name as a $key
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    */
    public function get_fields( $specific_field = "" )
    {
        $is_required_image = (($this->uri->segment(4)!=null) && intval($this->uri->segment(4)))?'':'required';


        $fields = array(
        
              'product_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'product_id',
                     'label'   => 'id #',
                     'type'   => 'hidden',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),

              'product_image' => array(
                     'table'   => $this->_table,
                     'name'   => 'product_image',
                     'label'   => 'Image',
                     'type'   => 'none',
                     'type_dt'   => 'image',
                     'type_filter_dt'   => 'dropdown',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),

              'product_user_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'product_user_id',
                     'label'   => 'User',
                     'type'   => 'hidden',
                     'type_dt'   => 'hidden',
                     'type_filter_dt'   => 'hidden',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),


                // 'product_parent_category_id' => array(
                //    'table'   => $this->_table,
                //    'name'   => 'product_parent_category_id',
                //    'label'   => 'Brand',
                //    'type'   => 'dropdown',
                //    'type_dt'   => 'dropdown',
                //    'attributes'   => array("class"=>"ajax-populate",
                //                           "additional" => 'data-target="product-product_category_id" '
                //                       ),
                //    'type_filter_dt'   => 'dropdown',
                //    'js_rules'   => 'required',
                //    'rules'   => 'required|trim'
                // ),

                // 'product_category_id' => array(
                //    'table'   => $this->_table,
                //    'name'   => 'product_category_id',
                //    'label'   => 'Category',
                //    'type'   => 'dropdown',
                //    'type_dt'   => 'dropdown',
                //    'type_filter_dt'   => 'dropdown',
                //    'attributes'   => array("class"=>"ajax-populate",
                //                            "additional" => ' 
                //                                 data-populate-uri="get_list"
                //                                 data-uri="product"
                //                                 data-dd_key="category_id"
                //                                 data-dd_value="category_name"'
                //                       ),
                //    'js_rules'   => 'required',
                //    'rules'   => 'required|trim'
                // ),

                'product_category_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'product_category_id',
                     'label'   => 'Category',
                     'type'   => 'dropdown',
                     'type_dt'   => 'dropdown',
                     'type_filter_dt'   => 'dropdown',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),


                // 'product_type_id' => array(
                //      'table'   => $this->_table,
                //      'name'   => 'product_type_id',
                //      'label'   => 'Product Type',
                //      'type'   => 'dropdown',
                //      'type_dt'   => 'dropdown',
                //      'type_filter_dt'   => 'dropdown',
                //      'attributes'   => array(),
                //      'js_rules'   => '',
                //      'rules'   => 'trim'
                // ),

              // 'product_sub_category_id' => array(
              //        'table'   => $this->_table,
              //        'name'   => 'product_sub_category_id',
              //        'label'   => 'Sub Category',
              //        'type'   => 'dropdown',
              //        'type_dt'   => 'text',
              //        'type_filter_dt'   => 'dropdown',
              //        'attributes'   => array("class"=>"ajax-populate",
              //                                "additional" => ' 
              //                                               data-populate-uri="get_list"
              //                                               data-uri="product"
              //                                               data-dd_key="category_id"
              //                                               data-dd_value="category_name"'
              //                           ),
              //        'js_rules'   => 'required',
              //        'rules'   => 'required|trim'
              //   ),
              // 'product_app_id' => array(
              //        'table'   => $this->_table,
              //        'name'   => 'product_app_id',
              //        'label'   => 'Application',
              //        'type'   => 'dropdown',
              //        'type_dt'   => 'text',
              //        'type_filter_dt'   => 'dropdown',
              //        'rules'   => 'required|trim'
              //   ),

             'product_brand_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'product_brand_id',
                     'label'   => 'Brand',
                     'type'   => 'dropdown',
                     'type_dt'   => 'dropdown',
                     'type_filter_dt'   => 'dropdown',
                     'rules'   => 'required|trim'
                ),
            

            'product_slogan' => array(
                     'table'   => $this->_table,
                     'name'   => 'product_slogan',
                     'label'   => 'Product Slogan',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                  ),


              'product_name' => array(
                     'table'   => $this->_table,
                     'name'   => 'product_name',
                     'label'   => 'Name',
                     'type'   => 'text',
                    'attributes'   => array("additional"=>'slugify="#'.$this->_table.'-'.$this->_field_prefix.'slug"'),
                     'dt_attributes'   => array("width"=>"20%"),
                     'js_rules'   => 'required',
                     'rules'   => 'required|trim|htmlentities'
                  ),

            'product_slug'  => array(
                'table'   => $this->_table,
                'name'   => 'product_slug',
                'label'   => 'Slug',
                'type'   => 'text',
                'attributes'   => array(),
                'js_rules'   => array("is_slug" => array() ),
                // 'rules'   => 'trim|htmlentities'
                'rules'   => 'required|htmlentities|is_unique['.$this->_table.'.'.$this->_field_prefix.'slug]|callback_is_slug'
            ),

            'product_selling_price' => array(
                     'table'   => $this->_table,
                     'name'   => 'product_selling_price',
                     'label'   => 'Selling Price',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|greater_than[0]'
                  ),

             'product_price' => array(
                     'table'   => $this->_table,
                     'name'   => 'product_price',
                     'label'   => 'Price',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => 'required',
                     'rules'   => 'required|trim|htmlentities|greater_than[0]'
                  ),

             // 'product_selling_price' => array(
             //         'table'   => $this->_table,
             //         'name'   => 'product_selling_price',
             //         'label'   => 'Price For Wholesaler',
             //         'type'   => 'text',
             //         'attributes'   => array(),
             //         'js_rules'   => '',
             //         'rules'   => 'trim|htmlentities|greater_than[0]'
             //      ),

             // 'product_price_retailers' => array(
             //         'table'   => $this->_table,
             //         'name'   => 'product_price_retailers',
             //         'label'   => 'Price For Retailers',
             //         'type'   => 'text',
             //         'attributes'   => array(),
             //         'js_rules'   => 'required',
             //         'rules'   => 'required|trim|htmlentities|greater_than[0]'
             //      ),

              // 'product_pricing_unit' => array(
              //        'table'   => $this->_table,
              //        'name'   => 'product_pricing_unit',
              //        'label'   => 'Unit Price',
              //        'type'   => 'dropdown',
              //        'list_data'    => array(
              //               "per hour"=>"PER HOUR",
              //               "per item"=>"PER ITEM",
              //               "per day"=>"PER DAY",
              //               "per class"=>"PER CLASS",
              //               "per ticket"=>"PER TICKET",
              //               "per unit"=>"PER UNIT",
              //               "per job/transaction"=>"PER JOB/TRANSACTION",
              //               "-"=>"N/A",
              //               ) ,
              //        'attributes'   => array(),
              //        'js_rules'   => 'required',
              //        'rules'   => 'required|trim|htmlentities'
              //     ),


             // 'product_sku' => array(
             //         'table'   => $this->_table,
             //         'name'   => 'product_sku',
             //         'label'   => 'SKU',
             //         'type'   => 'text',
             //         'attributes'   => array(),
             //         'js_rules'   => 'required',
             //         'rules'   => 'required|trim|htmlentities'
             //      ),


             'product_qty' => array(
                     'table'   => $this->_table,
                     'name'   => 'product_qty',
                     'label'   => 'QTY',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => 'required',
                     'rules'   => 'required|trim|htmlentities'
                  ),

            'product_short_desc' => array(
                     'table'   => $this->_table,
                     'name'   => 'product_short_desc',
                     'label'   => 'Short Description',
                     'type'   => 'editor',
                     'attributes'   => array(),
                     'js_rules'   => 'required',
                     'rules'   => 'required|trim|htmlentities|required'
                  ),

            

            'product_desc' => array(
                     'table'   => $this->_table,
                     'name'   => 'product_desc',
                     'label'   => 'Description',
                     'type'   => 'editor',
                     'attributes'   => array(),
                     'js_rules'   => 'required',
                     'rules'   => 'required|trim|htmlentities|required'
                  ),

            /*

            'product_specification' => array(
                     'table'   => $this->_table,
                     'name'   => 'product_specification',
                     'label'   => 'Additional Information',
                     'type'   => 'editor',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

            */
             //    'product_is_pack_product' => array(
             //         'table'   => $this->_table,
             //         'name'   => 'product_is_pack_product',
             //         'label'   => 'Is Packs Product',
             //         'type'   => 'dropdown',
             //         'list_data'    => array(
             //            "1"=>"Yes",
             //            "2"=>"No",
             //            ) ,
             //         'attributes'   => array(),
             //         'js_rules'   => 'required',
             //         'rules'   => 'required|trim|htmlentities'
             //      ),
            

             //    'product_packupsize' => array(
             //         'table'   => $this->_table,
             //         'name'   => 'product_packupsize',
             //         'label'   => 'Pack size',
             //         'type'   => 'dropdown',
             //         'list_data'    => array(
             //            "2"=>"2 Packs",
             //            "3"=>"3 Packs",
             //            "4"=>"4 Packs",
             //            "5"=>"5 Packs",
             //            "6"=>"6 Packs",
             //            "8"=>"8 Packs",
             //            "10"=>"10 Packs",
             //            ) ,
             //         'attributes'   => array(),
             //         'js_rules'   => '',
             //         'rules'   => 'trim|htmlentities'
             //      ),

             //    'product_packup_desc' => array(
             //         'table'   => $this->_table,
             //         'name'   => 'product_packup_desc',
             //         'label'   => 'Pack Description',
             //         'type'   => 'textarea',
             //         'attributes'   => array(),
             //         'js_rules'   => '',
             //         'rules'   => 'trim|htmlentities'
             //      ),


             'product_color' => array(
                     'table'   => "product_color",
                     'name'   => 'pc_color_id',
                     'label'   => 'size',
                     'type'   => 'multiselect',
                     'attributes'   => array('searchable_fields'=>true,'wrap_class'=>'col-md-9'),
                     'js_rules'   => '',
                     'rules'   => '',
              ),

              
              // 'product_meta_title' => array(
              //        'table'   => $this->_table,
              //        'name'   => 'product_meta_title',
              //        'label'   => 'Meta Title',
              //        'type'   => 'text',
              //        'attributes'   => array(),
              //        'js_rules'   => '',
              //        'rules'   => 'trim|htmlentities'
              //     ),

              // 'product_meta_description' => array(
              //        'table'   => $this->_table,
              //        'name'   => 'product_meta_description',
              //        'label'   => 'Meta Description',
              //        'type'   => 'text',
              //        'attributes'   => array(),
              //        'js_rules'   => '',
              //        'rules'   => 'trim|htmlentities'
              //     ),

              // 'product_meta_keywords' => array(
              //        'table'   => $this->_table,
              //        'name'   => 'product_meta_keywords',
              //        'label'   => 'Meta Keywords',
              //        'type'   => 'text',
              //        'attributes'   => array(),
              //        'dt_attributes'   => array("width"=>"10%"),
              //        'js_rules'   => '',
              //        'rules'   => 'trim|htmlentities'
              //     ),

             'product_is_hotdeal' => array(
                     'table'   => $this->_table,
                     'name'   => 'product_is_hotdeal',
                     'label'   => 'Hot Deals',
                     'type'   => 'dropdown',
                     'list_data'    => array(
                            1=>"15% off",
                            2=>"20% off",
                            3=>"25% off",
                            ) ,
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

              'product_deal_contdown' => array(
                     'table'   => $this->_table,
                     'name'   => 'product_deal_contdown',
                     'label'   => 'Deal Count Down',
                     'type'   => 'date',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"10%"),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),
                
                  'product_is_availability' => array(
                     'table'   => $this->_table,
                     'name'   => 'product_is_availability',
                     'label'   => 'Is availability',
                     'type'   => 'switch',
                     'type_dt'   => 'dropdown',
                     'type_filter_dt' => 'dropdown',
                     'list_data_key' => "product_status" ,
                     'list_data' => array(),
                     'default'   => '0',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"7%"),
                     'rules'   => 'trim'
                  ),   


                 'product_is_featured' => array(
                     'table'   => $this->_table,
                     'name'   => 'product_is_featured',
                     'label'   => 'Featured',
                     'type'   => 'switch',
                     'type_dt'   => 'dropdown',
                     'type_filter_dt' => 'dropdown',
                     'list_data_key' => "product_status" ,
                     'list_data' => array(),
                     'default'   => '0',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"7%"),
                     'rules'   => 'trim'
                  ),   

                  

              'product_status' => array(
                     'table'   => $this->_table,
                     'name'   => 'product_status',
                     'label'   => 'Status?',
                     'type'   => 'switch',
                     'type_dt'   => 'dropdown',
                     'type_filter_dt' => 'dropdown',
                     //'list_data_key' => "product_status" ,
                     'list_data' => array(),
                     'default'   => '1',
                     'attributes'   => array(),
                     // 'dt_attributes'   => array("width"=>"7%"),
                     'rules'   => 'trim'
                  ),
              
            );
        
        if($specific_field)
            return $fields[ $specific_field ];
        else
            return $fields;
    }

}
?>
