<?
class Model_inquiry extends MY_Model {
  
    /**
     * TKD inquiry MODEL
     *
     * @package     inquiry Model
     * @author      Muhammad Uzair Khan (Muhammad.Uzair@tradekey.com)
     * @version     2.0
     * @since       2014 / Amazingly corrupt models Corporation Inc.
     */

    protected $_table    = 'inquiry';
    protected $_field_prefix    = 'inquiry_';
    protected $_pk    = 'inquiry_id';
    protected $_status_field    = 'inquiry_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page    = 20;
    
    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "inquiry_id,inquiry_type,inquiry_name,inquiry_email,inquiry_phone,inquiry_status";
        parent::__construct();
    }

    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */
    public function get_fields( $specific_field = "" )
    {

        $fields = array(
        
              'inquiry_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'inquiry_id',
                     'label'   => 'id #',
                     'type'   => 'hidden',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),

              'inquiry_user_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'inquiry_user_id',
                     'label'   => 'User ID',
                     'type'   => 'hidden',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),

              'inquiry_type' => array(
                     'table'   => $this->_table,
                     'name'   => 'inquiry_type',
                     'label'   => 'Type',
                     'type'   => 'dropdown',
                     'list_data'    => array(
                        "CONTACT_US_INQUIRY"=>"Contact Us",
                        "FOOTER_CONTACT_US"=>"Footer Contact us",
                        "FAQ_CONTACT_US"=>"FAQ Contact Us",
                        ) ,
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

              'inquiry_heading' => array(
                     'table'   => $this->_table,
                     'name'   => 'inquiry_heading',
                     'label'   => 'Type',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'trim|htmlentities'
                  ),

              

              // 'inquiry_business_name' => array(
              //        'table'   => $this->_table,
              //        'name'   => 'inquiry_business_name',
              //        'label'   => 'Business name',
              //        'type'   => 'text',
              //        'attributes'   => array(),
              //        'js_rules'   => '',
              //        'rules'   => 'required|trim|htmlentities'
              //     ),
                  
              'inquiry_name' => array(
                 'table'   => $this->_table,
                 'name'   => 'inquiry_name',
                 'label'   => 'Full Name',
                 'type'   => 'text',
                 'attributes'   => array(),
                 'js_rules'   => '',
                 'rules'   => 'required|strtolower|trim|htmlentities|min_length[2]|max_length[50]'
              ),  

              'inquiry_email' => array(
                     'table'   => $this->_table,
                     'name'   => 'inquiry_email',
                     'label'   => 'Email',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'required|valid_email|strtolower|trim|htmlentities'
                  ),

              'inquiry_phone' => array(
                 'table'   => $this->_table,
                 'name'   => 'inquiry_phone',
                 'label'   => 'Phone No.',
                 'type'   => 'text',
                 'attributes'   => array(),
                 'js_rules'   => '',
                 //'rules'=>'trim|htmlentities|min_length[5]|regex_match[/^[\d\(\)\-+ ]+$/]'
                 'rules'=>'trim'
              ), 


              


              'inquiry_message' => array(
                     'table'   => $this->_table,
                     'name'   => 'inquiry_message',
                     'label'   => 'Message',
                     'type'   => 'textarea',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'required|trim|htmlentities|min_length[5]|max_length[512]'
                  ),

              'inquiry_status' => array(
                     'table'   => $this->_table,
                     'name'   => 'inquiry_status',
                     'label'   => 'Status?',
                     'type'   => 'switch',
                     'type_dt'   => 'dropdown',
                     'type_filter_dt'   => 'dropdown',
                     'list_data' => array( 
                                        0 => "<span class=\"label label-default\">Read</span>" ,  
                                        1 =>  "<span class=\"label label-primary\">New Message</span>"  
                                    ) ,
                     'default'   => '1',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"7%"),
                     'rules'   => 'trim'
                  ),
              
            );

        if($specific_field)
            return $fields[ $specific_field ];
        else
            return $fields;

    }

}
?>