<?php
class Model_grading_settings extends CI_Model {

    // Constructor
    public function __construct() {
        parent::__construct();
    }

    // Create or update grading settings for a specific course
    public function create_or_update_grading_settings($grading_data, $course_id) {
        // Check if grading settings exist for the course
        $this->db->where('course_id', $course_id);
        $query = $this->db->get('grading_settings');
        
        if ($query->num_rows() > 0) {
            // Update existing settings
            $this->db->where('course_id', $course_id);
            return $this->db->update('grading_settings', $grading_data);
        } else {
            // Insert new grading settings
            return $this->db->insert('grading_settings', $grading_data);
        }
    }

    // Get grading settings for a specific course
    public function get_grading_settings($course_id) {
        $this->db->where('course_id', $course_id);
        $query = $this->db->get('grading_settings');
        
        if ($query->num_rows() > 0) {
            $grading_settings = $query->row_array();
            // Decode JSON custom grades if any
            if (!empty($grading_settings['custom_grades'])) {
                $grading_settings['custom_grades'] = json_decode($grading_settings['custom_grades'], true);
            }
            return $grading_settings;
        }
        return NULL;
    }

    // Delete grading settings for a specific course
    public function delete_grading_settings($course_id) {
        $this->db->where('course_id', $course_id);
        return $this->db->delete('grading_settings');
    }
}
