<?
class Model_grade extends MY_Model
{
    /**
     * @package     grade Model
     * @version     1.0
     * @since       2018
     */

    protected $_table = 'grade';
    protected $_field_prefix = 'grade_';
    protected $_pk = 'grade_id';
    protected $_status_field = 'grade_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page = 20;

    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "grade_id,grade_user_id,grade_course_id,grade_subject_id,grade_type,grade_assignment_id,grade_quiz_id,grade_marks,grade_total_marks,grade_percentage,grade_status";
        parent::__construct();
    }

    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */
    
    public function get_fields($specific_field = "")
    {
        // Use when edit
        $is_required_image = (($this->uri->segment(4)!=null) && intval($this->uri->segment(4)))?'':'required';

        $fields = array(

            'grade_id' => array(
                'table' => $this->_table,
                'name' => 'grade_id',
                'label' => 'id #',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => 'trim'
            ),


            'grade_user_id' => array(
                'table' => $this->_table,
                'name' => 'grade_user_id',
                'label' => 'User #',
                'type' => 'dropdown',
                'attributes'   => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),
            'grade_course_id' => array(
                'table' => $this->_table,
                'name' => 'grade_course_id',
                'label' => 'Course #',
                'type' => 'dropdown',
                'attributes'   => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),
            'grade_subject_id' => array(
                'table' => $this->_table,
                'name' => 'grade_subject_id',
                'label' => 'Subject #',
                'type' => 'dropdown',
                'attributes'   => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),
            'grade_related_id' => array(
                'table' => $this->_table,
                'name' => 'grade_related_id',
                'label' => 'Related #',
                'type' => 'dropdown',
                'attributes'   => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),
            'grade_type' => array(
                'table' => $this->_table,
                'name' => 'grade_type',
                'label' => 'Type',
                'type' => 'text',
                'attributes'   => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),
            'grade_assignment_id' => array(
                'table' => $this->_table,
                'name' => 'grade_assignment_id',
                'label' => 'Assignment Title',
                'type' => 'dropdown',
                'attributes'   => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),
            'grade_quiz_id' => array(
                'table' => $this->_table,
                'name' => 'grade_quiz_id',
                'label' => 'Quiz Name',
                'type' => 'dropdown',
                'attributes'   => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            'grade_total_marks' => array(
                'table' => $this->_table,
                'name' => 'grade_total_marks',
                'label' => 'Total Marks',
                'type' => 'text',
                'attributes'   => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            'grade_marks' => array(
                'table' => $this->_table,
                'name' => 'grade_marks',
                'label' => 'Marks',
                'type' => 'text',
                'attributes'   => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            'grade_percentage' => array(
                'table' => $this->_table,
                'name' => 'grade_marks',
                'label' => 'Percentage',
                'type' => 'decimal',
                'attributes'   => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            'grade_status' => array(
                    'table'   => $this->_table,
                    'name'   => 'grade_status',
                    'label'   => 'Status?',
                    'type'   => 'dropdown',
                    // 'default'   => '1',
                    'attributes'   => array(),
                    'rules'   => 'trim'
                ),
        );

        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;

    }
    
    // public function getGradebook($course_id) {
    //     // Fetch unique quizzes and assignments for dynamic columns
    //     $this->db->select('grade_related_id, grade_type, 
    //                       COALESCE(quiz_name, assignment_title) AS title');
    //     $this->db->from('tn_grade g');
    //     $this->db->join('quiz q', 'g.grade_quiz_id = q.quiz_id', 'left');
    //     $this->db->join('assignment a', 'g.grade_assignment_id = a.assignment_id', 'left');
    //     $this->db->where('g.grade_course_id', $course_id);
    //     $this->db->group_by(['grade_related_id', 'grade_type']);
    //     $this->db->order_by('grade_related_id');
    //     $quizzes_assignments = $this->db->get()->result_array();
    
    //     // Fetch grades for each student
    //     $this->db->select('u.user_id, CONCAT(u.user_firstname, " ", u.user_lastname) as username, g.grade_related_id, g.grade_marks, g.grade_total_marks, g.grade_percentage');
    //     $this->db->from('tn_grade g');
    //     $this->db->join('user u', 'g.grade_user_id = u.user_id', 'left');
    //     $this->db->where('g.grade_course_id', $course_id);
    //     $grades = $this->db->get()->result_array();
    
    //     return [
    //         'quizzes_assignments' => $quizzes_assignments,
    //         'grades' => $grades,
    //         'course_id' => $course_id
    //     ];
    // }

    public function getGradebook($course_id) {
        // Fetch student grades
        $this->db->select('u.user_id, CONCAT(u.user_firstname, " ", u.user_lastname) as username, g.grade_related_id, g.grade_marks, g.grade_total_marks, g.grade_percentage');
        $this->db->from('tn_grade g');
        $this->db->join('user u', 'g.grade_user_id = u.user_id', 'left');
        $this->db->where('g.grade_course_id', $course_id);
        $grades = $this->db->get()->result_array();
        
        // Fetch quizzes, assignments, and assignment groups
        $subQuery = '(SELECT cq_quiz_id, SUM(cq_gain_point) AS total_quiz_points FROM tn_course_quiz GROUP BY cq_quiz_id) AS cq_total';
        
        $this->db->select('
            COALESCE(ag_q.assignment_group_id, ag_a.assignment_group_id) AS assignment_group_id,
            COALESCE(ag_q.assignment_group_name, ag_a.assignment_group_name) AS assignment_group_name,
            COALESCE(cq_total.total_quiz_points, a.assignment_number) AS total_marks,
            IFNULL(COALESCE(ag_q.assignment_group_percentage, ag_a.assignment_group_percentage), 100) AS assignment_group_percentage,
            COALESCE(q.assignment, a.assignment) AS assignment,
            g.grade_related_id, g.grade_type,
            COALESCE(q.quiz_name, a.assignment_title) AS title,
            MIN(g.grade_status) AS visible_status
        ');
        $this->db->from('tn_grade g');
        $this->db->join('quiz q', 'g.grade_quiz_id = q.quiz_id AND g.grade_type = "quiz"', 'left');
        $this->db->join($subQuery, 'q.quiz_id = cq_total.cq_quiz_id', 'left'); // Subquery join to get total quiz points
        $this->db->join('assignment a', 'g.grade_assignment_id = a.assignment_id AND g.grade_type = "assignment"', 'left');
        $this->db->join('assignment_group ag_q', 'ag_q.assignment_group_id = q.assignment AND g.grade_type = "quiz" AND ag_q.assignment_group_course_id = '.$course_id, 'left');
        $this->db->join('assignment_group ag_a', 'ag_a.assignment_group_id = a.assignment AND g.grade_type = "assignment" AND ag_a.assignment_group_course_id = '.$course_id, 'left');
        $this->db->where('g.grade_course_id', $course_id);
        $this->db->group_by(['g.grade_related_id', 'g.grade_type']);
        $this->db->order_by('g.grade_related_id');
        
        $quizzes_assignments = $this->db->get()->result_array();
        
        $this->db->select('
            COALESCE(ag_q.assignment_group_id, ag_a.assignment_group_id) AS assignment_group_id,
            COALESCE(ag_q.assignment_group_name, ag_a.assignment_group_name) AS assignment_group_name,
            COALESCE(cq_total.total_quiz_points, a.assignment_number) AS total_marks,
            IFNULL(COALESCE(ag_q.assignment_group_percentage, ag_a.assignment_group_percentage), 100) AS assignment_group_percentage,
            COALESCE(q.assignment, a.assignment) AS assignment,
            g.grade_related_id, g.grade_type,
            COALESCE(q.quiz_name, a.assignment_title) AS title,
            MIN(g.grade_status) AS visible_status
        ');
        $this->db->from('tn_grade g');
        $this->db->join('quiz q', 'g.grade_quiz_id = q.quiz_id AND g.grade_type = "quiz"', 'left');
        $this->db->join($subQuery, 'q.quiz_id = cq_total.cq_quiz_id', 'left'); // Subquery join to get total quiz points
        $this->db->join('assignment a', 'g.grade_assignment_id = a.assignment_id AND g.grade_type = "assignment"', 'left');
        $this->db->join('assignment_group ag_q', 'ag_q.assignment_group_id = q.assignment AND g.grade_type = "quiz" AND ag_q.assignment_group_course_id = '.$course_id, 'left');
        $this->db->join('assignment_group ag_a', 'ag_a.assignment_group_id = a.assignment AND g.grade_type = "assignment" AND ag_a.assignment_group_course_id = '.$course_id, 'left');
        $this->db->where('g.grade_course_id', $course_id);
        $this->db->group_by(['assignment_group_id']);
        $this->db->order_by('g.grade_related_id');
        $assignment_groups = $this->db->get()->result_array();
    
        $studentFinalGrades = [];
     
        foreach ($grades as $g) {
            $student_id = $g['user_id'];
            $totalWeightedScore = 0;
            $totalWeightage = 0;
    
     
    
            $studentGroupScores = [];
            $studentGroupTotalMarks = [];
            
            // Iterate through quizzes and assignments
            foreach ($quizzes_assignments as $qa) {
                $group_percentage = $qa['assignment_group_percentage'] ? $qa['assignment_group_percentage'] : 100;
            
                // Check if grade_related_id matches and if the assignment_group_id is the same
                if ($g['grade_related_id'] == $qa['grade_related_id']) {
                    $assignment_group_id = $qa['assignment_group_id'];
            
                    // Initialize group scores if not set
                    if (!isset($studentGroupScores[$assignment_group_id])) {
                        $studentGroupScores[$assignment_group_id] = 0;
                        $studentGroupTotalMarks[$assignment_group_id] = 0;
                    }
            
                    // Accumulate scores and total marks only for the same assignment_group_id
                    $studentGroupScores[$assignment_group_id] += $g['grade_marks']; // Actual marks scored
                    $studentGroupTotalMarks[$assignment_group_id] += $qa['total_marks']; // Total marks possible
                    // Perform calculations once total marks for the group are greater than 0
                    if ($studentGroupTotalMarks[$assignment_group_id] > 0) {
                        $weightage = $group_percentage / 100; // Weightage in decimal
                        $weightedScore = ($studentGroupScores[$assignment_group_id] / $studentGroupTotalMarks[$assignment_group_id]) * 100;
                        $finalWeight = $weightedScore * $weightage;
            
                        // Perform further calculations with $finalWeight, e.g., storing total weightage
                        $totalWeightedScore += $finalWeight; // Accumulating final weighted score
                    }
                    
                }
            }
    
            $finalGradePercentage = $totalWeightedScore ;
    
            // Store the student's final grade
            $studentFinalGrades[$student_id] = [
                'username' => $g['username'],
                'finalGradePercentage' => $finalGradePercentage
            ];
        }
    
        return [
            'quizzes_assignments' => $quizzes_assignments,
            'assignment_groups' => $assignment_groups,
            'grades' => $grades,
            'studentFinalGrades' => $studentFinalGrades,
            'course_id' => $course_id
        ];
    }



}

?>