<?

class Model_expose_media extends MY_Model
{

    /**
     * Social8 PhotoMODEL
     *
     * @package     Photo Model
     * @author      Fawwad Shafi
     * @version     1.0
     * @since       01 Feb,2017
     */

    protected $_table = 'expose_media';
    protected $_field_prefix = 'media_';
    protected $_pk = 'media_id';
    protected $_status_field = 'media_status';
    public $pagination_params = array();

    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }

    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */

    public function get_last_pk_id($user_id = 0)
    {
        $param = array();
        if($user_id > 0)
            $param['where']['media_user_id'] = $user_id;

        $param['order'] = 'media_id DESC';
        $data = $this->find_one_active($param);
        return isset($data['media_id']) ? $data['media_id'] : 0;
    }

    /*
    // NOT USE -->go to find_post
    // User posts
    public function user_post($user_id,$limit=0)
    {
        // Set fields
        $params['fields'] = "media_id,media_user_id,media_type,media_other_action_id,media_description,media_file,media_file_path,
                            media_visibility,media_createdon,signup_id,CONCAT(signup_firstname, ' ', signup_lastname) as name,
                            signup_profile_image,signup_profile_image_path,(SELECT COUNT(media_like_post_id) FROM {pre}media_like
                            WHERE media_like_post_id = media_id) AS media_like_count,(SELECT COUNT(media_comment_post_id) FROM {pre}media_comment
                            WHERE media_comment_post_id = media_id) AS media_comment_count";
        // JOIN
        $params['joins'][] = array(
            "table"=>"user" ,
            "joint"=>"user.user_id = media_user_id",
        );
        // Set params
        $params['where']['media_user_id'] = $user_id;
        // Set limit
        // if($limit!=0){
        //     $params['limit'] = $limit;
        // }
        // order by
        $params['order'] = "media_id DESC";

        // Query
        $query = $this->model_post->find_all_active($params);

        // Fetch comments
        if(count($query)>0){
            foreach($query as $row):
                // Fetch comment
                $comment_data = $this->medial_post_comment->comments_list($row['media_id'],null,2);
                // Set data
                $result[] = array(
                    'media_data'=>$row,
                    'media_comment'=>$comment_data
                );
            endforeach;
        }
        else{
            $result = array();
        }


        return $result;
    }

    // NOT USE -->go to find_post
    // Time posts with friend
    public function timeline_post($ids,$limit=0)
    {
        // Set fields
        $params['fields'] = "media_id,media_user_id,media_type,media_other_action_id,media_description,media_file,media_file_path,
                            media_visibility,media_createdon,signup_id,CONCAT(signup_firstname, ' ', signup_lastname) as name,
                            signup_profile_image,signup_profile_image_path,(SELECT COUNT(media_like_post_id) FROM {pre}media_like
                            WHERE media_like_post_id = media_id) AS media_like_count,(SELECT COUNT(media_comment_post_id) FROM {pre}media_comment
                            WHERE media_comment_post_id = media_id) AS media_comment_count";
        // JOIN
        $params['joins'][] = array(
            "table"=>"signup" ,
            "joint"=>"signup.signup_id = media_user_id",
        );
        // Set params
        $params['where_in']['media_user_id'] = $ids;
        // Set limit
        if($limit!=0){
            $params['limit'] = $limit;
        }
        // order by
        $params['order'] = "media_id DESC";

        // Query
        $query = $this->model_post->find_all_active($params);

        // Fetch comments
        if(count($query)>0){
            // Get total post count
            $medial_post_count = $this->media_counts($ids);

            foreach($query as $row):
                // Fetch comment
                $comment_data = $this->medial_post_comment->comments_list($row['media_id'],null,2);
                // Set data
                $result[] = array(
                    'media_data'=>$row,
                    'media_comment'=>$comment_data
                );
            endforeach;
        }
        else{
            $medial_post_count = 0;
            $result = array();
        }


        return $result;
        //return array($result,$medial_post_count);
    }



    // Time line , user profile and group posts
    //public function find_post($ids,$limit=0 , $last_id=0, $type, $group_ids)
    public function find_post()
    {
        // Set fields
        $params['fields'] = "media_id,media_user_id,media_page_type,media_page_id,media_type,media_other_action_id,media_description,media_file,media_file_path,
                            media_visibility,media_createdon,user_id,CONCAT(user_firstname, ' ', user_lastname) as name,
                            ui_profile_image as signup_profile_image,ui_profile_image_path as signup_profile_image_path";
                            

        // JOIN
        $params['joins'][] = array(
            "table"=>"user" ,
            "joint"=>"user.user_id = media_user_id",
        );
        
        $params['joins'][] = array(
            "table"=>"user_info" ,
            "joint"=>"user_info.ui_user_id = media_user_id",
        );
        

        // order by
        $params['order'] = "media_id DESC";

        if(isset($_GET['type']) AND ($_GET['type'] == 'message')) {
            $params['where']['media_type'] = 1;
        }

        if(isset($_GET['type']) AND ($_GET['type'] == 'photo')) {
            $params['where']['media_type'] = 2;
        }

        if(isset($_GET['type']) AND ($_GET['type'] == 'audio')) {
            $params['where']['media_type'] = 3;
        }

        if(isset($_GET['type']) AND ($_GET['type'] == 'video')) {
            $params['where']['media_type'] = 4;
        }


        if(isset($_GET['search'])) {
            $params['where_like'][] = array('column'=>'user_firstname','value'=>$this->input->get('search'),'type'=>'both');
            $params['where_or_like'][] = array('column'=>'user_lastname','value'=>$this->input->get('search'),'type'=>'both');
        }


        // Query
        $query = $this->model_post->find_all_active($params);
        
        $result = array();
        if(isset($query) AND array_filled($query)) {
            foreach($query as $key=>$value) {
                $result[$key] = $value;
                $result[$key]['comments'] = $this->medial_post_comment->comments_list($value['media_id']);
            }
        }
        
        //debug($result,1);
        return $result;
    }

    // Get total post count
    public function media_counts($ids)
    {
        // Set fields
        $params['fields'] = "media_user_id";
        // Set params
        $params['where_in']['media_user_id'] = $ids;
        // Return data
        return $this->model_post->find_count_active($params);
    }
    */
    public function get_fields($specific_field = "")
    {

        $fields = array(
            'media_id' => array(
                'table' => $this->_table,
                'name' => 'media_id',
                'label' => 'ID #',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => 'trim'
            ),



            'media_parent_id' => array(
                'table' => $this->_table,
                'name' => 'media_parent_id',
                'label' => 'Parent ID',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim'
            ),

            'media_user_id' => array(
                'table' => $this->_table,
                'name' => 'media_user_id',
                'label' => 'User ID',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'required|trim|htmlentities'
            ),
            'media_type' => array(
                'table' => $this->_table,
                'name' => 'media_type',
                'label' => 'Post Type',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'required|trim|htmlentities'
            ),

            // text
            'media_title' => array(
                'table' => $this->_table,
                'name' => 'media_title',
                'label' => 'Title',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'required|trim|htmlentities'
            ),

            'media_description' => array(
                'table' => $this->_table,
                'name' => 'media_description',
                'label' => 'Description',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'required|trim|htmlentities'
            ),

            // Image , video
            'media_file' => array(
                'table' => $this->_table,
                'name' => 'media_file',
                'label' => 'File',
                'name_path' => 'media_file_path',
                //'upload_config' => 'upload_post',
                'type' => 'fileupload',
                'type_dt' => 'image',
                'randomize' => true,
                'preview' => 'true',
                'attributes' => array(
                    //'image_size' => 'Recommended Avatar image size : 50px x 50px',
                    'allow_ext'=>'mp4|mpeg',
                ),
                'dt_attributes' => array("width" => "10%"),
                'rules' => 'trim|htmlentities'
            ),


            'media_createdon' => array(
                'table' => $this->_table,
                'name' => 'media_createdon',
                'label' => 'Post Createdon',
                'type' => 'label',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => '|trim'
            ),

            'media_status' => array(
                'table' => $this->_table,
                'name' => 'media_status',
                'label' => 'Status?',
                'type' => 'switch',
                'type_dt' => 'dropdown',
                'type_filter_dt' => 'dropdown',
                'list_data' => array(),
                'default' => '1',
                'attributes' => array(),
                'dt_attributes' => array("width" => "7%"),
                'rules' => 'trim'
            ),

        );

        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;

    }
}

?>