<?
class Model_expose_chat extends MY_Model
{

    /**
     * Model_chat Model
     *
     * @package     Model_chat
     * @author      
     * @version     1.0
     * @since       24 May,2017
     */

    protected $_table = 'expose_chat';
    protected $_field_prefix = 'ec_';
    protected $_pk = 'ec_id';
    protected $_status_field = 'ec_status';
    public $pagination_params = array();

    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }

    
    private function _get_chat_fields()
    {
        // Set params
        // $params_messages['fields'] = "chat_id,chat_message_from,chat_message_to,chat_message,chat_attachment,chat_attachment_path,chat_message_type,
        //     chat_message_createdon,CONCAT(from_user.user_firstname , ' ' , from_user.user_lastname) as sender,
        //     CONCAT(from_user.signup_support_image_path , from_user.signup_support_image) as sender_image,
        //     CONCAT(to_user.user_firstname , ' ' , to_user.user_lastname) as receiver";

        return "ec_id,ec_group_id,ec_member_id,ec_message,ec_attachment,ec_attachment_path,ec_type,
            ec_createdon,CONCAT(from_user.user_firstname , ' ' , from_user.user_lastname) as sender,
            CONCAT(from_user_info.ui_profile_image_path , from_user_info.ui_profile_image) as sender_image,
            ";
    }

    public function get_unread_msg_count($user_id,$profile_id)
    {
        return 10;
    }


    // Get chat messages
    public function chat_messages($group_id)
    {
        // get chat fields
        $params_messages['fields'] = $this->_get_chat_fields();

        // $params_messages['where_string'] = "( (chat_message_from=$user_id AND chat_message_to=$profile_id) OR
        //     (chat_message_from=$profile_id AND chat_message_to=$user_id) )";

        $params_messages['where']['ec_group_id'] = $group_id;

        // JOIN
        $params_messages['joins'][] = array(
            "table"=>"{pre}user as from_user" ,
            "joint"=>"ec_member_id=from_user.user_id",
        );

        $params_messages['joins'][] = array(
            "table"=>"{pre}user_info as from_user_info" ,
            "joint"=>"ec_member_id=from_user_info.ui_user_id",
        );

        // Order by desc (latest)
        $params_messages['order'] = "ec_id DESC";
        // Set limit (fetch only 10 messages)
        //$params_messages['limit'] = MSG_PAGING;
        // Query to get message
        $messages = $this->find_all($params_messages);

        // Remove extra columns and use already init params
        unset($params_messages['order']);
        unset($params_messages['limit']);

        // Get count total message
        $messages_count = $this->find_count($params_messages);
        
        // show old messages at bottom
        //return array_reverse($this->model_chat->find_all($params_messages));
        return array(array_reverse($messages),$messages_count);

    }

    // Load more chat messages
    public function pagination($group_id)
    {

        // Check Pagination ID set or not
        $pagination_id = string_decrypt($this->input->post('pagination_id'));
        
        if($pagination_id!=null){
            //$pagination_where = "AND ec_id < " . $pagination_id;
            $params_messages['where']['ec_id <'] = $pagination_id;
        }
        else{
            //$pagination_where = "";
        }

        // get chat fields
        $params_messages['fields'] = $this->_get_chat_fields();


        $params_messages['where']['ec_group_id'] = $group_id;

        // JOIN
        $params_messages['joins'][] = array(
            "table"=>"{pre}user as from_user" ,
            "joint"=>"ec_member_id=from_user.user_id",
        );

        $params_messages['joins'][] = array(
            "table"=>"{pre}user_info as from_user_info" ,
            "joint"=>"ec_member_id=from_user_info.ui_user_id",
        );

        
        // Order by desc (latest)
        $params_messages['order'] = "ec_id DESC";
        // Set limit (fetch only 10 messages)
        $params_messages['limit'] = MSG_PAGING;
        // Query to get message
        $messages = $this->find_all($params_messages);


        // Remove extra columns and use already init params
        unset($params_messages['order']);
        unset($params_messages['limit']);

        // Get count total message
        $messages_count = $this->find_count($params_messages);

        // show old messages at bottom
        return array(array_reverse($messages),$messages_count);

    }
    



    // Save chat photo and return data (only save)
    public function save_chat_photo()
    {
        global $config;

        $fields = $this->get_fields();
        $user_data = $this->_attributes ;
        $pk = $this->get_pk();
        $this->insert_id = '';
        foreach($fields AS $field_name => $fld)
        {
            $user_field_data = $user_data[$field_name] ;

            // For file uploads, data will not be in POST var.
            if(!$user_field_data && $_FILES['name'][$field_name])
                $user_field_data = $_FILES['name'][$field_name] ;

            if($field_name==$pk)
            {
                $fkeys = $fld['foreign_keys'] ? $fld['foreign_keys'] : $this->relations ;
                if(intval($user_field_data)>0)
                {
                    $this->insert_id = $user_field_data;
                    $params = array();
                    $params['where'] = array($pk => $this->insert_id);
                    $old_data = $this->find_one($params);

                    if(!$old_data)
                        end_script("Record with ID {$this->insert_id} not FOUND");

                    //SET WHERE CLAUSE FOR UPDATE QUERY. NO OTHER QUERY MUST RUN BEFORE IT.
                    $mode = "update";
                }
                else {
                    $mode = "insert";
                    //Dont add this premium key in $record
                    continue;
                }

            }

            // Skipping for default value incase it's an insert and user did not set any value for it.
            if(!isset($user_field_data) && $mode == "insert" && !in_array($fld['type'] ,array("checkbox","switch")) )
                continue;

            if($fld['relation_type'])
            {
                switch($fld['relation_type'])
                {
                    case "many_to_many":
                        $model = $fld['relation_model'];
                        if(is_array($user_field_data))
                        {
                            foreach ($user_field_data  as $key => $val) {
                                $many_to_many_data[$model][$key][$field_name] = $val ;
                            }
                        }

                        break;
                    case "one_to_many":
                        break;
                }

                continue; //Do not insert the data in current MODEL table if it's a relation
            }

            switch ($fld['type']) {
                case 'fileupload':

                    if($config[ $fld['upload_config'] ])
                        $destination_path = $config[$fld['upload_config']] ;
                    else
                        $destination_path = $config['site_upload_default'] . $this->_table."/" ;

                    if( is_array($_FILES) && $_FILES[$this->_table]['name'][$field_name] )
                    {
                        $file_params = array();
                        $file_params['name'] = $_FILES[$this->_table]['name'][$field_name] ;
                        $file_params['tmp_name'] = $_FILES[$this->_table] ['tmp_name'] [$field_name] ;
                        $file_params['destination_path'] = $destination_path ;
                        $file_params['field_config'] = $fld ;
                        $file_params['old_data'] = $old_data;

                        $uploadhelper = new Fileupload_helper($file_params);
                        $uploaded = $uploadhelper->do_upload();
                        if($uploaded['error'])
                        {
                            pre($uploaded['error']);
                        }
                        else
                        {
                            $record = $record + $uploaded ;
                        }

                        // Remove Old file - If availabel


                    }
                    //continue; //Awesomely, Skip remaining flow for this iteration
                    break;
                case 'switch':
                    $record[$field_name] = intval($user_field_data);
                    break;
                default:
                    if(($user_field_data !== null))
                        $record[$field_name] = $user_field_data;
                    break;
            }
            if($fld['index']=='foreign')
            {
                $record[$field_name] = isset($record[$field_name]) ? $record[$field_name] :  $_POST['indices']['pk'][$fld['relation']];
            }

        }

        if($mode)
        {

            if($mode == "update" && $this->insert_id)
                $this->db->where($pk, $this->insert_id);

            // Save Model
            if($this->db->$mode($this->_table,$record))
            {
                $this->insert_id = $this->insert_id ? $this->insert_id : $this->db->insert_id();

                // Do relation stuff if relation exists..
                if( $this->insert_id && is_array($many_to_many_data) && count($many_to_many_data) )
                {

                    foreach ($many_to_many_data as $model => $mdata) {
                        $where = array();
                        $where[ $fkeys[$model]['pk'] ] = $this->insert_id ;
                        $this->$model->delete($where);
                        foreach ($mdata as $dt) {
                            # code...
                            $dt[ $fkeys[$model]['pk'] ] = $this->insert_id ;
                            $this->$model->set_attributes($dt);
                            $this->$model->save();
                        }
                    }
                }
            }
            else {
                pre("$mode failed for {$this->_table}");
            }
        }
        else {
            pre("No PK set for ".$this->_table." in get_fields function in model");
        }
        $_POST['indices']['pk'][$this->_table] = $this->insert_id;
        //return $this->insert_id;
        return $record;
    }

    
    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */

    public function get_fields($specific_field = "")
    {

        $fields = array(
            'ec_id' => array(
                'table' => $this->_table,
                'name' => 'ec_id',
                'label' => 'ID #',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => 'trim'
            ),

            'ec_group_id' => array(
                'table' => $this->_table,
                'name' => 'ec_group_id',
                'label' => 'Group ',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => '|required|trim|htmlentities'
            ),

            'ec_member_id' => array(
                'table' => $this->_table,
                'name' => 'ec_member_id',
                'label' => 'Member/Admin',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => '|required|trim|htmlentities'
            ),

            'ec_message' => array(
                'table' => $this->_table,
                'name' => 'ec_message',
                'label' => 'Chat message',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => '|required|trim|htmlentities'
            ),
            'ec_attachment' => array(
                'table' => $this->_table,
                'name' => 'ec_attachment',
                'label' => 'Image (Avatar)',
                'name_path' => 'ec_attachment_path',
                'upload_config' => 'upload_photo_chat',
                'type' => 'fileupload',
                'type_dt' => 'image',
                'randomize' => true,
                'preview' => 'true',
                'attributes' => array('image_size' => 'Recommended Avatar image size : 50px x 50px','allow_ext'=>'png|jpg|jpeg|xls|xlsx|docx|doc'),
                'dt_attributes' => array("width" => "10%"),
                'rules' => 'trim|htmlentities'
            ),

            'ec_type' => array(
                'table' => $this->_table,
                'name' => 'ec_type',
                'label' => 'Chat type',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'list_data'    => array(
                    1 => "text"  ,
                    2 => "photo" ,
                    3 => "music" ,
                    4 => "file" ,
                ) ,
                'rules' => '|required|trim|htmlentities'
            ),

            'ec_createdon' => array(
                'table' => $this->_table,
                'name' => 'ec_createdon',
                'label' => 'Message Createdon',
                'type' => 'label',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => '|trim'
            ),

            'ec_status' => array(
                'table' => $this->_table,
                'name' => 'ec_status',
                'label' => 'Status?',
                'type' => 'switch',
                'type_dt' => 'dropdown',
                'type_filter_dt' => 'dropdown',
                'list_data' => array(),
                'default' => '1',
                'attributes' => array(),
                'dt_attributes' => array("width" => "7%"),
                'rules' => 'trim'
            ),


            // 'chat_message_unread' => array(
            //     'table' => $this->_table,
            //     'name' => 'chat_message_unread',
            //     'label' => 'Unread Message?',
            //     'type' => 'switch',
            //     'type_dt' => 'dropdown',
            //     'type_filter_dt' => 'dropdown',
            //     'list_data' => array(),
            //     'default' => '0',
            //     'attributes' => array(),
            //     'dt_attributes' => array("width" => "7%"),
            //     'rules' => 'trim'
            // ),

        );

        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;

    }

}

?>