<?
class Model_email extends MY_Model {
  
    /**
     * TKD Email MODEL
     *
     * @package     Email Model
     * @author      Waqas Ahmed (waqasahmed.it@gmail.com)
     * @version     2.0
     * @since       2015 
     */

    private $to;
    private $from = 'creactivityhub@gmail.com';
    private $subject;
    private $msg;


    private $billingEmail = 'creactivityhub@gmail.com';//'billing@chemco.com';
    private $customerSupportEmail = 'creactivityhub@gmail.com';//'cs@chemco.com';
    private $salesEmail = 'martingarix7878@gmail.com';//'sales@chemco.com';
    // private $salesEmail = 'creactivityhub@gmail.com';//'sales@chemco.com';
    private $technicalEmail = 'creactivityhub@gmail.com';//'technical@chemco.com';
    private $developerEmail = 'creactivityhub@gmail.com';//'waqas.ahmed@digitonics.com';

    private $_template = 'default_template';//'query';

    function __construct()
    {
        parent::__construct();

        $this->to = $this->_set_to_email();
    }


    private function _set_to_email()
    {
        $this->load->model('model_config');
        
        $config_info = $this->model_config->find_by_pk(6);

        if(array_filled($config_info))
            return $config_info['config_value'];
        else
            return 'dalton.developer@gmail.com';
    }

    public function email($send_to ='' , $send_from ='' , $subject ='' ,  $msg ='')
    {
        if(ENVIRONMENT == 'development')
        {
            // echo $send_to . "<br />";
            // echo $send_from . "<br />";
            // echo $subject . "<br />";
            // echo $msg . "<br />";
            // die();
        }
        
        parent::email($send_to,$send_from,$subject,$msg);
    }


    #1- Contact us inquriy
    public function contactInquiry($data)
    {
        $this->from = isset($data['inquiry_email']) ? $data['inquiry_email'] : $this->from;
        $this->subject = isset($data['inquiry_heading']) ? $data['inquiry_heading'].' Inquiry' : 'Contact us Inqiury';

        $param = array();
        if(isset($data) && array_filled($data))
        {
            foreach($data as $kye=>$value)
            {
                $param['form_input'][$kye] = htmlentities(trim($value));
            }
        }

        $param['title'] = 'Contact us Inquiry';
        $param['msg'] = 'Dear Admin,<br> <br>
                        We have received an inquiry in your website, detail is given below:<br><br>';

        unset($param['form_input']['inquiry_status']);
        $this->msg = $this->load->view('_layout/email_template/'.$this->_template , $param , true);
        
        $this->email($this->to , $this->from , $this->subject , $this->msg);

        return true;
    }


    public function contactInquiryThreading($data)
    {
        $this->from = $data['it_sender_email'];
        $this->subject = $data['it_subject'];
        $this->to = $data['it_receiver_email'];

        $param = array();
        if(isset($data) && array_filled($data))
        {
            foreach($data as $kye=>$value)
            {
                $param['form_input'][$kye] = htmlentities(trim($value));
            }
        }

        $content = 'Dear '.$data['it_receiver_name'].'<br />';
        //$content .= 'Thanks for joining '.g('site_title').'<br />';
        $content .= $data['it_message'];
        $content .= "<h4>".ticket_no($data['it_inquiry_id'])."</h4><hr />";
        
        $param['msg'] = $content;

        unset($param['form_input']['inquiry_status']);
        $this->msg = $this->load->view('_layout/email_template/'.$this->_template , $param , true);
        
        $this->email($this->to , $this->from , $this->subject , $this->msg);

        return true;
    }

    #2- Contact us inquriy
    public function subscribe_newsletter($id)
    {
        //$this->_template = 'default';
        $data = $this->model_newsletter->find_by_pk($id);
        
        $this->subject = g('site_title') . ' - Subscriber';
        
        $this->to =  $data['newsletter_email'];
        
        $name = (isset($data['newsletter_name']) AND !empty($data['newsletter_name'])) ? $data['newsletter_name'] : $this->to;

        $content = 'Congratulations! You have successfully subscribed.';

        $content = 'Dear '.$name.'<br />';
        $content .= 'Thanks for joining '.g('site_title').'<br />';
        $content .= 'Congratulations! You have successfully subscribed was made on '.date("m/d/Y g:i a").' <br />';
        $content .= 'Thanks again for joining'. g('site_title'). '.<br />';
        $content .= 'Happy working,<br />';
        $content .= 'The ' . g('site_title') . ' Team';

        $param['msg'] = $content;
        
        //$param['form_input']['comments'] = $content;

        $this->msg = $this->load->view('_layout/email_template/'.$this->_template , $param , true);
        

        $this->email($this->to , $this->from , $this->subject , $this->msg);

        return true;
    }



    public function notification_register($id , $type='user')
    {
        $data = $this->model_user->find_by_pk($id);

        

        $token = md5("REG-".$id."GEF");

        $user_type = $this->model_user->find_user_type($data['user_type']);
        if($type == 'user')
        {
            $this->from = $this->customerSupportEmail;//$this->_set_to_email();
            $this->to = $data['user_email'];
            
            $random = $data['user_token_number'];
            $url = g('base_url') . "signup/authentication/$id/?token=$token";

            $this->subject = 'Please complete your '.g('site_title').' account registration';
            if($data['user_status'] == 1){
                $m = 'activate';
            }
            else{
                $m = 'approve';
            }

            $content = 'Thanks for joining '.g('site_title').'. We are ready to '.$m.' your account but want to verify your email 
                    address and the authenticity of your request first. Our records show the email of '.$data['user_email'].' 
                    registered for a '.g('site_title').' account on '.date("m/d/Y g:i a",strtotime($data['user_createdon'])).'<br /><br />';

            $content .= 'Please <a href="'.$url.'">click here</a> to confirm your intention to register on '.g('site_title').'.<br /><br />';
            $content .= 'Your confirmation enables you to access and utilize all features on '.g('site_title').'. 
                        If this activity occurred without your knowledge or permission, we would appreciate your notifying 
                        us at '.$this->customerSupportEmail.'<br /><br />';

           

            $param['msg'] = $content;
        }
        else {
            $this->from = $this->customerSupportEmail;
            $this->to = $this->_set_to_email();

            if($data['user_status'] == 1){
                $this->subject = 'One user registered in '.g('site_title');
            }
            else{
                $this->subject = 'One user registration pending in '.g('site_title');
            }
            $list = $this->model_user->get_list_data('user_status');
            $param['title'] = 'User Detail';
            $content = 'Hey Admin, One '.$user_type.' has been registered in your website.';
            $param['msg'] = $content;
            $param['form_input']['firstname'] = htmlentities(trim($data['user_firstname']));
            $param['form_input']['lastname'] = htmlentities(trim($data['user_lastname']));
            $param['form_input']['email'] = htmlentities(trim($data['user_email']));
            $param['form_input']['status'] = isset($list[$data['user_status']]) ? $list[$data['user_status']] : 'In-Active';

            if($data['user_status'] == 3){
                $param['form_input']['link'] = '<a href="'.la('user/add/'.$data['user_id']).'">Approve Profile</a>';
            }
        }
        
        $this->msg = $this->load->view('_layout/email_template/'.$this->_template , $param , true);
        
        $this->email($this->to , $this->from , $this->subject , $this->msg);

        return true;
    }


    // RESET PASSWORD EMAIL
    public function reset_password($data)
    {
        $this->from = $this->customerSupportEmail;

        $name = $data['user_firstname'] . " " . $data['user_lastname'];
        $this->to = $data['user_email'];
        $token = "HYQ357".$data['user_id']."-354T";

        $encrypt_code = md5($token);
        $url = g('base_url') . "account/reset_password/index/{$encrypt_code}/?token={$token}";

        $content = "$name, <br />";
        $content .= 'We received a password reset request from '.$this->to.'. <br />';
        $content .= 'To reset your '.g('site_title').' account password please <a href="'.$url.'">click here</a> <br />';
        $content .= 'If this activity occurred without your knowledge or permission, we would appreciate your notifying us at '.$this->customerSupportEmail.'<br />';
        $content .= 'Thank you <br />' ;
        $content .= g('site_title') . ' Team';

       
        $param['msg'] = $content;
        
        $this->msg = $this->load->view('_layout/email_template/'.$this->_template , $param , true);
        
        $this->subject = 'Please complete your '.g('site_title').' password reset request';
    
        parent::email($this->to , $this->from ,$this->subject, $this->msg);

        return true;
    }


    // Newsletter Email 
    public function send_request_service_quote($id)
    {
        $data = $this->model_service_quote->get_by_pk_email_notification($id);
        $this->subject = "Service Request a Quote Notification";
        $this->to =  $data['provider_email'];
        $name = $data['provider_name'];
        
        $content = 'Dear '.$name.'<br />';
        $content .= 'Request a quote received in your profile, Please view the detail<br />';
        $content .= "Client Name : <strong>".$data['client_name']."</strong><br />";
        $content .= "Client Phone : <strong>".$data['client_phone']."</strong><br />";
        $content .= "Client Email : <strong>".$data['client_email']."</strong><br />";
        $content .= "Schedule : <strong>".$data['sq_schedule']."</strong><br />";
        $content .= "Service : <strong>".$data['service_name']."</strong><br />";
        $content .= "Client Message : <strong>".$data['client_desc']."</strong><br /><br />";

        $content .= 'Happy working,<br />';
        $content .= 'The ' . g('site_title') . ' Team';

        $param['msg'] = $content;
        
        //$param['form_input']['comments'] = $content;

        $this->msg = $this->load->view('_layout/email_template/'.$this->_template , $param , true);
        
        $this->email($this->to , $this->from , $this->subject , $this->msg);

        return true;
    }


    public function authenticate_notifcation($user_id,$password='xxxxxxxxxx')
    {
        $data = $this->model_user->find_by_pk($user_id);
        
        $this->from = $this->customerSupportEmail;

        $name = $data['user_firstname'] . " " . $data['user_lastname'];
        $this->to = $data['user_email'];
        
        $param = array();
        if(isset($data) && array_filled($data))
        {
            $param['form_input']["Name"] = $name;
            $param['form_input']["Your Email"] = $data['user_email'];
            $param['form_input']["Your Password"] = 'Your password';//$password;
        }
        
        $param['title'] = $this->subject;//'Contact us Inquiry';
        $param['msg'] = "Dear {$name},<br> <br>
                        Now your Lecturer request has been approved, detail is given below:<br><br>";

        $this->msg = $this->load->view('_layout/email_template/'.$this->_template , $param , true);

        $this->subject = g('site_title').' Account Info';
        
        parent::email($this->to , $this->from ,$this->subject, $this->msg);
        return true;
    }


    public function annoucement_notifcation($id)
    {
        $annoucement_data = $this->model_announcements->find_by_pk($id);
        $param = array();
        if($annoucement_data['announcements_course_id'] > 0)
        {
            $param['fields'] = '
            shop_item.item_product_id as course_id,user.user_id,
            user.user_firstname,user.user_lastname,user.user_email,user.user_status,user.user_type,
                shop_order.order_id as oid,shop_order.order_payment_status
            ';
            $param['joins'][] = array(
                "table"=>"shop_order" , 
                "joint"=>"shop_order.order_id = shop_item.item_order_id AND shop_order.order_payment_status = 1",
            );
            $param['joins'][] = array(
                "table"=>"user" , 
                "joint"=>"user.user_id = shop_order.order_user_id AND user.user_status = 1",
            );
            $param['where']['item_product_id'] = $annoucement_data['announcements_course_id'];
            $data = $this->model_shop_item->find_all($param);
            //debug($data,1);
        }
        else{
            $param['fields'] = 'user_id,user_firstname,user_lastname,user.user_email,user_status,user_type';
            $param['where']['user_type'] = 0;
            $data = $this->model_user->find_all($param);
        }

        $student_list = array();
        if(isset($data) AND array_filled($data)){
            foreach($data as $key=>$value){
                $student_list[$value['user_id']] = $value['user_email'];
            }
        }
        if(array_filled($student_list)){ 
            $this->from = $this->customerSupportEmail;
            $this->to = implode(",", $student_list) ;
            $this->subject = $annoucement_data['announcements_title'];
            $param = array();
            $param['msg'] = html_entity_decode($annoucement_data['announcements_description']);
            $this->msg = $this->load->view('_layout/email_template/'.$this->_template , $param , true);
            
            parent::email($this->to , $this->from ,$this->subject, $this->msg);
        }
        return true;
    }

    // public function product_inquiry_mail($id)
    // {
    //     $data = $this->model_product_inquiry->get_by_pk($id);
        
    //     $this->from = $this->customerSupportEmail;
    //     $this->to = $this->_set_to_email();
    //     $this->subject = 'Purchased Product Info ('.$data['product_name'].')';
        
    //     $param['title'] = 'Product Inquiry Detail';
    //     $content = 'Hey Admin, Product has been purchased in your website.<br />';
    //     $content .= 'Detail is given below.<br />';
    //     $content .= 'Product Name : ' . $data['product_name'] . "<br />";
    //     $content .= 'Product Points : ' . $data['product_price'] . "<br />";
    //     $content .= 'User Name : ' . $data['user_firstname'] . ' ' .$data['user_lastname'] . "<br />";
    //     $content .= 'User Email : ' . $data['user_email'] . "<br />";
    //     $content .= 'User Phone : ' . $data['pi_phone'] . "<br />";
    //     $content .= 'Subject : ' . $data['pi_subject'] . "<br />";
    //     $content .= 'Description : ' . $data['pi_message'] . "<br />";

    //     $param['msg'] = $content;


    //     $this->msg = $this->load->view('_layout/email_template/'.$this->_template , $param , true);
        
    //     $this->email($this->to , $this->from , $this->subject , $this->msg);

    //     return true;
    // }



    


    #2- Friend Request inquriy
    // public function send_friend_request($data , $type)
    // {
    //     $token = md5(FRIEND_REQUEST.$data['fr_bike_id']);
    //     $url = l('excel_file/index/'.$data['fr_bike_id']) . "?token={$token}";
        
    //     $this->subject = g('site_title').' Build File';//isset($data['fr_subject']) ? $data['fr_subject'].' (Bike Build to a Friend)' : 'Bike Build to a Friend';

    //     $param = array();
    //     if(isset($data) && array_filled($data))
    //     {
    //         $param['form_input']['bike'] = 'Seven Axiom SL';
    //         $param['form_input']['message'] = $data['fr_comment'];
    //         $param['form_input']['friend'] = $data['fr_friend_fname'] . " " . $data['fr_friend_lname'];
    //         $param['form_input']['friend_email'] = $data['fr_to_email'];
    //         $param['form_input']['your_email'] = $data['fr_from_email'];
    //         $param['form_input']['file'] = "To download the file from BikeTrik: <a href='{$url}'>Click Here</a>";


    //         //$param['form_input']['subject'] = $data['fr_subject'];

    //     }
        
    //     $param['title'] = 'Request Detail';

    //     if($type == 'sender')
    //     {
    //         $this->from = $this->customerSupportEmail;
    //         $this->to = isset($data['fr_from_email']) ? $data['fr_from_email'] : $this->from;

    //         $param['msg'] = 'Dear sender,<br> <br>
    //                     You have send a friend request for bike build, detail is given below:<br><br>';
    //     }
    //     else if($type == 'receiver')
    //     {
    //         $this->from = isset($data['fr_from_email']) ? $data['fr_from_email'] : $this->from;
    //         $this->to = isset($data['fr_to_email']) ? $data['fr_to_email'] : $this->from;

    //         $param['msg'] = 'Dear '.$param['form_input']['friend'].',<br> <br>';
    //         $param['msg'] .= 'A friend wanted to share their bike\'s build file with you.<br> <br>';
    //         $param['msg'] .=  'Contact the friend identified above if you have concerns or questions about the 
    //                             authenticity of this share. If you don’t know the friend listed or have confirmed 
    //                             that your friend didn’t initiate the share, we would appreciate your letting us know at '. $this->customerSupportEmail.'<br> <br>';
            
    //         // $param['msg'] = 'Dear '.$param['form_input']['friend_name'].',<br> <br>
    //         //             We have received the friend request for bike build, detail is given below:<br><br>';
    //     }
    //     else 
    //     {
    //         $this->from = isset($data['fr_from_email']) ? $data['fr_from_email'] : $this->from;
    //         $this->to = $this->to;

    //         $param['msg'] = 'Dear Admin,<br> <br>
    //             One user send a friend request for bike build, detail is given below:<br><br>';
    //     }
        
    //     $this->msg = $this->load->view('_layout/email_template/'.$this->_template , $param , true);
        
    //     $this->email($this->to , $this->from , $this->subject , $this->msg);

    //     return true;
    // }


    // Email Notification 
    //public function notification_register($to , $from = '', $type , $data)
    



    

    public function request_account_activate($user_id,$token)
    {
        $data = $this->model_user->find_by_pk($user_id);

        $this->to = $data['user_email'];
        $this->from = $this->customerSupportEmail;

        
        $encrypt_code = $token['ut_token'];
        $url = g('base_url') . "account/active_account/request/{$encrypt_code}/";


        $content = 'Thanks for joining '.g('site_title').'. We are ready to activate your account but want to verify your email address 
                    and the authenticity of your request first. Our records show the email of '.$this->to.' 
                    requested account activation on '.date("m/d/Y g:i a",strtotime($data['user_createdon'])).'<br /><br />';

        $content .= 'Please <a href="'.$url.'">click here</a> Verify Address and enter this token# <strong>'.$data['user_account_activate_token'].'</strong> to securely confirm your activation request.<br /><br />';

        $content .= 'If this activity occurred without your knowledge or permission, we would appreciate your notifying us at '.$this->customerSupportEmail.'<br /><br />';
        $content .='Thank you <br />';
        $contnetn .= 'Team '.g('site_title');

        
        
        $param['msg'] = $content;

        
        $this->msg = $this->load->view('_layout/email_template/'.$this->_template , $param , true);

        $this->subject = 'Please complete your request for account activation with '.g('site_title');
        //$this->subject = g('site_title') . ' - Request account activate';

        parent::email($this->to , $this->from ,$this->subject, $this->msg);
        return true;
    }


    // public function notification_invoice($id , $type = 'USER')
    // {
    //     $id = intval($id);
    //     $invoice = $this->model_user_package->get_by_pk($id);
    //     //$result = $invoice;

    //     // Company Letter Head
    //     $result['letter_head']['logo'] = $this->model_logo->get_logo();
    //     $result['letter_head']['name'] = g('site_title');
    //     $result['letter_head']['address'] = g('db.admin.company_address');
    //     $result['letter_head']['phone'] = g('db.admin.company_phone');

    //     // Customer Info
    //     $result['customer_info']['name'] = ucfirst($invoice['user_firstname'] . ' ' . $invoice['user_lastname']);
    //     $result['customer_info']['address'] = '';
    //     $result['customer_info']['phone'] = '';
    //     $result['customer_info']['email'] = $invoice['user_email'];


    //     $result['items_info']['heading'] = array('Item','Rate','Amount');
    //     $sub_total = $invoice['up_price'];
    //     $item_name = $invoice['package_name']." Package Subscriber";
    //     $result['items_info']['item'][] = array($item_name,price($sub_total),price($sub_total));

    //     // Amount Info
    //     $result['amount_info']['sub_total'] = $sub_total;
    //     $result['amount_info']['shipping_charges'] = $invoice['order_shipping_amount'];
    //     $result['amount_info']['tax'] = $invoice['order_tax_amount'];
    //     $result['amount_info']['discount'] = $invoice['order_discount_amount'];
    //     $total_amount = ($result['amount_info']['sub_total']+$result['amount_info']['shipping_charges']+$result['amount_info']['tax'])-$result['amount_info']['discount'];
    //     $result['amount_info']['total_amount'] = $total_amount;

    //     // Invoice Info
    //     $result['invoice_info']['no'] = order_no($id);
    //     $result['invoice_info']['payer'] = $invoice['up_paypal_ipn_track_id'];
    //     $result['invoice_info']['date'] = date("M d,Y", strtotime($invoice['up_paypal_date']));
    //     $result['invoice_info']['invoice_amount'] = price($total_amount);
        
    //     $content = $this->load->view('_layout/email_template/email_template2',$result,true);

    //     if($type == 'USER')
    //         $send_to = $invoice['user_email'];
    //     else
    //         $send_to = $this->_set_to_email();
        
    //     $send_from = $this->salesEmail;

    //     $subject = 'Payment Acknowledgment';

    //     $this->to = $send_to;
    //     $this->from = $send_from;
    //     $this->subject = $subject;
    //     $this->msg = $content;
    //     parent::email($this->to , $this->from ,$this->subject, $this->msg);
        
    //     return true;
    // }


    




    public function notification_invoice($order_id , $type = 'USER')
    {
        $id = intval($order_id);

        $order_data = $this->model_shop_order->find_by_pk($id);

        $param['order_note'] = $order_data['order_shipping_order_description'];


        //ADD SHIPPING AMOUNT
        $param['order_tax'] = $order_data['order_tax_amount'];

        $param['order_discount'] = $order_data['order_discount_amount'];
        $param['discount_amount'] = $param['order_discount']; // just for extra use

        $param['order_shipping_amount'] = $order_data['order_shipping_amount'];
        $param['shipping_amount'] = $param['order_shipping_amount'];// just for extra use
 
        
        $param['type'] = $type;

        //ADD USER EMAIL ID's
        $user_email[] = $order_data['order_billing_email'];
        $user_email[] = $order_data['order_shipping_email'];
        $param['user_email'] = implode(",", array_unique($user_email));
        
        //GET EMAIL FROM SAVE IN DB
        $db_param = array();
        $db_param['where_string'] = 'config_id = 6';
        $admin_email = $this->model_config->find_all_list_active($db_param , 'config_value');

        $param['inquiry_email'] = $admin_email[6];
        $param['business_email'] = $admin_email[6];
        
        //SOME TYPE WISE DATA
        if($type == 'USER'){
            $param['name'] = $order_data['order_billing_fname'] . ' ' . $order_data['order_billing_lname'];
            
            $param['email'] = $param['user_email'];
        }
        else{
            $param['name'] = 'Admin';

            $param['email'] = $confirmation_email;
        }
        
        
        // CUSTOMER BILLING ADDRESS
        
        $param['billing_address'] = $order_data['order_billing_address'];

        if(!empty($order_data['order_billing_city']))
            $param['billing_address'] .= ', ' . $order_data['order_billing_city'];

        if(!empty($order_data['order_billing_state']))
            $param['billing_address'] .= ' ' . $order_data['order_billing_state'];

        if(!empty($order_data['order_billing_zip_code']))
            $param['billing_address'] .= ' ' . $order_data['order_billing_zip_code'];


        $fields = $this->model_shop_order->get_fields('order_payment_status');
        $param['payment_status'] = $fields['list_data'][$order_data['order_payment_status']];
        
        $param['order_no'] = order_no($id);



        // GET ORDER ITEM
        $oi_param['where']['item_order_id'] = $id;
        $order_item = $this->model_shop_item->find_all($oi_param);
        
        

        $i=1;
        $total_invoice_amount = 0; 
        foreach($order_item as $order_item_value)
        {
            $param['product'][$i]['product_name'] = $order_item_value['item_product_name'];
            
            $param['product'][$i]['product_qty'] = $order_item_value['item_qty'];
            
            $param['product'][$i]['product_rate'] = $order_item_value['item_rate'];

            $param['product'][$i]['product_total'] = $order_item_value['item_price'];
            
            $total_invoice_amount += $order_item_value['item_price'];
            
            $i++;
        }


        $param['test_mode'] = ($order_data['order_is_sandbox']== 1) ? true : false;
        $param['order_total'] = $total_invoice_amount;

        $result['total_order_amount'] = ($param['order_total']+$param['order_tax']+$param['order_shipping_amount'])-($param['discount_amount']);


        $result['data'] = $param;

        $logo = $this->model_logo->get_logo();
        $result['logo'] = get_image($logo['logo_image'],$logo['logo_image_path']);
        $content = $this->load->view('_layout/email_template/email_template',$result,true);
        

        if($type == 'USER') {
            $send_to = $order_data['order_billing_email'];
            $send_from = $this->salesEmail;
        }
        else {
            $send_to = $this->salesEmail;
            $send_from = $this->salesEmail;
        }
        $send_to = 'jacobmikel85@gmail.com';
        $subject = 'Order Acknowledgement';

        // echo $send_to . "<br />";
        // echo $send_from . "<br />";
        // echo $subject . "<br />";
        // echo $content . "<br />";
        // die();
        parent::email($send_to , $send_from ,$subject, $content);
        
        return true;
    }



  
}
?>