<?
class Model_course_video extends MY_Model
{
    /**
     * TKD banner MODEL
     *
     * @package     banner Model
     * @version     1.0
     * @since       2017
     */

    protected $_table = 'course_video';
    protected $_field_prefix = 'course_video_';
    protected $_pk = 'course_video_id';
    protected $_status_field = 'course_video_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page = 20;

    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "course_video_id,course_video_course_id,course_video_title,course_video_status";

        parent::__construct();
    }


    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */
    public function get_fields($specific_field = "")
    {
        // Use when add new image
        $is_required_image = (($this->uri->segment(4)!=null) && intval($this->uri->segment(4)))?'':'required';

        $fields = array(

            'course_video_id' => array(
                'table' => $this->_table,
                'name' => 'course_video_id',
                'label' => 'id #',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => 'trim'
            ),


            'course_video_course_id' => array(
                   'table'   => $this->_table,
                   'name'   => 'course_video_course_id',
                   'label'   => 'Courses',
                   'type'   => 'dropdown',
                   'attributes'   => array(),
                   'js_rules'   => 'required',
                   'rules'   => 'required|trim',
                ),



            'course_video_subject' => array(
                'table' => $this->_table,
                'name' => 'course_video_subject',
                'label' => 'Subject',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),

            'course_video_title' => array(
                'table' => $this->_table,
                'name' => 'course_video_title',
                'label' => 'Title',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),


            'course_video_image' => array(
                'table' => $this->_table,
                'name' => 'course_video_image',
                'label' => 'Video',
                'name_path' => 'course_video_image_path',
                'upload_config' => 'site_upload_banner',
                'type' => 'fileupload',
                'type_dt' => 'image',
                'randomize' => true,
                'preview' => 'true',
                'attributes'   => array(
                    //'image_size_recommended'=>'1903px × 748px ',
                    'allow_ext'=>'mp4',
                    'is_video' => true,
                ),
                'dt_attributes' => array("width" => "10%"),
                'rules' => 'trim|htmlentities',
                'js_rules'=>" "
            ),


            
            'course_video_status' => array(
                'table' => $this->_table,
                'name' => 'course_video_status',
                'label' => 'Status?',
                'type' => 'dropdown',
                'type_dt' => 'dropdown',
                'type_filter_dt' => 'dropdown',
                'list_data' => array(),
                'default' => '1',
                'attributes' => array(),
                'dt_attributes' => array("width" => "7%"),
                'rules' => 'trim'
            ),

        );

        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;

    }

}

?>