<?
class Model_course_subject extends MY_Model {

	protected $_table    = 'course_subject';
    protected $_field_prefix    = 'course_subject_';
    protected $_pk    = 'course_subject_id';
    protected $_status_field    = 'course_subject_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page    = 20;
    
    function __construct()
    {
		// Call the Model constructor

       $this->pagination_params['fields'] = "course_subject_id,course_subject_course_id,course_subject_position, course_subject_name,course_subject_status";
       
       parent::__construct();
    }

    public function get_data_by_course_id($courseid)
    {
        $status_fld = $this->get_table_status_field();
        $param = array();
        $param['where'][$this->_field_prefix.'course_id'] = $courseid;
        //$param['joins'][] = $this->join_type();
        $param['where']["$status_fld !="] = 2 ;
        return $this->find_all($param);
    }

    public function get_parent_course_id($sub_id)
    {
        $param = array();
        $param['where']["course_subject_status !="] = 2 ;
        $z =  $this->find_by_pk($sub_id, $param);
        return $z->course_subject_course_id;
    }

    public function get_name($sub_id)
    {
        $param = array();
        $param['where']["course_subject_status !="] = 2 ;
        $z =  $this->find_by_pk($sub_id, $param);
        return $z->course_subject_name;
    }

    /*
    public function get_by_name($name = '')
    {
        $name = trim($name);
        $list = array();
        $data = $this->find_all_active();
        if(isset($data) AND array_filled($data)) {
            foreach($data as $value) {
                $list[$value['subject_name']] = $value['subject_id'];
            }
        }

        return empty($name) ? $list : $list[$name];
    }
    */
    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */

    public function get_fields($specific_field = "")
    {
        
        $fields[ 'course_subject_id' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'course_subject_id',
                    'label'   => 'ID',
                    'primary'   => 'primary',
                    'type'   => 'hidden',
                    'type_dt'   => 'text',
                    'attributes'   => array(),
                    'js_rules'   => '',
                    'rules'   => 'trim'
                );
        $fields[ 'course_subject_course_id' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'course_subject_course_id',
                    'label'   => 'Course #',
                    'type'   => 'dropdown',
                    //'list_data'    => $this->_list_data['course_subject_course_id'] ,
                    'attributes'   => array(),
                    'js_rules'   => 'required',
                    'rules'   => 'required|trim'
                );
                
        $fields[ 'course_subject_position' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'course_subject_position',
                    'label'   => 'Position',
                    'type'   => 'dropdown',
                    'attributes'   => array(),
                    'rules'   => 'trim'
                );

        $fields[ 'course_subject_name' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'course_subject_name',
                    'label'   => 'Name',
                    'type'   => 'text',
                    'default'   => '',
                    'attributes'   => array(),
                    'js_rules'   => 'required',
                    'rules'   => 'required|trim'
                );

        // $fields[ 'course_subject_credit' ] = array(
        //             'table'   => $this->_table,
        //             'name'   => 'course_subject_credit',
        //             'label'   => 'Credit Hours',
        //             'type'   => 'text',
        //             'default'   => '',
        //             'attributes'   => array(),
        //             'js_rules'   => '',
        //             'rules'   => 'trim'
        //         );

        $fields[ 'course_subject_status' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'course_subject_status',
                    'label'   => 'Status?',
                    'type'   => 'switch',
                    'default'   => '1',
                    'attributes'   => array(),
                    'rules'   => 'trim'
                );


        if($specific_field)
            return $fields[ $specific_field ];
        else
            return $fields;
    }
}
?>