<?
class Model_course_quiz extends MY_Model
{
    /**
     * @package     course_quiz Model
     * @version     1.0
     * @since       2018
     */

    protected $_table = 'course_quiz';
    protected $_field_prefix = 'cq_';
    protected $_pk = 'cq_id';
    protected $_status_field = 'cq_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page = 20;

    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "cq_id,cq_course_id,cq_question,cq_status";
        parent::__construct();
        
        // Load required models for category-based question selection
        $this->load->model('Model_quiz_category_config');
        $this->load->model('Model_quiz_categories');
        $this->load->model('Model_quiz_category_questions');
    }

    public function join_course($type="" , $append_joint ="" , $prepend_joint = "")
    {
        $joint = $prepend_joint . "cq_course_id = course_id " . $append_joint ; 
        return $this->prep_join("course" , $joint, $type );
    }

    public function join_subject($type="" , $append_joint ="" , $prepend_joint = "")
    {
        $joint = $prepend_joint . "cq_subject_id = course_subject_id " . $append_joint ; 
        return $this->prep_join("course_subject" , $joint, $type );
    }

    public function get_data($params=array(),$id=0)
    {
        $params['joins'][] = $this->join_subject();
        $params['joins'][] = $this->join_course();

        // JOIN with quiz_questions and question_bank to get the bank ID
        $params['joins'][] = array(
            'table' => 'quiz_questions',
            'joint' => 'quiz_questions.qq_quiz_id = course_quiz.cq_quiz_id AND quiz_questions.qq_question_id = course_quiz.cq_id',
            'type' => 'left'
        );
        $params['joins'][] = array(
            'table' => 'question_bank',
            'joint' => 'question_bank.qb_id = quiz_questions.qq_question_id',
            'type' => 'left'
        );

        // Select also the question bank ID
        if (empty($params['fields'])) {
            $params['fields'] = 'course_quiz.*, question_bank.qb_id as cq_question_bank_id';
        } else {
            $params['fields'] .= ', question_bank.qb_id as cq_question_bank_id';
        }

        if(!isset($params['where'][$this->_status_field]))
            $params['where_string'] = $this->_status_field . ' < 2';

        if($id){
            return $this->find_by_pk($id,false,$params);
        }
        else {
            return $this->find_all($params);
        }
    }

    public function get_data_active($params=array(),$id=0)
    {
        $params['where'][$this->_status_field] = STATUS_ACTIVE;

        return $this->get_data($params,$id);
    }


    public function check_answer($quiz_id,$answer_id)
    {
        $param = array();
        $data = $this->find_by_pk($quiz_id);

        //return $data;
        if($data['cq_type'] == 2){
            $answer_id = array(3,4,5,7,2,4);
            $answer_id = array_unique($answer_id);
            $answer_ids = implode(",",$answer_id);
            if($data['cq_correct_answer'] == $answer_ids)
                return $data;
            else
                return false;
        }
        else if($data['cq_type'] == 4){
            $data['cq_gain_point'] = 0;
            return $data;
        }
        else{
            if($data['cq_correct_answer'] == $answer_id)
                return $data;
            else
                return false;
        }
    }

    //public function generate_quiz($course_id)
    public function generate_quiz($quiz_id)
    {
        // Always load the category configuration model
        $this->load->model('Model_quiz_category_config');

        $combined_questions    = array();
        $question_ids_index    = array(); // Avoid duplicates if the same question is in both origins

        /* --------------------------------------------------
         * 1. Questions assigned manually to the quiz
         * --------------------------------------------------*/
        $param                  = array();
        $param['where']         = array('cq_quiz_id' => $quiz_id);
        $param['order']         = 'RAND()';
        $manual_questions       = $this->find_all_active($param);

        if (!empty($manual_questions)) {
            foreach ($manual_questions as $mq) {
                $combined_questions[] = $mq;
                // Normalize to get the question ID regardless of the format
                $tmp = (array) $mq;
                $qid = isset($tmp['cq_question_id']) ? $tmp['cq_question_id'] : (isset($tmp['qb_id']) ? $tmp['qb_id'] : null);
                if ($qid) {
                    $question_ids_index[$qid] = true;
                }
            }
        }

        /* --------------------------------------------------
         * 2. Questions from configured categories
         * --------------------------------------------------*/
        $category_questions = $this->Model_quiz_category_config->generate_quiz_questions($quiz_id);
        if (!empty($category_questions)) {
            foreach ($category_questions as $cq) {
                $qid = isset($cq['qb_id']) ? $cq['qb_id'] : (isset($cq['cq_question_id']) ? $cq['cq_question_id'] : null);
                if ($qid && isset($question_ids_index[$qid])) {
                    // Already included as manual; skip to avoid duplicate
                    continue;
                }
                $combined_questions[] = $cq;
            }
        }

        /* --------------------------------------------------
         * 3. Fallback: if no questions in any origin returns previous output
         * --------------------------------------------------*/
        if (empty($combined_questions)) {
            // Returns the manual questions (possible empty array) to maintain previous contract
            return $manual_questions;
        }

        return $combined_questions;
    }

    // GET FROM SESSION
    public function get_quiz_detail($data=array())
    {
        $params = array();
        $params['joins'][] = $this->join_subject();

        $result = array();
        if(array_filled($data))
        {
            foreach($data as $quiz_id=>$value) {
                $result[$quiz_id] = $this->find_by_pk_active($quiz_id,false,$params);
                $result[$quiz_id]['user_answer'] = $value['user_answer'];
                $result[$quiz_id]['is_correct_answer'] = $value['is_correct_answer'];
                $result[$quiz_id]['points'] = $value['points'];
            }
        }
        return $result;
    }


    public function question_type($index=0){
        $data = array(
            1=>'MCQ\'s(One choice Answer)',
            2=>'MCQ\'s(Multiple Answer)',
            3=>'True/False',
            4=>'Short Answer',
            // 5=>'Quiz Bank',
        );

        return isset($data[$index]) ? $data[$index] : $data;
    }

    // Get quiz questions with their question bank
    public function get_quiz_questions_with_bank($quiz_id) {
        $this->db->select('qq.*, qb.*, qb.qb_id as cq_question_bank_id');
        $this->db->from('quiz_questions qq');
        $this->db->join('question_bank qb', 'qb.qb_id = qq.qq_question_id', 'left');
        $this->db->where('qq.qq_quiz_id', $quiz_id);
        return $this->db->get()->result_array();
    }

    // GET FROM DATABASE
    public function get_quiz_detail2($data=array())
    {
        $params = array();
        $params['joins'][] = $this->join_subject();

        $result = array();
        if(array_filled($data))
        {
            foreach($data as $quiz_id=>$value) {
                $result[$quiz_id] = $this->find_by_pk_active($quiz_id,false,$params);
                $result[$quiz_id]['user_answer'] = $value['rq_answer'];
                $result[$quiz_id]['is_correct_answer'] = $value['rq_is_correct_asnwer'];
                $result[$quiz_id]['points'] = $value['rq_points'];
            }
        }
        return $result;
    }


    public function get_data_by_user_id($userid)
    {
        $param = array();
        $param['where']['cq_course_id'] = $userid;
        //$param['joins'][] = $this->join_category();
        return $this->find_all($param);
    }

    public function get_data_by_quiz_id($quiz_id)
    {
        $param = array();
        $param['where']['cq_quiz_id'] = $quiz_id;
        return $this->find_all($param);
    }
    
    /*
    public function get_result($result,$course_id=0)
    {
        $var  = '';

        if($course_id == 3) {
            if(($result >= 32) AND ($result < 40)){
                $var  = '
                <p>Your wellbeing score is below average. Most people have a score between 41 and 59. Why not take action to improve your mental wellbeing?</p>
                <p>There are five evidence-based steps we can all take to improve our mental wellbeing. They are:</p>
                <ul class="membership-ul">
                    <li>Get active</li>
                    <li>Connect with others</li>
                    <li>Keep learning</li>
                    <li>Be aware of yourself and the world</li>
                </ul>
                <h4>For expert help to increase your score you can:</h4>
                <ol class="membership-ul-num">
                    <li>Enrol on a health coaching programme. Click here for free consultation</li>
                    <li>Learn more about the five ways to well-being via Ruben’s book or Ebook</li>
                    <li>Purchase the five and a half ways to well –being online course</li>
                </ol>
                ';
            }
            else if(($result >= 40) AND ($result < 59)){
                $var  = '
                <p>Your wellbeing score is average. Most people have a score between 41 and 59. You can still improve your mental wellbeing by taking action.There are five evidence-based steps we can all take to improve our mental wellbeing. They are:</p>
                <ul class="membership-ul">
                   <li>Get active</li>
                    <li>Connect with others</li>
                    <li>Keep learning</li>
                    <li>Be aware of yourself and the world</li>
                    <li>Give to others</li>
                </ul>
                <h4>For expert help to increase your score you can:</h4>
                <ol class="membership-ul-num">
                    <li>Enrol on a health coaching programme. Click here for free consultation</li>
                    <li>Learn more about the five ways to well-being via Ruben’s book or Ebook</li>
                    <li>Purchase the five and a half ways to well –being online course</li>
                </ol>
                ';
            }
            else if(($result >= 59) AND ($result < 70)){
                $var  = '
                <p>Good news, you   have awesome energy levels and your energy  score is above average. Most people have a score between 41 and 59. Continue doing the things that are currently doing. To keep functioning at an optimal energy  level, you may consider the following suggestions:</p>
                <p>There are seven tried and tested steps we can all take to improve our energy levels. They are:</p>
                <ul class="membership-ul">
                    <li>Exercise</li>
                    <li>Connect with others</li>
                    <li>Get enough sleep to recharge your batteries</li>
                    <li>Be aware of yourself and the world</li>
                    <li>Make healthy food choices and eat predominantly a whole foods plant based diet</li>
                    <li>Do  deep breathing exercises</li>
                    <li>Hydrate with water</li>
                </ul>
                <h4>For expert help to increase your score you can:</h4>
                <ol class="membership-ul-num">
                    <li>Enroll on a health coaching programme. Click here for free consultation</li>
                    <li>Learn more about the via Ruben’s book  71/2 Secrets to Optimal health and Boundless Energy  Ebook</li>
                    <li>Purchase the  71/2 Secrets to Optimal health and Boundless Energy to well –being online course</li>
                </ol>
                ';
            }
            else {
                $var  = '
                <p>Good news, your wellbeing score is above average. Most people have a score between 41 and 59. Continue doing the things that are keeping you happy. To keep functioning at an optimal well being level, you may consider the following suggestions:</p>
                    <ul class="membership-ul">
                        <li>Enrol on a health coaching programme. Click here for free consultation</li>
                        <li>Learn more about the five ways to well-being via Ruben’s book or Ebook</li>
                        <li>Purchase the five and a half ways to well –being online course</li>
                    </ul>
                ';
            }
        }

        // In
        // else if($course_id == 2) {
        // }
        else {
            if(($result >= 32) AND ($result < 40)){
                $var  = '
                <p>Your energy score is below average. Most people have a score between 41 and 59. Why not take action to improve your energy levels? There are seven tried and tested steps we can all take to improve our energy levels. They are:</p>
                <ul class="membership-ul">
                    <li>Exercise</li>
                    <li>Connect with others</li>
                    <li>
                        Get enough sleep to recharge your batteries
                        <ol class="membership-ul-num" style="margin-left: 3%;">
                            <li>Be aware of yourself and the world</li>
                            <li>Make healthy food choices and eat predominantly a whole foods plant based diet</li>
                            <li>Do  deep breathing exercises</li>
                            <li>Hydrate with water</li>
                        </ol>
                    </li>
                </ul>
                <h4>For expert help to increase your score you can:</h4>
                <ol class="membership-ul-num">
                
                    <li>Enrol on a health coaching programme. Click here for free consultation</li>
                    <li>Learn more about the via Ruben’s book  71/2 Secrets to Optimal health and Boundless Energy  Ebook</li>
                    <li>Purchase the  71/2 Secrets to Optimal health and Boundless Energy to well –being online course</li>
                </ol>
                ';
            }
            else if(($result >= 40) AND ($result < 59)){
                $var  = '
                <p>Your energy score is average. Most people have a score between 41 and 59. You can still improve your energy score by taking action. There are seven tried and tested steps we can all take to improve our energy levels. They are:</p>
                <ul class="membership-ul">
                    <li>Exercise</li>
                    <li>Connect with others</li>
                    <li>
                        Get enough sleep to recharge your batteries
                        <ol class="membership-ul-num" style="margin-left: 3%;">
                            <li>Be aware of yourself and the world</li>
                            <li>Make healthy food choices and eat predominantly a whole foods plant based diet</li>
                            <li>Do  deep breathing exercises</li>
                            <li>Hydrate with water</li>
                        </ol>
                    </li>
                </ul>
                <h4>For expert help to increase your score you can:</h4>
                <ol class="membership-ul-num">
                
                    <li>Enrol on a health coaching programme. Click here for free consultation</li>
                    <li>Learn more about the via Ruben’s book  71/2 Secrets to Optimal health and Boundless Energy  Ebook</li>
                    <li>Purchase the  71/2 Secrets to Optimal health and Boundless Energy to well –being online course</li>
                </ol>
                ';
            }
            else if(($result >= 59) AND ($result < 70)){
                $var  = '
                <p>Good news, you   have awesome energy levels and your energy  score is above average. Most people have a score between 41 and 59. Continue doing the things that are currently doing. To keep functioning at an optimal energy  level, you may consider the following suggestions:</p>
                <p>There are seven tried and tested steps we can all take to improve our energy levels. They are:</p>
                <ul class="membership-ul">
                    <li>Exercise</li>
                    <li>Connect with others</li>
                    <li>Get enough sleep to recharge your batteries</li>
                    <li>Be aware of yourself and the world</li>
                    <li>Make healthy food choices and eat predominantly a whole foods plant based diet</li>
                    <li>Do  deep breathing exercises</li>
                    <li>Hydrate with water</li>
                </ul>
                <h4>For expert help to increase your score you can:</h4>
                <ol class="membership-ul-num">
                    <li>Enroll on a health coaching programme. Click here for free consultation</li>
                    <li>Learn more about the via Ruben’s book  71/2 Secrets to Optimal health and Boundless Energy  Ebook</li>
                    <li>Purchase the  71/2 Secrets to Optimal health and Boundless Energy to well –being online course</li>
                </ol>
                ';
            }
            else {
                $var  = '
                <p>Your energy score is very low. Most people have a score between 41 and 59. You may want to begin by talking to a friend or health professional about how you can start to address this. There are seven tried and tested steps we can all take to improve our energy levels. They are:</p>
                    <ul class="membership-ul">
                        <li>Exercise</li>
                        <li>Connect with others</li>
                        <li>
                            Get enough sleep to recharge your batteries
                            <ol class="membership-ul-num" style="margin-left: 3%;">
                                <li>Be aware of yourself and the world</li>
                                <li>Make healthy food choices and eat predominantly a whole foods plant based diet</li>
                                <li>Do  deep breathing exercises</li>
                                <li>Hydrate with water</li>
                            </ol>
                        </li>
                    </ul>
                    <h4>For expert help to increase your score you can:</h4>
                    <ol class="membership-ul-num">
                        <li>Enrol on a health coaching programme. Click here for free consultation</li>
                        <li>Learn more about the via Ruben’s book  71/2 Secrets to Optimal health and Boundless Energy  Ebook</li>
                        <li>Purchase the  71/2 Secrets to Optimal health and Boundless Energy to well –being online course</li>
                    </ol>
                ';
            }
        }// ELSE


        return $var;
    }
    */

    
    
    
    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */
    public function get_fields($specific_field = "")
    {
        // Use when edit
        $is_required_image = (($this->uri->segment(4)!=null) && intval($this->uri->segment(4)))?'':'required';

        $fields = array(

            'cq_id' => array(
                'table' => $this->_table,
                'name' => 'cq_id',
                'label' => 'id #',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => 'trim'
            ),

            'cq_type' => array(
                'table' => $this->_table,
                'name' => 'cq_type',
                'label' => 'Type #',
                'type' => 'dropdown',
                'list_data'    => $this->question_type(),
                'attributes'   => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),

            'cq_quiz_id' => array(
                'table' => $this->_table,
                'name' => 'cq_quiz_id',
                'label' => 'Quiz #',
                'type' => 'dropdown',
                //'list_data'    => $this->question_type(),
                'attributes'   => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),

            'cq_course_id' => array(
                'table' => $this->_table,
                'name' => 'cq_course_id',
                'label' => 'Course # ',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => 'trim'
            ),

            'cq_subject_id' => array(
                'table' => $this->_table,
                'name' => 'cq_subject_id',
                'label' => 'Subject # ',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => 'trim'
            ),

            /*
            'cq_course_id' => array(
                'table' => $this->_table,
                'name' => 'cq_course_id',
                'label' => 'Course #',
                'type' => 'dropdown',
                'attributes'   => array(
                    "class"=>"ajax-populate",
                    "additional" => 'data-target="course_quiz-cq_subject_id"'
                ),
                // 'list_data'    => array(
                //         "1"=>"Measure Your Energy Levels",
                //         "2"=>"Dosha Quiz",
                //         "3"=>"Measure Your Well-Being",) ,
                //'attributes'   => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),

            'cq_subject_id' => array(
                   'table'   => $this->_table,
                   'name'   => 'cq_subject_id',
                   'label'   => 'Subject',
                   'type'   => 'dropdown',
                   'type_dt'   => 'dropdown',
                   'type_filter_dt'   => 'dropdown',
                   'attributes'   => array("class"=>"ajax-populate",
                                           "additional" => ' 
                                                data-populate-uri="get_list"
                                                data-uri="course_quiz"
                                                data-dd_key="course_subject_id"
                                                data-dd_value="course_subject_name"'
                                      ),
                   'js_rules'   => 'required',
                   'rules'   => 'required|trim'
                ),
            */
            // 'cq_subject_id' => array(
            //     'table' => $this->_table,
            //     'name' => 'cq_subject_id',
            //     'label' => 'Subject',
            //     'type' => 'dropdown',
            //     'attributes' => array(),
            //     'js_rules' => '',
            //     'rules' => 'required|trim|htmlentities'
            // ),


            'cq_question' => array(
                'table' => $this->_table,
                'name' => 'cq_question',
                'label' => 'Question',
                'type' => 'textarea',
                'attributes'   => array("class"=>"summernote_textarea"),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),
          
            'cq_option_1' => array(
                'table' => $this->_table,
                'name' => 'cq_option_1',
                'label' => 'Option # 1',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),
            'cq_option_2' => array(
                'table' => $this->_table,
                'name' => 'cq_option_2',
                'label' => 'Option # 2',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),
            'cq_option_3' => array(
                'table' => $this->_table,
                'name' => 'cq_option_3',
                'label' => 'Option # 3 ',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),
            'cq_option_4' => array(
                'table' => $this->_table,
                'name' => 'cq_option_4',
                'label' => 'Option # 4 ',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            'cq_option_5' => array(
                'table' => $this->_table,
                'name' => 'cq_option_5',
                'label' => 'Option # 5 ',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),
            
             'cq_option_6' => array(
                'table' => $this->_table,
                'name' => 'cq_option_6',
                'label' => 'Option # 6 ',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            'cq_correct_answer' => array(
                'table' => $this->_table,
                'name' => 'cq_correct_answer',
                'label' => 'Answer',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),

            'cq_gain_point' => array(
                'table' => $this->_table,
                'name' => 'cq_gain_point',
                'label' => 'Gain Point',
                'type' => 'number',
                'attributes' => array('additional'=>'min="1" max="100" step="0.1"'),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),

            'cq_is_bonus' => array(
                'table' => $this->_table,
                'name' => 'cq_is_bonus',
                'label' => 'Bonus Question?',
                'type' => 'switch',
                'type_dt' => 'switch',
                'type_filter_dt' => 'dropdown',
                'list_data' => array(),
                'default' => '0',
                'attributes' => array(),
                'dt_attributes' => array("width" => "7%"),
                'rules' => 'trim'
            ),

            'cq_bonus_points' => array(
                'table' => $this->_table,
                'name' => 'cq_bonus_points',
                'label' => 'Bonus Points',
                'type' => 'number',
                'attributes' => array('additional'=>'min="0" max="100" step="0.1"'),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            'cq_status' => array(
                'table' => $this->_table,
                'name' => 'cq_status',
                'label' => 'Status?',
                'type' => 'switch',
                'type_dt' => 'switch',
                'type_filter_dt' => 'dropdown',
                'list_data' => array(),
                'default' => '1',
                'attributes' => array(),
                'dt_attributes' => array("width" => "7%"),
                'rules' => 'trim'
            ),
        );

        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;

    }

    /**
     * Gets the question banks (bank questions) associated with a quiz
     * @param int $quiz_id ID of the quiz
     * @return array Question banks associated with the quiz
     */
    public function get_question_banks_by_quiz($quiz_id) {
        $this->db->select('qb.*');
        $this->db->from('quiz_questions qq');
        $this->db->join('question_bank qb', 'qb.qb_id = qq.qq_question_id', 'left');
        $this->db->where('qq.qq_quiz_id', $quiz_id);
        $this->db->group_by('qb.qb_id');
        return $this->db->get()->result_array();
    }

    /**
     * Delete a question from a quiz by both quiz_id and question_id
     * @param int $quiz_id
     * @param int $question_id
     * @return bool
     */
    public function delete_by_quiz_and_question($quiz_id, $question_id)
    {
        if (empty($quiz_id) || empty($question_id)) {
            return false;
        }
        $this->db->where('cq_quiz_id', $quiz_id);
        $this->db->where('cq_id', $question_id);
        return $this->db->delete($this->_table);
    }

}

?>