<?
class Model_course extends MY_Model {

    protected $_table    = 'course';
    protected $_field_prefix    = 'course_';
    protected $_pk    = 'course_id';
    protected $_status_field    = 'course_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page    = 20;
    
    function __construct()
    {
        // Call the Model constructor

       $this->pagination_params['fields'] = "course_id, course_category_id, course_title, CONCAT('$ ',course_price) as course_price,  CONCAT(course_image_path,course_image) as course_image, course_is_featured, course_status";

       // $this->relations['course_subject'] = array(
       //                              "type"=>"has_many", 
       //                              "own_key"=>"cs_course_id", 
       //                              "other_key"=>"cs_subject_id",
       //                             );
       
       parent::__construct();
    }




    // GO TO PARENT CONTROLLER
    public function get_avg($correct,$attempted)
    {
        return number_format(($correct/$attempted)*100 , 2);
    }

    public function get_result($avg)
    {
        return ($avg >= PASSING_AVG) ? "PASS" : 'FAIL';
    }
    

    public function join_category($type="" , $append_joint ="" , $prepend_joint = "")
    {
        //$joint = $prepend_joint . "product_parent_category_id = category_id" . $append_joint ; 
        $joint = $prepend_joint . "course_category_id = category_id" . $append_joint ; 
        return $this->prep_join("category" , $joint, $type );
    }

    public function join_user($type="" , $append_joint ="" , $prepend_joint = "")
    {
        $joint = $prepend_joint . "course_user_id = user_id" . $append_joint ; 
        return $this->prep_join("user" , $joint, $type );
        return true;
    }
   

    public function get_products($params=array() , $list = false)
    {

        $params['fields'] = '*';
        
        $params['joins'][] = $this->join_category();
        $params['joins'][] = $this->join_user();
        ///$params['joins'][] = $this->join_user("INNER"," AND user_connected_status = 1");

        if($list)
            $data = $this->find_all_list_active($params , "course_name");
        else
            $data = $this->find_all_active($params);

        return $data; 
    }

    // WHen individual Product Call
    public function get_details($params = array())
    {

        $params['joins'][] = $this->join_category();
        //$params['joins'][] = $this->join_user("INNER"," AND user_connected_status = 1");
        $params['joins'][] = $this->join_user();
        $product = $this->find_one_active($params);
        

        if($product)
        {
            // $prdimg_params = array();
            // $prdimg_params['where']['pi_product_id'] = $product['product_id'] ;
            // $prdimg_params['order'] = 'pi_is_featured DESC';
            // $product['pi_images'] = $this->model_product_image->find_all($prdimg_params);

            // Get Addons
            //$product['addons'] = $this->model_product_addon->get_product_addons($product['product_id']);

            // Get Attributes
            //$product['attributes'] = $this->model_product_attribute->get_product_attributes($product['product_id']);

        }
        return $product;
    }

    public function get_details_by_slug($slug = '')
    {
        // Return product by slug
        $slug = trim($slug);
        if(!$slug)
            return false;
        $params['where']['course_slug'] = $slug;

        return $this->get_details($params);

    }


    // Pagination Start
    private function _pagination_filter($param = array())
    {
        //  Filters Start
        if(isset($_GET['category_id']) AND intval($_GET['category_id']) > 0){
            $param['where']['course_category_id'] = $this->input->get('category_id');
        }


        if(isset($_GET['user_id']) AND intval($_GET['user_id']) > 0){
            $param['where']['course_user_id'] = $this->input->get('user_id');
        }

        if(isset($_GET['search']) AND (!empty($_GET['search']))){
            $search = trim($_GET['search']);
            $param['where_like'][] = array('column'=>'course_title','value'=>$search,'type'=>'both');
        }


        if(isset($_GET['sorting']) AND (!empty($_GET['sorting']))){
            switch ($_GET['sorting']) {
                case 'by_price_ASC':
                    $param['order'] = "course_price ASC";
                    break;
                case 'by_price_DESC':
                    $param['order'] = "course_price DESC";
                    break;
                
                default:
                    $param['order'] = "course_id ASC";
                    break;
            }
        }
        else{
            $param['order'] = "course_id DESC";
        }

        
        //  Filters End
        // if(isset($_GET['price']))
        // {
        //     $price = explode(";", $_GET['price']);
        //     $min = $price[0];
        //     $max = $price[1];

        //     $param['where_string'] = "product_price >= $min AND product_price <= $max";
        // }

        return $param;
    }
    

    public function get_pagination_total_count($paginate_param)
    {
        $param = array();
        $param = $this->_pagination_filter($paginate_param);
        //$data = $this->find_count_active($param);
        $data = count($this->get_products($param));
        return $data;
    }

    public function get_pagination_data($limit = '', $offset = '',$paginate_param)
    {
        $param = array();
        //$param['order'] = 'product_id DESC';
        $param['limit'] = $limit;

        //  Filters Start
        $param = $this->_pagination_filter($paginate_param);
        
        $param['limit'] = $limit;
        $param['offset'] = $offset;
        return $this->get_products($param);
    }
    // Pagination END


    public function get_related_products($category_id,$course_id)
    {
        $params = array();
        $params['where']['course_id !='] = $course_id ;
        $params['where']['course_category_id'] = $category_id ;
        $params['order'] = "course_id DESC";
        $params['limit'] = 1;
        $data = $this->get_products($params);
        return $data;
    }


    public function get_data_by_user_id($userid)
    {
        $status_fld = $this->get_table_status_field();
        $param = array();
        $param['where']['course_user_id'] = $userid;
        $param['order'] = 'course_id DESC';
        $param['where']["$status_fld !="] = 2 ;
        return $this->find_all($param);
    }


    /*
    public function join_type($type="" , $append_joint ="" , $prepend_joint = "")
    {
        $joint = $prepend_joint . "course_type_id = subject_id " . $append_joint ; 
        return $this->prep_join("subject" , $joint, $type );
    }

    public function get_by_pk($id,$param=array())
    {
        $param['joins'][0] = $this->join_type();
        $param['where'][$this->_status_field] = 1;
        return $this->find_by_pk($id,false,$param);
    }

    public function get_featured_courses($limit=12)
    {
        $param = array();
        $param['where']['course_is_featured'] = 1;
        $param['limit'] = $limit;
        return $this->find_all_active($param);
    }

    
    

    // GET Home Page Carousel Data
    public function get_data()
    {
        $result = array();
        $data = $this->model_type->find_all_list_active(
                        array(
                            'where'=> array('type_is_featured' => 1),
                            'limit' => 4
                        ),'type_name');
        if(isset($data) AND array_filled($data))
        {
            foreach($data as $id=>$name)
            {
                $result[$id]['name'] = $name;
                $result[$id]['courses'] = $this->find_all_active(
                    array(
                        'fields'=>'course_id,course_name',
                        'where'=>array(
                            'course_type_id'=>$id,
                            'course_is_featured'=>1,
                        ),
                        'order'=>'RAND()',
                        'limit'=>5,
                    )
                );
            }
        }
        return $result;
    }

    // GET Tests Page Data
    public function get_data_tests()
    {
        $result = array();
        $data = $this->model_type->find_all_active();
        if(isset($data) AND array_filled($data))
        {
            foreach($data as $key=>$value)
            {
                $param = array();
                $param['fields'] = 'course_id,course_name';
                $param['where']['course_type_id'] = $value['type_id'];

                if(isset($_GET['search'])) {
                    $search = trim($_GET['search']);
                    $param['where_like'][] = array('column'=>'course_name','value'=>$search);
                }

                $result[$value['type_id']] = $value;
                $result[$value['type_id']]['courses'] = $this->find_all_active($param);
            }
        }
        return $result;
    }



    
    */

    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */

    public function get_fields($specific_field = "")
    {
        
        $fields[ 'course_id' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'course_id',
                    'label'   => 'ID',
                    'primary'   => 'primary',
                    'type'   => 'hidden',
                    'type_dt'   => 'text',
                    'attributes'   => array(),
                    'js_rules'   => '',
                    'rules'   => 'trim'
                );

        $fields[ 'course_user_id' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'course_user_id',
                    'label'   => 'User ID',
                    'type'   => 'hidden',
                    'attributes'   => array(),
                    'js_rules'   => '',
                    'rules'   => 'trim'
                );

        $fields[ 'course_category_id' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'course_category_id',
                    'label'   => 'Category #',
                    'type'   => 'dropdown',
                    'attributes'   => array(),
                    'js_rules'   => 'required',
                    'rules'   => 'required|trim'
                );

        

        // $fields[ 'course_user_id' ] = array(
        //             'table'   => $this->_table,
        //             'name'   => 'course_user_id',
        //             'label'   => 'Teacher',
        //             'type'   => 'dropdown',
        //             'attributes'   => array(),
        //             'js_rules'   => 'required',
        //             'rules'   => 'required|trim'
        //         );


        $fields[ 'course_title' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'course_title',
                    'label'   => 'Course Title',
                    'type'   => 'text',
                    'default'   => '',
                    'attributes'   => array("additional"=>'slugify="#'.$this->_table.'-'.$this->_field_prefix.'slug"'),
                    'js_rules'   => 'required',
                    'rules'   => 'required|trim'
                );

        $fields[ 'course_slug' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'course_slug',
                    'label'   => 'Slug',
                    'type'   => 'text',
                    'default'   => '',
                    'attributes'   => array(),
                    'js_rules'   => array("is_slug" => array() ),
                    'rules'   => 'required|htmlentities|is_unique['.$this->_table.'.'.$this->_field_prefix.'slug]|callback_is_slug'
                );

        // $fields[ 'course_name' ] = array(
        //             'table'   => $this->_table,
        //             'name'   => 'course_name',
        //             'label'   => 'Name',
        //             'type'   => 'text',
        //             'default'   => '',
        //             'attributes'   => array(),
        //             'js_rules'   => 'required',
        //             'rules'   => 'required|trim'
        //         );
        $fields[ 'course_price' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'course_price',
                    'label'   => 'Price',
                    'type'   => 'text',
                    'default'   => '',
                    'attributes'   => array(),
                    'js_rules'   => 'required',
                    'rules'   => 'required|trim|htmlentities|greater_than[0]'
                );
        $fields[ 'course_description' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'course_description',
                    'label'   => 'Description',
                    'type'   => 'editor',
                    'default'   => '',
                    'attributes'   => array(),
                    'js_rules'   => 'required',
                    'rules'   => 'required|trim'
                );
        $fields[ 'course_short_description' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'course_short_description',
                    'label'   => 'Curriculum',
                    'type'   => 'editor',
                    'default'   => '',
                    'attributes'   => array(),
                    'js_rules'   => 'required',
                    'rules'   => 'required|trim'
                );

        // $fields[ 'course_hours' ] = array(
        //             'table'   => $this->_table,
        //             'name'   => 'course_hours',
        //             'label'   => 'Total Hours',
        //             'type'   => 'text',
        //             'default'   => '',
        //             'attributes'   => array(),
        //             'js_rules'   => 'required',
        //             'rules'   => 'required|trim'
        //         );
        
        $fields[ 'course_type' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'course_type',
                    'label'   => 'Type',
                    'type'   => 'text',
                    'default'   => '',
                    'attributes'   => array(),
                    'js_rules'   => 'required',
                    'rules'   => 'required|trim'
                );
        
        // $fields[ 'course_total_enrolled' ] = array(
        //             'table'   => $this->_table,
        //             'name'   => 'course_total_enrolled',
        //             'label'   => 'Total Enrolled',
        //             'type'   => 'text',
        //             'default'   => '',
        //             'attributes'   => array(),
        //             'js_rules'   => 'required',
        //             'rules'   => 'required|trim'
        //         );
        $fields[ 'course_duration' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'course_duration',
                    'label'   => 'Duration',
                    'type'   => 'text',
                    'default'   => '',
                    'attributes'   => array(),
                    'js_rules'   => 'required',
                    'rules'   => 'required|trim'
                );
        
        // $fields[ 'course_package_detail' ] = array(
        //             'table'   => $this->_table,
        //             'name'   => 'course_package_detail',
        //             'label'   => 'Package Detail',
        //             'type'   => 'editor',
        //             'default'   => '',
        //             'attributes'   => array(),
        //             'js_rules'   => 'required',
        //             'rules'   => 'required|trim'
        //         );
        // $fields[ 'course_faqs' ] = array(
        //             'table'   => $this->_table,
        //             'name'   => 'course_faqs',
        //             'label'   => 'FAQ\'s',
        //             'type'   => 'editor',
        //             'default'   => '',
        //             'attributes'   => array(),
        //             'js_rules'   => 'required',
        //             'rules'   => 'required|trim'
        //         );
        //     $fields[ 'course_information' ] = array(
        //             'table'   => $this->_table,
        //             'name'   => 'course_information',
        //             'label'   => 'Course Information',
        //             'type'   => 'editor',
        //             'default'   => '',
        //             'attributes'   => array(),
        //             'js_rules'   => 'required',
        //             'rules'   => 'required|trim'
        //         );
        //     $fields[ 'course_regulatory_information' ] = array(
        //             'table'   => $this->_table,
        //             'name'   => 'course_regulatory_information',
        //             'label'   => 'Regulatory Information',
        //             'type'   => 'editor',
        //             'default'   => '',
        //             'attributes'   => array(),
        //             'js_rules'   => 'required',
        //             'rules'   => 'required|trim'
        //         );
        
            $fields[ 'course_image' ] = array(
                    'table' => $this->_table,
                    'name' => 'course_image',
                    'label' => 'Image',
                    'name_path' => 'course_image_path',
                    'upload_config' => 'site_upload_course',
                    'type' => 'fileupload',
                    'type_dt' => 'image',
                    'randomize' => true,
                    'preview' => 'true',
                    'attributes'   => array(
                        'image_size_recommended'=>'860px × 500px',
                        'allow_ext'=>'png|jpeg|jpg',
                    ),
                    'dt_attributes' => array("width" => "10%"),
                    'rules' => 'trim|htmlentities',
                    'js_rules'=>''
                );
                
                $fields[ 'course_professor' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'course_professor',
                    'label'   => 'Professor Name',
                    'type'   => 'text',
                    'rules'   => 'trim'
                );

            
                $fields[ 'course_professor_image' ] = array(
                    'table' => $this->_table,
                    'name' => 'course_professor_image',
                    'label' => 'Professor Image',
                    'name_path' => 'course_image_path',
                    'upload_config' => 'site_upload_course',
                    'type' => 'fileupload',
                    'type_dt' => 'image',
                    'randomize' => true,
                    'preview' => 'true',
                    'attributes'   => array(
                        'image_size_recommended'=>'860px × 500px',
                        'allow_ext'=>'png|jpeg|jpg',
                    ),
                    'dt_attributes' => array("width" => "10%"),
                    'rules' => 'trim|htmlentities'
                );

                
                


                
        //         $fields[ 'course_icon_label' ] = array(
        //             'table'   => $this->_table,
        //             'name'   => 'course_icon_label',
        //             'label'   => 'Course fasfa icon',
        //             'type'   => 'text',
        //             'default'   => '',
        //             'attributes'   => array(),
        //             'js_rules'   => '',
        //             'rules'   => 'trim'
        //         );

        $fields[ 'course_is_featured' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'course_is_featured',
                    'label'   => 'Is Featured?',
                    'type'   => 'dropdown',
                    'type_dt' => 'dropdown',
                    'default'   => '1',
                    'attributes'   => array(),
                    'rules'   => 'trim'
                );

        $fields[ 'course_status' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'course_status',
                    'label'   => 'Status?',
                    'type'   => 'dropdown',
                    'default'   => '1',
                    'attributes'   => array(),
                    'rules'   => 'trim'
                );

        

        if($specific_field)
            return $fields[ $specific_field ];
        else
            return $fields;
    }
}
?>