<?
class Model_country extends MY_Model {
	/**
     * TKD inquiry MODEL
     *
     * @package     Country Model
     * @author     	Abdul Ovais Khan (abdul.ovais@tradekey.com)
     * @version     2.0
     * @since       2014 
     */
	 
    protected $_table    = 'country';
    protected $_pk    = 'id';

    public $pagination_params = array();
    public $_per_page    = 20;

    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }
    
    public function get_country($id)
    {    
        $id = intval($id);
        if(!$id)
            return false;
            
        return $this->find_by_pk($id);
    }
    
    public function get_country_name($id)
    {    
        if($id == 0)
            return '';
        
        $country =  $this->get_country($id);
        return $country['country'] ;
    }
    
    public function get_country_list()
    {    
        return $this->find_all_list(array('order'=>'country ASC') , "country");
    }

    public function get_country_checkout()
    {
        $param = array();
        $param['order'] = 'country ASC';
        //$param['where']['id'] = 32;
        return $this->find_all($param , "country");    
    }

    public function get_code_by_pk($id)
    {
        $param['fields'] = 'sb_iso_code';
        $data = $this->find_by_pk($id,false,$param);
        return isset($data['sb_iso_code']) ? $data['sb_iso_code'] : '';
    }

    public function get_id_by_code($code)
    {
        $param['where']['sb_iso_code'] = $code;
        $data = $this->find_by_pk($id,false,$param);
        return isset($data['id']) ? $data['id'] : 223;
    }

    public function get_country_state()
    {
        return array(
            1=>'Alberta',
            2=>'British Columbia',
            3=>'Manitoba',
            4=>'New Brunswick',
            5=>'Newfoundland and Labrador',
            6=>'Northwest Territories',
            7=>'Nova Scotia',
            8=>'Nunavut',
            9=>'Ontario',
            10=>'Prince Edward Island',
            11=>'Quebec',
            12=>'Saskatchewan',
            13=>'Yukon',
            );
    }

}
?>