<?

class Model_cms_page extends MY_Model
{


    protected $_table = 'cms_page';
    protected $_field_prefix = 'cms_page_';
    protected $_pk = 'cms_page_id';
    protected $_status_field = 'cms_page_status';
    public $relations = array();
    public $pagination_params = array();
    public $dt_params = array();
    public $_per_page = 20;

    function __construct()
    {
        // $this->type = (intval($this->uri->segment(4)) == 2 ? 'editor' : 'hidden');
        // $this->file = (intval($this->uri->segment(4)) == 2 ? 'fileupload' : 'hidden');

        // Call the Model constructor
        if(isset($_GET['seo_module']) AND ($_GET['seo_module'] == 1)) {
          $this->pagination_params['fields'] = "cms_page_id,cms_page_name,cms_page_meta_title,cms_page_meta_keywords";
          $this->pagination_params['where_string'] = 'cms_page_page = 1';
        }
        else {
          $this->pagination_params['fields'] = "cms_page_id,cms_page_name,cms_page_page";

          $this->pagination_params['where_string'] = 'cms_page_page > 1';
        }

        parent::__construct();
    }

    public function get_seo_data($id)
    {
      $param = array();
      $param['fields'] = 'cms_page_meta_title as meta_title,cms_page_meta_keywords as meta_keywords,cms_page_meta_description as meta_description';
      return $this->find_by_pk($id,false,$param);
    }


    public function get_page($id)
    {
      $data = $this->find_by_pk($id);
      $data['child'] = $this->find_all_active(array('where'=>array('cms_page_page'=>$id)));

      return $data;
    }


    public function get_page_name_list()
    {
      $param = array();
      $param['where']['cms_page_page'] = 1;
      $param['where_string'] = 'cms_page_id != 27';
      return $this->find_all_list_active($param,'cms_page_name');
    }
    /*
    * table             Table Name
    * Name              FIeld Name
    * label             Field Label / Textual Representation in form and DT headings
    * type              Field type : hidden, text, textarea, editor, etc etc. 
    *                                 Implementation in form_generator.php
    * type_dt           Type used by prepare_datatables method in controller to prepare DT value
    *                                 If left blank, prepare_datatable Will opt to use 'type'
    * type_filter_dt    Used by DT FILTER PREPRATION IN datatables.php
    * attributes        HTML Field Attributes
    * js_rules          Rules to be aplied in JS (form validation)
    * rules             Server side Validation. Supports CI Native rules

    * list_data         For dropdown etc, data in key-value pair that will populate dropdown 
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    * list_data_key     For dropdown etc, if you want to define list_data in CONTROLLER (public _list_data[$key]) list_data_key is the $key which identifies it
    *                   -----Incase list_data_key is not defined, it will look for field_name as a $key
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    */
    public function get_fields($specific_field = "")
    {

        $fields['cms_page_id'] = array(
                   'table'   => $this->_table,
                   'name'   => 'cms_page_id',
                   'label'   => 'id #',
                   'type'   => 'hidden',
                   'type_dt'   => 'text',
                   'attributes'   => array(),
                   'dt_attributes'   => array("width"=>"5%"),
                   'js_rules'   => '',
                   'rules'   => 'trim'
              );

        $fields['cms_page_page'] = array(
                   'table'   => $this->_table,
                   'name'   => 'cms_page_page',
                   'label'   => 'Page / Location',
                   'type'   => 'dropdown',
                   'type_dt'   => 'dropdown',
                   'type_filter_dt'=>'dropdown',
                   'attributes'   => array('additional'=>'disabled="disabled"'),
                   'dt_attributes'   => array("width"=>"5%"),
                   'js_rules'   => '',
                   'rules'   => 'trim'
              );

        $fields['cms_page_name'] = array(
                   'table'   => $this->_table,
                   'name'   => 'cms_page_name',
                   'label'   => 'Name',
                   'type'   => 'label',
                   'type_dt'   => 'text',
                   'attributes'   => array(),
                   'dt_attributes'   => array("width"=>"5%"),
                   'js_rules'   => '',
                   'rules'   => 'trim|htmlentities'
              );

        $fields['cms_page_title'] = array(
                   'table'   => $this->_table,
                   'name'   => 'cms_page_title',
                   'label'   => 'Heading',
                   'type'   => 'text',
                   'attributes'   => array(),
                   'dt_attributes'   => array("width"=>"5%"),
                   'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
              );

        $fields['cms_page_content'] = array(
                   'table'   => $this->_table,
                   'name'   => 'cms_page_content',
                   'label'   => 'Description',
                   'type'   => 'editor',
                   'attributes'   => array(),
                   'dt_attributes'   => array(),
                   'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
              );
      
        $fields['cms_page_meta_title'] = array(
                   'table'   => $this->_table,
                   'name'   => 'cms_page_meta_title',
                   'label'   => 'Meta Title',
                   'type'   => 'text',
                   'attributes'   => array(),
                   'dt_attributes'   => array(),
                   'js_rules' => '',
                'rules' => 'trim|htmlentities'
              );
        $fields['cms_page_meta_keywords'] = array(
                   'table'   => $this->_table,
                   'name'   => 'cms_page_meta_keywords',
                   'label'   => 'Meta Keywords',
                   'type'   => 'textarea',
                   'attributes'   => array(),
                   'dt_attributes'   => array(),
                   'js_rules' => '',
                'rules' => 'trim|htmlentities'
              );
        $fields['cms_page_meta_description'] = array(
                   'table'   => $this->_table,
                   'name'   => 'cms_page_meta_description',
                   'label'   => 'Meta Description',
                   'type'   => 'textarea',
                   'attributes'   => array(),
                   'dt_attributes'   => array(),
                   'js_rules' => '',
                'rules' => 'trim|htmlentities'
              );
           


        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;
    }

}

?>