<?
class Model_chat_user extends MY_Model {
  
    /**
     * Model_user_topic MODEL
     *
     * @package     Model_user_topic Model
     * @author      Waqas Ahmed (waqasahmed.it@gmail.com)
     * @version     2.0
     * @since       2017 
     */

    protected $_table    = 'chat_user';
    protected $_field_prefix    = 'cu_';
    protected $_pk    = 'cu_id';
    protected $_status_field    = 'cu_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page    = 20;
    
    function __construct()
    {
        // Call the Model constructor
        //$this->pagination_params['fields'] = "pp_user_id,pp_page_id";

        $this->pagination_params['fields'] = "cu_id,user_firstname as user_fname,user_lastname as user_lname,cu_comments,cu_status";

        $this->pagination_params['joins'][] = array(
                                                    "table"=>"user" , 
                                                    "joint"=>"cu_friend_id = user_id", 
                                                );
        if(isset($_GET['id']) AND intval($_GET['id']) > 0)
            $this->pagination_params['where']['jm_chat_user.cu_user_id'] = $_GET['id'];
        
        $this->pagination_params['order'] = 'jm_chat_user.cu_friend_id ASC';

        parent::__construct();
    }

    public function get_other_advisor_list($user_id,$friend_id)
    {
        $param = array();
        $param['where']['cu_user_id'] = $user_id;
        $param['where_string'] = 'cu_friend_id != '.$friend_id;
        $data = $this->find_all($param);
        
        $var = array();
        if(isset($data) AND array_filled($data))
        {
            foreach($data as $key=>$value)
            {
                $da = $this->model_user->find_by_pk($value['cu_user_id']);
                if(isset($da) AND array_filled($da))
                {
                    $var[$key]['id'] = $value['cu_friend_id'];
                    $var[$key]['name'] = $da['user_firstname'] . " " . $da['user_lastname'];
                }
            }
        }
        return $var;
    }


    public function get_friend_list($user_id)
    {
        $param = array();
        $param['fields'] = 'user_id as id,user_firstname,user_lastname,ui_profile_image,ui_profile_image_path,user_type,user_is_online';
        $param['joins'][] = array(
                        "table"=>"user" , 
                        "joint"=>"chat_user.cu_friend_id = user.user_id", 
                    );
        $param['joins'][] = array(
                        "table"=>"user_info" , 
                        "joint"=>"chat_user.cu_friend_id = user_info.ui_user_id", 
                    );
        $param['where']['cu_user_id'] = $user_id;

        //$param['order'] = 'user_firstname ASC';
        $param['order'] = 'cu_createdon DESC,user_firstname ASC';
        //debug($param , 1);

        return $this->find_all_active($param);
    }


    public function check_already_friend($user_id , $friend_id)
    {
        $param = array();
        $param['where_string'] = "(cu_user_id = $user_id AND cu_friend_id = $friend_id) OR
                                    (cu_user_id = $friend_id AND cu_friend_id = $user_id)";

        $data = $this->find_one($param);
        
        return (isset($data) AND array_filled($data)) ? true : false;
    }

    public function find_one_friend($user_id,$friend_id)
    {
        $param = array();
        $param['fields'] = 'user_id as id,user_firstname,user_lastname,ui_description,ui_profile_image,ui_profile_image_path,user_is_online';
        $param['joins'][] = array(
                        "table"=>"user" , 
                        "joint"=>"chat_user.cu_friend_id = user.user_id", 
                    );
        $param['joins'][] = array(
                        "table"=>"user_info" , 
                        "joint"=>"chat_user.cu_friend_id = user_info.ui_user_id", 
                    );
        
        $param['where']['cu_friend_id'] = $user_id;
        $param['where']['cu_user_id'] = $friend_id;
        return $this->find_one_active($param);
    }


    public function get_chat_count_by_user($user_id){
        $params = array();
        $params['where_string'] = "( (cu_user_id=$user_id) OR (cu_friend_id=$user_id) )";
        return $this->find_count_active($params);
    }


    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */
    public function get_fields( $specific_field = "" )
    {

        $fields = array(
        
              'cu_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'cu_id',
                     'label'   => 'ID #',
                     'type'   => 'hidden',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),

              'user_fname' => array(
                     'table'   => $this->_table,
                     'name'   => 'user_fname',
                     'label'   => 'User First Name',
                     'type'   => 'none',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),
              'user_lname' => array(
                     'table'   => $this->_table,
                     'name'   => 'user_lname',
                     'label'   => 'User Last Name',
                     'type'   => 'none',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),



              'cu_user_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'cu_user_id',
                     'label'   => 'User',
                     'type'   => 'hidden',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),

              'cu_friend_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'cu_friend_id',
                     'label'   => 'Friend',
                     'type'   => 'hidden',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),

              'cu_comments' => array(
                     'table'   => $this->_table,
                     'name'   => 'cu_comments',
                     'label'   => 'Comments',
                     'type'   => 'textarea',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),
              
              'cu_status' => array(
                     'table'   => $this->_table,
                     'name'   => 'cu_status',
                     'label'   => 'Status?',
                     'type'   => 'switch',
                     'type_dt'   => 'switch',
                     'type_filter_dt'   => 'dropdown',
                     'list_data' => array() ,
                     'default'   => '1',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"7%"),
                     'rules'   => 'trim'
                  ),
/*
               'cu_is_private' => array(
                     'table'   => $this->_table,
                     'name'   => 'cu_is_private',
                     'label'   => 'Is Private?',
                     'type'   => 'switch',
                     'type_dt'   => 'switch',
                     'type_filter_dt'   => 'dropdown',
                     'list_data' => array() ,
                     'default'   => '1',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"7%"),
                     'rules'   => 'trim'
                  ),

*/
            );

        if($specific_field)
            return $fields[ $specific_field ];
        else
            return $fields;

    }

}
?>