<?
class Model_category extends MY_Model {
    /**
     *
     * @package     category Model
     * 
     * @version     1.0
     * @since       2017
     */

    protected $_table    = 'category';
    protected $_field_prefix    = 'category_';
    protected $_pk    = 'category_id';
    protected $_status_field    = 'category_status';
    public $relations = array();
    public $pagination_params = array();
    public $dt_params = array();
    public $_per_page    = 20;
    
    function __construct()
    {
        // Call the Model constructor

        if(isset($_GET['sub_cat']) AND (intval($_GET['sub_cat']) == 1)) {
            $this->pagination_params['fields'] = "category_id,category_parent_id,category_name,category_status";
            $this->pagination_params['where_string'] = 'category_parent_id > 1';
        }
        else {
            $this->pagination_params['fields'] = "category_id,category_name,category_status";
            $this->pagination_params['where_string'] = 'category_parent_id = 1';
        }

        parent::__construct();

    }


    // public function get_category_with_article_count($type_id)
    // {
    //     $category = $this->find_all_list_active(array('where_string'=>'category_parent_id = 1'),'category_name');
    //     $result = array();
    //     if(isset($category) AND array_filled($category)) {
    //         foreach($category as $category_id=>$category_name) {
    //             $result[$category_id]['category_name'] = $category_name;
    //             $param = array();
    //             $param['where']['a_type_id'] = $type_id;
    //             $param['where']['a_category_id'] = $category_id;
    //             $param['joins'][] = $this->model_article->join_category();
    //             $param['joins'][] = $this->model_article->join_user();
    //             $result[$category_id]['count'] =  $this->model_article->find_count_active($param);
    //         }
    //     }
    //     return $result;
    // }

    // public function get_instant_collections()
    // {
    //     $category = $this->find_all_list_active(array('where_string'=>'category_parent_id = 1'),'category_name');
    //     $result = array();
    //     if(isset($category) AND array_filled($category)) {
    //         foreach($category as $category_id=>$category_name) {
    //             $param = array();
    //             $param['where']['a_type_id'] = ARTICLE;
    //             $param['where']['a_category_id'] = $category_id;
    //             $param['joins'][] = $this->model_article->join_category();
    //             $param['joins'][] = $this->model_article->join_user();
    //             $param['order'] = 'a_id DESC';
    //             $param['limit'] = 4;
    //             $data = $this->model_article->find_all_active($param);

    //             if(isset($data) AND array_filled($data)){
    //                 $result[$category_id]['category_name'] = $category_name;
    //                 $result[$category_id]['data'] =  $data;
    //             }
    //         }
    //     }
    //     return $result;
    // }

    public function get_main_categories($params=array())
    {
        // Set params
        $params['fields'] = "category_id,category_name,category_slug,category_image,category_image_thumb,category_image_path";
        $params['order'] = "category_name ASC";//"RAND()";
        $params['where']['category_parent_id'] = 1;
        return $this->model_category->find_all_active($params);
    }

    public function get_sub_categories($params=array())
    {
        // Set params
        $params['fields'] = "category_id,category_parent_id,category_name,category_slug,category_image,category_image_thumb,category_image_path";
        $params['order'] = "RAND()";
        $params['where']['category_parent_id >'] = 1;
        return $this->model_category->find_all_active($params);
    }


    public function get_data_by_slug($slug)
    {
        $param = array();
        $param['where']['category_slug'] = $slug;
        return $this->find_one_active($param);
    }


    public function get_subcat_ids_by_main_id($main_id)
    {
        $ids = array();

        $param = array();
        $param['where']['category_parent_id'] = $main_id;
        $d = $this->find_all_active($param);
        if(isset($d) AND array_filled($d)) {
            foreach($d as $value) {
                $ids[$value['category_id']] = $value['category_id'];
            }
        }
        else {
            $ids = array(0=>0);
        }
        return $ids;
    }

    /*
    // Get all Categories start (non featured)
    public function get_categories()
    {
        // Set params
        $params['fields'] = "category_id,category_name,category_slug,category_image,category_image_thumb,category_image_path";
        // Query to get all categories
        $params['order'] = "category_name ASC";
        // Result
        $result = $this->model_category->find_all_active($params);
        return $result;
    }
    // Get all Categories end

    public function get_product_menu()
    {
        $param = array();
        $param['fields'] = 'category_id,category_name,category_slug';
        $param['where']['category_parent_id'] = 1;
        $data = $this->find_all_active($param);
        if(isset($data) AND array_filled($data)) {
            foreach($data as $key=>$value) {
                $param = array();
                $param['fields'] = 'category_id,category_name,category_slug';
                $param['where']['category_parent_id'] = $value['category_id'];
                $data[$key]['sub_category'] = $this->find_all_active($param);
            }
        }

        return $data; 
    }


    public function get_category_id_by_slug($slug)
    {
        $param = array();
        $param['where']['category_slug'] = $slug;
        $data = $this->find_one_active($param);
        return isset($data['category_id']) ? $data['category_id'] : 0;
    }

    public function get_subcat_ids_by_slug($slug)
    {
        $ids = array(0=>0);

        $category_id = $this->get_category_id_by_slug($slug);
        
        if(isset($category_id) AND ($category_id > 0))
        {
            $param = array();
            $param['where']['category_parent_id'] = $category_id;
            $d = $this->find_all_active($param);
            if(isset($d) AND array_filled($d)) {
                foreach($d as $value) {
                    $ids[$value['category_id']] = $value['category_id'];
                }
            }
        }
        return $ids;
    }

    public function find_by_slug($slug)
    {
        $param = array();
        $param['where']['category_slug'] = $slug;
        return $this->find_one_active($param);
    }
    */


    /*
    * table             Table Name
    * Name              FIeld Name
    * label             Field Label / Textual Representation in form and DT headings
    * type              Field type : hidden, text, textarea, editor, etc etc. 
    *                                 Implementation in form_generator.php
    * type_dt           Type used by prepare_datatables method in controller to prepare DT value
    *                                 If left blank, prepare_datatable Will opt to use 'type'
    * type_filter_dt    Used by DT FILTER PREPRATION IN datatables.php
    * attributes        HTML Field Attributes
    * js_rules          Rules to be aplied in JS (form validation)
    * rules             Server side Validation. Supports CI Native rules
    * 
    * list_data         For dropdown etc, data in key-value pair that will populate dropdown 
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    * list_data_key     For dropdown etc, if you want to define list_data in CONTROLLER (public _list_data[$key]) list_data_key is the $key which identifies it
    *                   -----Incase list_data_key is not defined, it will look for field_name as a $key
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    */
    public function get_fields( $specific_field = "" )
    {
        $category_parent_id_type = ($this->router->fetch_class('') == 'sub_category') ? 'dropdown' : 'hidden';
        
        $fields = array(
        
              'category_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'category_id',
                     'label'   => 'id #',
                     'type'   => 'hidden',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),

              'category_parent_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'category_parent_id',
                     'label'   => 'Parent',
                     'type'   => $category_parent_id_type,
                     'type_filter_dt'   => $category_parent_id_type,
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"10%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),

              'category_name' => array(
                     'table'   => $this->_table,
                     'name'   => 'category_name',
                     'label'   => 'Name',
                     'type'   => 'text',
                     //'attributes'   => array(),
                     'attributes'   => array("additional"=>'slugify="#'.$this->_table.'-'.$this->_field_prefix.'slug"'),
                     'js_rules'   => 'required',
                     'rules'   => 'required|trim|htmlentities'
                  ),
              
              // 'category_slug'  => array(
              //     'table'   => $this->_table,
              //     'name'   => 'category_slug',
              //     'label'   => 'Slug',
              //     'type'   => 'text',
              //     'attributes'   => array(),
              //     'js_rules'   => array("is_slug" => array() ),
              //     'rules'   => 'required|strtolower|htmlentities|is_unique['.$this->_table.'.'.$this->_field_prefix.'slug]|callback_is_slug'
              // ),


              /*
            'category_image' => array(
                'table' => $this->_table,
                'name' => 'category_image',
                'label' => 'Image',
                'name_path' => 'category_image_path',
                'upload_config' => 'site_upload_category',
                'type' => 'fileupload',
                'type_dt' => 'image',
                'randomize' => true,
                'preview' => 'true',
                //'thumb'   => array(array('name'=>'category_image_thumb','max_width'=>260, 'max_height'=>250),),
                'attributes'   => array(
                    'image_size_recommended'=>'208px × 103px',
                    'allow_ext'=>'png|jpeg|jpg',
                ),
                'dt_attributes' => array("width" => "10%"),
                'rules' => 'trim|htmlentities',
                'js_rules'=>""
            ),



               'category_desc' => array(
                     'table'   => $this->_table,
                     'name'   => 'category_desc',
                     'label'   => 'Description',
                     'type'   => 'editor',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => '|trim|htmlentities'
                  ),

                  'category_is_feaured' => array(
                     'table'   => $this->_table,
                     'name'   => 'category_is_feaured',
                     'label'   => 'Is Menu?',
                     'type'   => 'switch',
                     'type_dt'   => 'dropdown',
                     'type_filter_dt' => 'dropdown',
                     'list_data_key' => "category_is_feaured" ,
                     'list_data' => array(),
                     'default'   => '1',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"7%"),
                     'rules'   => 'trim'
                  ),


              'category_is_feaured' => array(
                   'table'   => $this->_table,
                   'name'   => 'category_is_feaured',
                   'label'   => 'Type',
                   'type'   => 'dropdown',
                   'list_data'    => array(
                        "0"=>"Normal",
                        "1"=>"Good",
                        "2"=>"Better",
                        "3"=>"Best") ,
                   'attributes'   => array(),
                   'js_rules'   => '',
                   'rules'   => 'trim',
                ),
               */

              'category_status' => array(
                     'table'   => $this->_table,
                     'name'   => 'category_status',
                     'label'   => 'Status?',
                     'type'   => 'switch',
                     'type_dt'   => 'switch',
                     'type_filter_dt' => 'switch',
                     'list_data_key' => "category_status" ,
                     'list_data' => array(),
                     'default'   => '1',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"7%"),
                     'rules'   => 'trim'
                  ),

              
            );
        
        if($specific_field)
            return $fields[ $specific_field ];
        else
            return $fields;
    }

}
?>