<?
class Model_blog_comment extends MY_Model {
    /**
     * article review MODEL
     *
     * @package     Product Rating Model
     * @author      Dalton Lambert (dalton.developer@gmail.com)
     * @version     2.0
     * @since       2017 / Amazingly corrupt models Corporation Inc.
     */

    protected $_table    = 'blog_comment';
    protected $_field_prefix    = 'bc_';
    protected $_pk    = 'bc_id';
    protected $_status_field    = 'bc_status';
    public $relations = array();
    public $pagination_params = array();
    public $dt_params = array();
    public $_per_page    = 20;
    
    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "bc_id,bc_post_id,bc_name,bc_email, bc_status";

        //$this->pagination_params['joins'][] = $this->join_post();
        parent::__construct();
    }

    public function join_post($type="" , $append_joint ="AND post_status = 1" , $prepend_joint = "")
    {
        $joint = $prepend_joint . "bc_post_id = post_id " . $append_joint ; 
        return $this->prep_join("post" , $joint, $type );
    }


    public function get_by_id($id)
    {
        $params = array();
        $params['joins'][] = $this->join_post();
        return $this->find_by_pk($id,false,$params);
    }


    public function get_data_by_post_id($post_id)
    {
        $param = array();
        $param['where']['bc_post_id'] = $post_id;
        $param['order'] = 'bc_id DESC';
        return $this->find_all_active($param);
    }

    // public function total_comments_by_post($post_id)
    // {
    //     $param = array();
    //     $param['where']['bc_post_id'] = $post_id;
    //     return $this->find_count_active($param);
    // }

    // public function already_review($pid,$uid)
    // {
    //     $param['where']['bc_post_id'] = $pid;
    //     $param['where']['bc_user_id'] = $uid;
    //     $d = $this->find_one($param);

    //     return (isset($d['bc_id'])) ? true : false;
    // }
   

    /*
    * table             Table Name
    * Name              FIeld Name
    * label             Field Label / Textual Representation in form and DT headings
    * type              Field type : hidden, text, textarea, editor, etc etc. 
    *                                 Implementation in form_generator.php
    * type_dt           Type used by prepare_datatables method in controller to prepare DT value
    *                                 If left blank, prepare_datatable Will opt to use 'type'
    * type_filter_dt    Used by DT FILTER PREPRATION IN datatables.php
    * attributes        HTML Field Attributes
    * js_rules          Rules to be aplied in JS (form validation)
    * rules             Server side Validation. Supports CI Native rules

    * list_data         For dropdown etc, data in key-value pair that will populate dropdown 
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    * list_data_key     For dropdown etc, if you want to define list_data in CONTROLLER (public _list_data[$key]) list_data_key is the $key which identifies it
    *                   -----Incase list_data_key is not defined, it will look for field_name as a $key
    *                   -----USED IN ADMIN_CONTROLLER AND admin's database.php
    */
    public function get_fields( $specific_field = "" )
    {

        $fields = array(
        
              'bc_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'bc_id',
                     'label'   => 'id #',
                     'type'   => 'hidden',
                     'type_dt'   => 'text',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"5%"),
                     'js_rules'   => '',
                     'rules'   => 'trim'
                ),

            
              'bc_post_id' => array(
                     'table'   => $this->_table,
                     'name'   => 'bc_post_id',
                     'label'   => 'Post',
                     'type'   => 'dropdown',
                     'type_dt'   => 'dropdown',
                     'type_filter_dt'   => 'dropdown',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"10%"),
                     'js_rules'   => 'required',
                     'rules'   => 'required|trim'
                ),

              // 'bc_user_id' => array(
              //        'table'   => $this->_table,
              //        'name'   => 'bc_user_id',
              //        'label'   => 'User',
              //        'type'   => 'hidden',
              //        'type_dt'   => 'text',
              //        'type_filter_dt'   => 'dropdown',
              //        'attributes'   => array(),
              //        'dt_attributes'   => array("width"=>"10%"),
              //        'js_rules'   => '',
              //        'rules'   => 'trim'
              //   ),

              // 'bc_rating' => array(
              //        'table'   => $this->_table,
              //        'name'   => 'bc_rating',
              //        'label'   => 'Rating',
              //        'type'   => 'dropdown',
              //        'list_data'    => array("1"=>"1","2"=>"2","3"=>"3","4"=>"4", "5"=>"5") ,
              //        'attributes'   => array(),
              //        'js_rules'   => 'required',
              //        'rules'   => 'required',
              //     ),

              'bc_name' => array(
                     'table'   => $this->_table,
                     'name'   => 'bc_name',
                     'label'   => 'Name',
                     'type'   => 'text',
                     'attributes'   => array(),
                     'js_rules'   => 'required',
                     'rules'   => 'required|trim|htmlentities'
                  ),



              'bc_email'  => array(
                  'table'   => $this->_table,
                  'name'   => 'bc_email',
                  'label'   => 'Email',
                  'type'   => 'text',
                  'attributes'   => array(),
                  'js_rules'   => array(),
                  'rules'   => 'required|htmlentities|valid_email'
              ),


              'bc_comment' => array(
                     'table'   => $this->_table,
                     'name'   => 'bc_comment',
                     'label'   => 'Comment',
                     'type'   => 'textarea',
                     'attributes'   => array(),
                     'js_rules'   => '',
                     'rules'   => 'required|trim|htmlentities'
                  ),

              
              'bc_status' => array(
                     'table'   => $this->_table,
                     'name'   => 'bc_status',
                     'label'   => 'Status?',
                     'type'   => 'switch',
                     'type_dt'   => 'dropdown',
                     'type_filter_dt' => 'dropdown',
                     'list_data_key' => "bc_status" ,
                     'list_data' => array(),
                     'default'   => '1',
                     'attributes'   => array(),
                     'dt_attributes'   => array("width"=>"7%"),
                     'rules'   => 'trim'
                  ),
              
            );
        
        if($specific_field)
            return $fields[ $specific_field ];
        else
            return $fields;
    }

}
?>