<?
class Model_assignment_submit extends MY_Model
{
    /**
     * @package     assignment_submit Model
     * @version     1.0
     * @since       2018
     */

    protected $_table = 'assignment_submit';
    protected $_field_prefix = 'assignment_submit_';
    protected $_pk = 'assignment_submit_id';
    protected $_status_field = 'assignment_submit_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page = 20;

    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "";
        parent::__construct();
    }

    
    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */
    public function get_fields($specific_field = "")
    {
        // Use when edit
        $is_required_image = (($this->uri->segment(4)!=null) && intval($this->uri->segment(4)))?'':'required';

        $fields = array(

            'assignment_submit_id' => array(
                'table' => $this->_table,
                'name' => 'assignment_submit_id',
                'label' => 'id #',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => 'trim'
            ),


            'assignment_submit_assignment_id' => array(
                'table' => $this->_table,
                'name' => 'assignment_submit_assignment_id',
                'label' => 'Assignment #',
                'type' => 'dropdown',
                'attributes'   => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),

            'assignment_submit_user_id' => array(
                'table' => $this->_table,
                'name' => 'assignment_submit_user_id',
                'label' => 'User #',
                'type' => 'dropdown',
                'attributes'   => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),



            'assignment_submit_title' => array(
                'table' => $this->_table,
                'name' => 'assignment_submit_title',
                'label' => 'Name',
                'type' => 'text',
                'attributes'   => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),

            'assignment_submit_points' => array(
                'table' => $this->_table,
                'name' => 'assignment_submit_points',
                'label' => 'Marks',
                'type' => 'text',
                'attributes'   => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),
            
            'assignment_submit_feedback' => array(
                'table' => $this->_table,
                'name' => 'assignment_submit_feedback',
                'label' => 'Teacher Feedba',
                'type' => 'text',
                'attributes'   => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),

            // 'assignment_submit_number' => array(
            //     'table' => $this->_table,
            //     'name' => 'assignment_submit_number',
            //     'label' => 'Marks',
            //     'type' => 'text',
            //     'attributes'   => array(),
            //     'js_rules' => 'required',
            //     'rules' => 'required|trim|htmlentities'
            // ),

            
            'assignment_submit_file' => array(
                'table' => $this->_table,
                'name' => 'assignment_submit_file',
                'label' => 'File',
                'name_path' => 'assignment_submit_file_path',
                'upload_config' => 'site_upload_banner',
                'type' => 'fileupload',
                'type_dt' => 'image',
                'randomize' => true,
                'preview' => 'false',
                'attributes'   => array(
                    //'image_size_recommended'=>'421px × 773px ',
                    'allow_ext'=>'png|jpeg|jpg|docx|doc|xlsx|xls|zip|pdf',
                    'file_name_show'=>true,
                    'file_btn_name'=>"File",
                ),
                'dt_attributes' => array("width" => "10%"),
                'rules' => 'trim|htmlentities',
                'js_rules'=>""
            ),

            'assignment_submit_status' => array(
                'table' => $this->_table,
                'name' => 'assignment_submit_status',
                'label' => 'Status?',
                'type' => 'switch',
                'type_dt' => 'switch',
                'type_filter_dt' => 'dropdown',
                'list_data' => array(),
                'default' => '1',
                'attributes' => array(),
                'dt_attributes' => array("width" => "7%"),
                'rules' => 'trim'
            ),
        );

        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;

    }

}

?>