<?php
class Model_assignment_group_member extends MY_Model {

    protected $_table = 'assignment_group_members';
    protected $_field_prefix = 'agm_';
    protected $_pk = 'agm_id';
    protected $_status_field = 'agm_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page = 20;
    
    function __construct() {
        // Call the Model constructor
        $this->pagination_params['fields'] = "agm_id, agm_group_id, agm_user_id, agm_status, agm_added_by, agm_created_date";
        
        parent::__construct();
    }
    
    /**
     * Obtener grupos a los que pertenece un usuario
     * @param int $user_id ID del usuario
     * @param string $type Tipo de grupo (opcional)
     * @return array Lista de grupos
     */
    public function get_user_groups($user_id, $type = null) {
        $this->db->select('ag.*');
        $this->db->from('assignment_group_members agm');
        $this->db->join('assignment_group ag', 'agm.agm_group_id = ag.assignment_group_id');
        $this->db->where('agm.agm_user_id', $user_id);
        $this->db->where('agm.agm_status', 1);
        $this->db->where('ag.assignment_group_status', 1);
        
        // Filtrar por tipo si se especifica
        if ($type !== null) {
            $this->db->where('ag.assignment_group_type', $type);
        } else {
            // Si no se especifica tipo, excluir los grupos regulares
            $this->db->where('ag.assignment_group_type !=', 'regular');
        }
        
        return $this->db->get()->result();
    }
    
    /**
     * Obtener miembros de un grupo
     * @param int $group_id ID del grupo
     * @return array Lista de miembros
     */
    public function get_group_members($group_id) {
        $this->db->select('u.user_id, u.user_firstname, u.user_lastname, u.user_email, agm.agm_id, agm.agm_created_date');
        $this->db->from('assignment_group_members agm');
        $this->db->join('user u', 'agm.agm_user_id = u.user_id');
        $this->db->where('agm.agm_group_id', $group_id);
        $this->db->where('agm.agm_status', 1);
        return $this->db->get()->result();
    }
    
    /**
     * Verificar si un usuario es miembro de un grupo
     * @param int $group_id ID del grupo
     * @param int $user_id ID del usuario
     * @return boolean True si es miembro, false en caso contrario
     */
    public function is_member($group_id, $user_id) {
        $params = array();
        $params['where']['agm_group_id'] = $group_id;
        $params['where']['agm_user_id'] = $user_id;
        $params['where']['agm_status'] = 1;
        return $this->find_one($params) ? true : false;
    }
    
    /**
     * Contar miembros de un grupo
     * @param int $group_id ID del grupo
     * @return int Número de miembros
     */
    public function count_members($group_id) {
        return $this->db->where('agm_group_id', $group_id)
                        ->where('agm_status', 1)
                        ->count_all_results($this->_table);
    }
    
    /**
     * Eliminar un miembro del grupo
     * @param int $group_id ID del grupo
     * @param int $user_id ID del usuario
     * @return boolean True si se eliminó correctamente
     */
    public function remove_member($group_id, $user_id) {
        $params = array();
        $params['where']['agm_group_id'] = $group_id;
        $params['where']['agm_user_id'] = $user_id;
        
        $member = $this->find_one($params);
        
        if ($member) {
            return $this->delete_by_pk($member->agm_id);
        }
        
        return false;
    }
    
    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */
    public function get_fields($specific_field = "") {
        $fields = array(
            'agm_id' => array(
                'table' => $this->_table,
                'name' => 'agm_id',
                'label' => 'ID #',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => 'trim'
            ),
            
            'agm_group_id' => array(
                'table' => $this->_table,
                'name' => 'agm_group_id',
                'label' => 'Group',
                'type' => 'dropdown',
                'attributes' => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim'
            ),
            
            'agm_user_id' => array(
                'table' => $this->_table,
                'name' => 'agm_user_id',
                'label' => 'Student',
                'type' => 'dropdown',
                'attributes' => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim'
            ),
            
            'agm_added_by' => array(
                'table' => $this->_table,
                'name' => 'agm_added_by',
                'label' => 'Added By',
                'type' => 'hidden',
                'attributes' => array(),
                'js_rules' => '',
                'rules' => 'trim'
            ),
            
            'agm_status' => array(
                'table' => $this->_table,
                'name' => 'agm_status',
                'label' => 'Status',
                'type' => 'switch',
                'type_dt' => 'dropdown',
                'type_filter_dt' => 'dropdown',
                'list_data' => array(),
                'default' => '1',
                'attributes' => array(),
                'dt_attributes' => array("width" => "7%"),
                'rules' => 'trim'
            ),
        );
        
        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;
    }
}
?>
