<?
class Model_assignment_group extends MY_Model {

    protected $_table    = 'assignment_group';
    protected $_field_prefix    = 'assignment_group';
    protected $_pk    = 'assignment_group_id';
    protected $_status_field    = 'assignment_group_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page    = 20;
    
    function __construct()
    {
        // Call the Model constructor

       $this->pagination_params['fields'] = "assignment_group_id, assignment_group_name, assignment_group_percentage, assignment_group_course_id, assignment_group_status, assignment_group_type, assignment_group_description, assignment_group_createdon";

       // $this->relations['course_subject'] = array(
       //                              "type"=>"has_many", 
       //                              "own_key"=>"cs_course_id", 
       //                              "other_key"=>"cs_subject_id",
       //                             );
       
       parent::__construct();
    }
    
    /**
     * Verificar si un usuario puede gestionar este grupo
     * @param int $group_id ID del grupo
     * @param int $user_id ID del usuario
     * @return boolean True si puede gestionar, false en caso contrario
     */
    public function can_manage_group($group_id, $user_id) {
        // Verificar si el usuario es administrador
        $this->load->model('model_user');
        $user = $this->model_user->find_by_pk($user_id);
        if ($user && $user->user_is_admin) {
            return true;
        }
        
        // Verificar si el usuario es profesor y creador del grupo
        $group = $this->find_by_pk($group_id);
        if ($user && $user->user_type == LECTURER_USER && $group) {
            // Si el usuario es profesor, puede gestionar los grupos de sus cursos
            // Obtener los cursos del profesor
            $this->load->model('model_course');
            $courses = $this->db->select('course_id')
                              ->from('course')
                              ->where('course_instructor_id', $user_id)
                              ->get()
                              ->result_array();
            
            $course_ids = array_column($courses, 'course_id');
            if (in_array($group->assignment_group_course_id, $course_ids)) {
                return true;
            }
        }
        
        return false;
    }
    
    /**
     * Obtener grupos por curso y tipo
     * @param int $course_id ID del curso
     * @param string $type Tipo de grupo (opcional)
     * @return array Lista de grupos
     */
    public function get_groups_by_course_and_type($course_id, $type = null) {
        $params = array();
        $params['where']['assignment_group_course_id'] = $course_id;
        
        if ($type !== null) {
            $params['where']['assignment_group_type'] = $type;
        }
        
        return $this->find_all($params);
    }
    
    /**
     * Obtener grupos para estudiantes (excluyendo grupos regulares)
     * @param int $course_id ID del curso (opcional)
     * @return array Lista de grupos
     */
    public function get_student_groups($course_id = null) {
        $this->db->select('*')
                ->from($this->_table)
                ->where('assignment_group_type !=', 'regular')
                ->where('assignment_group_status', 1);
        
        if ($course_id !== null) {
            $this->db->where('assignment_group_course_id', $course_id);
        }
        
        return $this->db->get()->result();
    }
    

    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */

    public function get_fields($specific_field = "")
    {
        $fields[ 'assignment_group_id' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'assignment_group_id',
                    'label'   => 'ID',
                    'primary'   => 'primary',
                    'type'   => 'hidden',
                    'type_dt'   => 'text',
                    'attributes'   => array(),
                    'js_rules'   => '',
                    'rules'   => 'trim'
                );

        $fields[ 'assignment_group_course_id' ] = array(
                 'table' => $this->_table,
                'name' => 'quiz_course_id',
                'label' => 'Course #',
                'type' => 'dropdown',
                'attributes'   => array(
                    "class"=>"ajax-populate",
                ),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
                );

        $fields[ 'assignment_group_name' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'assignment_group_name',
                    'label'   => 'Group Name',
                    'type'   => 'text',
                    'default'   => '',
                    'attributes'   => array("additional"=>'slugify="#'.$this->_table.'-'.$this->_field_prefix.'slug"'),
                    'js_rules'   => 'required',
                    'rules'   => 'required|trim'
                );

        $fields[ 'assignment_group_percentage' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'assignment_group_percentage',
                    'label'   => 'Percentage',
                    'type'   => 'text',
                    'default'   => '',
                    'attributes'   => array(),
                    'js_rules'   => 'required',
                    'rules'   => 'required|trim|htmlentities|greater_than[0]'
                );
  
        $fields[ 'assignment_group_status' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'assignment_group_status',
                    'label'   => 'Status?',
                    'type'   => 'dropdown',
                    'default'   => '1',
                    'attributes'   => array(),
                    'rules'   => 'trim'
                );

        $fields[ 'assignment_group_type' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'assignment_group_type',
                    'label'   => 'Group Type',
                    'type'   => 'dropdown',
                    'default'   => 'regular',
                    'list_data' => array(
                        'regular' => 'Regular Group (for grading)',
                        'lab_section' => 'Laboratory Section',
                        'day_slot' => 'Day Slot',
                        'time_slot' => 'Time Slot',
                        'custom' => 'Custom Group'
                    ),
                    'attributes'   => array(),
                    'js_rules'   => 'required',
                    'rules'   => 'required|trim'
                );
                
        $fields[ 'assignment_group_description' ] = array(
                    'table'   => $this->_table,
                    'name'   => 'assignment_group_description',
                    'label'   => 'Description',
                    'type'   => 'textarea',
                    'attributes'   => array(),
                    'js_rules'   => '',
                    'rules'   => 'trim'
                );

        

        if($specific_field)
            return $fields[ $specific_field ];
        else
            return $fields;
    }
}
?>