<?
class Model_assignment extends MY_Model
{
    /**
     * @package     assignment Model
     * @version     1.0
     * @since       2018
     */

    protected $_table = 'assignment';
    protected $_field_prefix = 'assignment_';
    protected $_pk = 'assignment_id';
    protected $_status_field = 'assignment_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page = 20;

    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "assignment_id,assignment_course_id,assignment_subject_id,assignment_title,assignment,assignment_startdate,assignment_enddate,assignment_status";
        parent::__construct();
    }

    
    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */
    public function get_fields($specific_field = "")
    {
        // Use when edit
        $is_required_image = (($this->uri->segment(4)!=null) && intval($this->uri->segment(4)))?'':'required';

        $fields = array(

            'assignment_id' => array(
                'table' => $this->_table,
                'name' => 'assignment_id',
                'label' => 'id #',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "4%"),
                'js_rules' => '',
                'rules' => 'trim'
            ),


            'assignment_course_id' => array(
                'table' => $this->_table,
                'name' => 'assignment_course_id',
                'label' => 'Course #',
                'type' => 'dropdown',
                'attributes'   => array(
                    "class"=>"ajax-populate",
                    "additional" => 'data-target="assignment-assignment,assignment-assignment_subject_id"'
                ),
                'dt_attributes' => array("width" => "14%"),
                // 'list_data'    => array(
                //         "1"=>"Measure Your Energy Levels",
                //         "2"=>"Dosha assignment",
                //         "3"=>"Measure Your Well-Being",) ,
                //'attributes'   => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),

            'assignment_subject_id' => array(
                   'table'   => $this->_table,
                   'name'   => 'assignment_subject_id',
                   'label'   => 'Subject',
                   'type'   => 'dropdown',
                   'type_dt'   => 'dropdown',
                   'type_filter_dt'   => 'dropdown',
                   'attributes'   => array("class"=>"ajax-populate2",
                                           "additional" => ' 
                                                data-populate-uri="get_list"
                                                data-uri="assignment"
                                                data-dd_key="course_subject_id"
                                                data-dd_value="course_subject_name"'
                                      ),
                                      'dt_attributes' => array("width" => "14%"),
                   'js_rules'   => 'required',
                   'rules'   => 'required|trim'
                ),



            'assignment_title' => array(
                'table' => $this->_table,
                'name' => 'assignment_title',
                'label' => 'Name',
                'type' => 'text',
                'attributes'   => array(),
                'dt_attributes' => array("width" => "14%"),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),

            'assignment' => array(
                'table' => $this->_table,
                'name' => 'assignment',
                'label' => 'Assignment Group',
                'type' => 'dropdown',
                'attributes'   => array("class"=>"ajax-populate",
                                        "additional" => ' 
                                                data-populate-uri="get_list"
                                                data-uri="assignment_group"
                                                data-dd_key="assignment_group_id"
                                                data-dd_value="assignment_group_name"'
                ),
                'dt_attributes' => array("width" => "14%"),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),
            'assignment_startdate' => array(
                'table' => $this->_table,
                'name' => 'assignment_startdate',
                'label' => 'Release date',//'Start date',
                'type' => 'date',
                'attributes' => array(),
                'js_rules' => 'required',
                'dt_attributes' => array("width" => "9%"),
                'rules' => 'required|trim|htmlentities'
            ),
            'assignment_enddate' => array(
                'table' => $this->_table,
                'name' => 'assignment_enddate',
                'label' => 'Due date',//'End Date',
                'type' => 'date',
                'attributes'   => array(),
                'js_rules' => 'required',
                'dt_attributes' => array("width" => "9%"),
                'rules' => 'required|trim|htmlentities'
            ),
            'assignment_untildate' => array(
                'table' => $this->_table,
                'name' => 'assignment_untildate',
                'label' => 'Until date',//'Until Date',
                'type' => 'date',
                'attributes'   => array(),
                'js_rules' => 'required',
                'dt_attributes' => array("width" => "9%"),
                'rules' => 'required|trim|htmlentities'
            ),

            'assignment_number' => array(
                'table' => $this->_table,
                'name' => 'assignment_number',
                'label' => 'Marks',
                'type' => 'text',
                'attributes'   => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),

            'assignment_description' => array(
                'table' => $this->_table,
                'name' => 'assignment_description',
                'label' => 'Description',
                'type' => 'editor',
                'attributes'   => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),
            
            'assignment_feedback' => array(
                'table' => $this->_table,
                'name' => 'assignment_feedback',
                'label' => 'Feedback',
                'type' => 'editor',
                'attributes'   => array(),
                'js_rules' => '',
                'rules' => 'trim|htmlentities'
            ),
            
            // 'assignment_points' => array(
            //     'table' => $this->_table,
            //     'name' => 'assignment_points',
            //     'label' => 'Marks',
            //     'type' => 'text',
            //     'attributes'   => array(),
            //     'js_rules' => '',
            //     'rules' => 'trim|htmlentities'
            // ),

            'assignment_file' => array(
                'table' => $this->_table,
                'name' => 'assignment_file',
                'label' => 'File',
                'name_path' => 'assignment_file_path',
                'upload_config' => 'site_upload_banner',
                'type' => 'fileupload',
                'type_dt' => 'image',
                'randomize' => true,
                'preview' => 'false',
                'attributes'   => array(
                    //'image_size_recommended'=>'421px × 773px ',
                    'allow_ext'=>'png|jpeg|jpg|docx|doc|xlsx|xls|zip|pdf',
                    'file_name_show'=>true,
                    'file_btn_name'=>"File",
                ),
                'dt_attributes' => array("width" => "10%"),
                'rules' => 'trim|htmlentities',
                'js_rules'=>""
            ),

            'assignment_status' => array(
                'table' => $this->_table,
                'name' => 'assignment_status',
                'label' => 'Status?',
                'type' => 'switch',
                'type_dt' => 'switch',
                'type_filter_dt' => 'dropdown',
                'list_data' => array(),
                'default' => '1',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'rules' => 'trim'
            ),
        );

        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;

    }

}

?>