<?
class Model_announcements extends MY_Model
{
    /**
     * TKD announcements MODEL
     *
     * @package     announcements Model
     * @version     1.0
     * @since       2017
     */

    protected $_table = 'announcements';
    protected $_field_prefix = 'announcements_';
    protected $_pk = 'announcements_id';
    protected $_status_field = 'announcements_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page = 20;

    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "announcements_id,announcements_course_id,announcements_title,announcements_status,announcements_createdon";

        parent::__construct();
    }

    

    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */
    public function get_fields($specific_field = "")
    {
        // Use when add new image
        $is_required_image = (($this->uri->segment(4)!=null) && intval($this->uri->segment(4)))?'':'required';

        $fields = array(

            'announcements_id' => array(
                'table' => $this->_table,
                'name' => 'announcements_id',
                'label' => 'id #',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => 'trim'
            ),


            'announcements_course_id' => array(
                   'table'   => $this->_table,
                   'name'   => 'announcements_course_id',
                   'label'   => 'Course #',
                   'type'   => 'dropdown',
                   // 'list_data'    => array(
                   //      "1"=>"Position 1",
                   //      "2"=>"Position 2",
                   //      "3"=>"Position 3",
                   //      "4"=>"Position 4",
                   //      "5"=>"Position 5") ,
                   'attributes'   => array(),
                   'js_rules'   => '',
                   'rules'   => 'trim',
                ),

            'announcements_title' => array(
                'table' => $this->_table,
                'name' => 'announcements_title',
                'label' => 'Title',
                'type' => 'text',
                'attributes' => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),


            'announcements_description' => array(
                'table' => $this->_table,
                'name' => 'announcements_description',
                'label' => 'Description',
                'type' => 'textarea',
                'attributes'   => array("class"=>"summernote_textarea"),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),
            
            'announcements_status' => array(
                'table' => $this->_table,
                'name' => 'announcements_status',
                'label' => 'Status?',
                'type' => 'switch',
                'type_dt' => 'switch',
                'type_filter_dt' => 'dropdown',
                'list_data' => array(),
                'default' => '1',
                'attributes' => array(),
                'dt_attributes' => array("width" => "7%"),
                'rules' => 'trim'
            ),

            'announcements_createdon' => array(
                'table' => $this->_table,
                'name' => 'announcements_createdon',
                'label' => 'Notification date',
                'type' => 'label',
                'attributes' => array(),
                'dt_attributes' => array("width" => "7%"),
                'rules' => 'trim'
            ),

        );

        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;

    }

}

?>