<?
class Model_adv_banner extends MY_Model
{
    /**
     * TKD adv_banner MODEL
     *
     * @package     adv_banner Model
     * @version     1.0
     * @since       2017
     */

    protected $_table = 'adv_banner';
    protected $_field_prefix = 'ab_';
    protected $_pk = 'ab_id';
    protected $_status_field = 'ab_status';
    public $pagination_params = array();
    public $relations = array();
    public $dt_params = array();
    public $_per_page = 20;

    function __construct()
    {
        // Call the Model constructor
        $this->pagination_params['fields'] = "ab_id,CONCAT(ab_image_path,ab_image) AS ab_image,ab_status";

        parent::__construct();
    }

    // public function get_page_banner($page='')
    // {
    //     // Set params
    //     $params['fields'] = 'ab_page,ab_title,ab_image_path,ab_image,ab_status';
    //     $params['where']['ab_page'] = $page;
    //     return $this->model_banner->find_one_active($params);

    // }

    public function get_banners($params = array())
    {
        // Set params
        //$params = array();
        $params['order'] = 'ab_position ASC';
        return $this->model_banner->find_all_active($params);

    }

    /*
    * table       Table Name
    * Name        FIeld Name
    * label       Field Label / Textual Representation in form and DT headings
    * type        Field type : hidden, text, textarea, editor, etc etc. 
    *                           Implementation in form_generator.php
    * type_dt     Type used by prepare_datatables method in controller to prepare DT value
    *                           If left blank, prepare_datatable Will opt to use 'type'
    * attributes  HTML Field Attributes
    * js_rules    Rules to be aplied in JS (form validation)
    * rules       Server side Validation. Supports CI Native rules
    */
    public function get_fields($specific_field = "")
    {
        // Use when add new image
        $is_required_image = (($this->uri->segment(4)!=null) && intval($this->uri->segment(4)))?'':'required';

        $fields = array(

            'ab_id' => array(
                'table' => $this->_table,
                'name' => 'ab_id',
                'label' => 'id #',
                'type' => 'hidden',
                'type_dt' => 'text',
                'attributes' => array(),
                'dt_attributes' => array("width" => "5%"),
                'js_rules' => '',
                'rules' => 'trim'
            ),

            'ab_link' => array(
                'table' => $this->_table,
                'name' => 'ab_link',
                'label' => 'Link',
                'type' => 'textarea',
                'attributes' => array(),
                'js_rules' => 'required',
                'rules' => 'required|trim|htmlentities'
            ),

            'ab_image' => array(
                'table' => $this->_table,
                'name' => 'ab_image',
                'label' => 'Image',
                'name_path' => 'ab_image_path',
                'upload_config' => 'site_upload_banner',
                'type' => 'fileupload',
                'type_dt' => 'image',
                'randomize' => true,
                'preview' => 'true',
                'attributes'   => array(
                    'image_size_recommended'=>'1600px × 705px ',
                    'allow_ext'=>'png|jpeg|jpg',
                ),
                'dt_attributes' => array("width" => "10%"),
                'rules' => 'trim|htmlentities',
                'js_rules'=>$is_required_image
            ),


            
            'ab_status' => array(
                'table' => $this->_table,
                'name' => 'ab_status',
                'label' => 'Status?',
                'type' => 'switch',
                'type_dt' => 'switch',
                'type_filter_dt' => 'dropdown',
                'list_data' => array(),
                'default' => '1',
                'attributes' => array(),
                'dt_attributes' => array("width" => "7%"),
                'rules' => 'trim'
            ),

        );

        if ($specific_field)
            return $fields[$specific_field];
        else
            return $fields;

    }

}

?>