<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Create_question_bank_tables extends CI_Migration {

    public function up() {
        // 1. Crear la tabla principal del banco de preguntas
        $this->dbforge->add_field(array(
            'qb_id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'qb_text' => array(
                'type' => 'TEXT',
                'null' => FALSE,
            ),
            'qb_explanation' => array(
                'type' => 'TEXT',
                'null' => TRUE,
            ),
            'qb_type' => array(
                'type' => 'INT',
                'constraint' => 2,
                'null' => FALSE,
                'comment' => '1: Multiple Choice, 2: True/False, 3: Essay, etc.'
            ),
            'qb_difficulty' => array(
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
                'comment' => '1-5 escala de dificultad'
            ),
            'qb_is_bonus' => array(
                'type' => 'TINYINT',
                'constraint' => 1,
                'default' => 0,
            ),
            'qb_gain_point' => array(
                'type' => 'INT',
                'default' => 0,
            ),
            'qb_bonus_points' => array(
                'type' => 'FLOAT',
                'default' => 0,
            ),
            'qb_course_id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE,
            ),
            'qb_subject_id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE,
            ),
            'qb_created_by' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => FALSE,
            ),
            'qb_created_on' => array(
                'type' => 'DATETIME',
                'null' => FALSE,
                'default' => 'CURRENT_TIMESTAMP',
            ),
            'qb_modified_on' => array(
                'type' => 'DATETIME',
                'null' => TRUE,
            ),
            'qb_status' => array(
                'type' => 'TINYINT',
                'constraint' => 1,
                'default' => 1,
            ),
            'qb_tags' => array(
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => TRUE,
            ),
            'qb_options' => array(
                'type' => 'TEXT',
                'null' => TRUE,
                'comment' => 'JSON encoded options',
            ),
            'qb_correct_answer' => array(
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => TRUE,
            ),
        ));
        $this->dbforge->add_key('qb_id', TRUE);
        $this->dbforge->create_table('question_bank', TRUE);

        // 2. Crear tabla de relaciones entre preguntas y quizzes
        $this->dbforge->add_field(array(
            'qq_id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ),
            'qq_quiz_id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'null' => FALSE,
            ),
            'qq_question_id' => array(
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'null' => FALSE,
            ),
            'qq_order' => array(
                'type' => 'INT',
                'constraint' => 3,
                'default' => 0,
            ),
            'qq_points' => array(
                'type' => 'FLOAT',
                'default' => 1,
            ),
            'qq_is_bonus_override' => array(
                'type' => 'TINYINT',
                'constraint' => 1,
                'null' => TRUE,
            ),
            'qq_created_on' => array(
                'type' => 'DATETIME',
                'null' => FALSE,
                'default' => 'CURRENT_TIMESTAMP',
            ),
            'qq_status' => array(
                'type' => 'TINYINT',
                'constraint' => 1,
                'default' => 1,
            ),
        ));
        $this->dbforge->add_key('qq_id', TRUE);
        $this->dbforge->add_key('qq_quiz_id');
        $this->dbforge->add_key('qq_question_id');
        $this->dbforge->create_table('quiz_questions', TRUE);

        // Au00f1adir u00edndices para mejorar el rendimiento
        $this->db->query('ALTER TABLE `question_bank` ADD INDEX `idx_qb_course_subject` (`qb_course_id`, `qb_subject_id`)');
        $this->db->query('ALTER TABLE `question_bank` ADD INDEX `idx_qb_type` (`qb_type`)');
        $this->db->query('ALTER TABLE `question_bank` ADD INDEX `idx_qb_status` (`qb_status`)');
        $this->db->query('ALTER TABLE `quiz_questions` ADD INDEX `idx_qq_quiz_question` (`qq_quiz_id`, `qq_question_id`)');
    }

    public function down() {
        // Eliminar tablas en orden inverso
        $this->dbforge->drop_table('quiz_questions', TRUE);
        $this->dbforge->drop_table('question_bank', TRUE);
    }
}
