<?php defined('BASEPATH') OR exit('No direct script access allowed');


class ISO extends Geolib{
    
    public function __construct() {
        
    }
    
    /**
     * return a generic IP of an ISO coded country
     * @author Alex Corvi
     * @param  string $iso ISO code of coutnry
     * @return string IP
     */
    protected function iso2ip($iso){
        $iso = strtolower($iso);
        $data = array(
            "gb" => "5.10.16.0",
            "af" => "58.147.128.0",
            "al" => "31.22.48.0",
            "dz" => "41.96.0.0",
            "as" => "202.70.112.0",
            "ao" => "41.63.160.0",
            "ad" => "85.94.160.0",
            "ag" => "69.50.64.0",
            "ar" => "24.232.0.0",
            "am" => "5.77.128.0",
            "aw" => "190.104.96.0",
            "au" => "1.40.0.0",
            "at" => "5.132.128.0",
            "az" => "5.10.240.0",
            "bs" => "24.51.64.0",
            "bh" => "37.131.0.0",
            "bd" => "27.0.96.0",
            "bb" => "23.236.0.0",
            "by" => "5.100.192.0",
            "be" => "5.23.128.0",
            "bz" => "179.42.192.0",
            "bj" => "41.74.0.0",
            "bm" => "64.37.32.0",
            "bt" => "119.2.96.0",
            "bo" => "132.251.224.0",
            "ba" => "5.43.64.0",
            "bw" => "41.74.48.0",
            "br" => "139.82.0.0",
            "bn" => "156.31.0.0",
            "bg" => "5.53.128.0",
            "bf" => "41.138.96.0",
            "bi" => "154.117.192.0",
            "kh" => "36.37.128.0",
            "cm" => "41.67.192.0",
            "ca" => "23.16.0.0",
            "cv" => "41.74.128.0",
            "ky" => "64.96.0.0",
            "td" => "41.74.32.0",
            "cl" => "146.83.0.0",
            "cn" => "1.0.32.0",
            "co" => "66.231.64.0",
            "km" => "197.255.224.0",
            "cg" => "41.75.64.0",
            "cd" => "41.189.192.0",
            "ck" => "202.65.32.0",
            "cr" => "144.22.0.0",
            "ci" => "41.66.0.0",
            "hr" => "5.39.128.0",
            "cu" => "152.206.0.0",
            "cy" => "31.153.0.0",
            "cz" => "5.59.0.0",
            "dk" => "2.104.0.0",
            "dj" => "41.189.224.0",
            "dm" => "192.243.48.0",
            "do" => "64.32.64.0",
            "ec" => "157.100.0.0",
            "eg" => "41.32.0.0",
            "sv" => "168.243.0.0",
            "gq" => "105.235.224.0",
            "er" => "196.200.96.0",
            "ee" => "5.101.112.0",
            "et" => "197.154.0.0",
            "fo" => "80.77.128.0",
            "fj" => "27.123.128.0",
            "fi" => "37.33.0.0",
            "fr" => "2.0.0.0",
            "gf" => "161.22.64.0",
            "pf" => "123.50.64.0",
            "ga" => "41.72.224.0",
            "gm" => "197.242.128.0",
            "ge" => "5.152.0.0",
            "de" => "2.160.0.0",
            "gh" => "41.57.192.0",
            "gi" => "85.115.128.0",
            "gr" => "2.84.0.0",
            "gl" => "88.83.0.0",
            "gp" => "104.250.0.0",
            "gu" => "101.99.128.0",
            "gt" => "168.234.0.0",
            "gn" => "197.149.192.0",
            "gw" => "197.214.80.0",
            "gy" => "181.41.64.0",
            "ht" => "148.102.128.0",
            "va" => "212.77.0.0",
            "hn" => "152.231.0.0",
            "hk" => "1.32.192.0",
            "hu" => "5.38.128.0",
            "is" => "5.23.64.0",
            "in" => "1.6.0.0",
            "id" => "27.50.16.0",
            "ir" => "2.144.0.0",
            "ie" => "5.83.240.0",
            "im" => "5.62.80.0",
            "il" => "2.52.0.0",
            "it" => "2.32.0.0",
            "jm" => "63.143.64.0",
            "iq" => "5.42.192.0",
            "jp" => "1.0.16.0",
            "je" => "212.9.0.0",
            "jo" => "5.45.128.0",
            "kz" => "2.72.0.0",
            "ke" => "41.57.96.0",
            "kr" => "1.11.0.0",
            "kw" => "31.203.0.0",
            "kg" => "31.29.0.0",
            "la" => "115.84.64.0",
            "lv" => "5.179.0.0",
            "lb" => "62.84.64.0",
            "ls" => "41.203.176.0",
            "lr" => "41.57.80.0",
            "ly" => "41.242.16.0",
            "li" => "31.10.16.0",
            "lt" => "5.20.0.0",
            "lu" => "78.141.128.0",
            "mo" => "27.109.128.0",
            "mk" => "31.11.64.0",
            "mg" => "41.63.128.0",
            "mw" => "41.75.112.0",
            "my" => "1.9.0.0",
            "mv" => "27.114.128.0",
            "ml" => "41.73.96.0",
            "mt" => "37.75.32.0",
            "mq" => "109.203.224.0",
            "mr" => "41.138.128.0",
            "mu" => "41.72.192.0",
            "mx" => "131.178.0.0",
            "fm" => "119.252.112.0",
            "md" => "5.56.64.0",
            "mc" => "80.94.96.0",
            "mn" => "49.0.128.0",
            "me" => "31.204.192.0",
            "ma" => "41.87.128.0",
            "mz" => "41.94.0.0",
            "mm" => "61.4.64.0",
            "na" => "41.63.192.0",
            "nr" => "203.98.224.0",
            "np" => "27.34.0.0",
            "nl" => "5.104.112.0",
            "nc" => "61.5.208.0",
            "nz" => "14.1.32.0",
            "ni" => "161.0.32.0",
            "ne" => "41.203.128.0",
            "ng" => "41.58.0.0",
            "mp" => "202.88.64.0",
            "no" => "5.249.224.0",
            "om" => "5.21.0.0",
            "pk" => "14.192.128.0",
            "pw" => "202.124.224.0",
            "ps" => "5.43.192.0",
            "pa" => "179.42.64.0",
            "pg" => "202.1.32.0",
            "py" => "181.124.0.0",
            "pe" => "132.191.0.0",
            "ph" => "27.123.224.0",
            "pl" => "5.173.0.0",
            "pt" => "31.22.128.0",
            "pr" => "24.54.192.0",
            "qa" => "80.76.160.0",
            "re" => "154.67.0.0",
            "ro" => "5.254.0.0",
            "ru" => "2.60.0.0",
            "rw" => "105.178.0.0",
            "kn" => "198.32.208.0",
            "pm" => "70.36.0.0",
            "vc" => "24.92.144.0",
            "ws" => "202.4.32.0",
            "sm" => "77.242.208.0",
            "st" => "197.159.160.0",
            "sa" => "5.163.0.0",
            "sn" => "41.219.0.0",
            "rs" => "62.108.96.0",
            "sc" => "154.70.160.0",
            "sl" => "197.215.0.0",
            "sg" => "27.111.224.0",
            "sk" => "46.229.224.0",
            "si" => "37.18.224.0",
            "sb" => "202.1.160.0",
            "so" => "197.220.64.0",
            "za" => "41.57.128.0",
            "es" => "5.40.0.0",
            "lk" => "124.43.0.0",
            "sd" => "41.240.0.0",
            "sr" => "190.98.32.0",
            "sz" => "41.84.224.0",
            "se" => "2.64.0.0",
            "tw" => "1.160.0.0",
            "ch" => "5.149.32.0",
            "sy" => "78.110.96.0",
            "tj" => "109.75.48.0",
            "tz" => "41.204.128.0",
            "th" => "27.131.128.0",
            "tl" => "180.189.160.0",
            "tg" => "80.248.64.0",
            "tt" => "190.59.0.0",
            "tn" => "154.104.0.0",
            "tr" => "5.104.0.0",
            "tm" => "95.85.96.0",
            "tc" => "65.255.48.0",
            "tv" => "202.2.96.0",
            "ug" => "41.202.224.0",
            "ua" => "5.248.0.0",
            "ae" => "31.215.0.0",
            "us" => "3.0.0.0",
            "uy" => "186.8.0.0",
            "uz" => "77.220.192.0",
            "vu" => "202.80.32.0",
            "ve" => "161.22.32.0",
            "vg" => "98.158.96.0",
            "vn" => "27.2.0.0",
            "vi" => "66.248.160.0",
            "ye" => "82.114.160.0",
            "zm" => "41.216.0.0",
            "zw" => "154.119.80.0"
        );
        if(isset($data[$iso])) return $data[$iso];
        else return false;
    }

    /**
     * return an ISO country code for a currency
     * @author Alex Corvi
     * @param  string $cur currency code
     * @return string iso country code
     */
    protected function currency2iso($cur){

        $data = array(
            "USD" => "US",
            "GBP" => "GB",
            "BDT" => "BD",
            "EUR" => "BE",
            "BGN" => "BG",
            "BAM" => "BA",
            "BBD" => "BB",
            "XPF" => "WF",
            "BMD" => "BM",
            "BND" => "BN",
            "BOB" => "BO",
            "BHD" => "BH",
            "BIF" => "BI",
            "BTN" => "BT",
            "JMD" => "JM",
            "NOK" => "BV",
            "BWP" => "BW",
            "WST" => "WS",
            "BRL" => "BR",
            "BSD" => "BS",
            "BYR" => "BY",
            "BZD" => "BZ",
            "RUB" => "RU",
            "RWF" => "RW",
            "RSD" => "RS",
            "TMT" => "TM",
            "TJS" => "TJ",
            "RON" => "RO",
            "NZD" => "TK",
            "GTQ" => "GT",
            "XAF" => "GQ",
            "EUR" => "GP",
            "JPY" => "JP",
            "GYD" => "GY",
            "GEL" => "GE",
            "XCD" => "GD",
            "XAF" => "GA",
            "GNF" => "GN",
            "GMD" => "GM",
            "DKK" => "GL",
            "GIP" => "GI",
            "GHS" => "GH",
            "OMR" => "OM",
            "TND" => "TN",
            "JOD" => "JO",
            "HRK" => "HR",
            "HTG" => "HT",
            "HUF" => "HU",
            "HKD" => "HK",
            "HNL" => "HN",
            "AUD" => "HM",
            "VEF" => "VE",
            "ILS" => "PS",
            "NOK" => "SJ",
            "PYG" => "PY",
            "IQD" => "IQ",
            "PAB" => "PA",
            "XPF" => "PF",
            "PGK" => "PG",
            "PEN" => "PE",
            "PKR" => "PK",
            "PHP" => "PH",
            "NZD" => "PN",
            "PLN" => "PL",
            "ZMK" => "ZM",
            "MAD" => "EH",
            "EGP" => "EG",
            "ZAR" => "ZA",
            "VND" => "VN",
            "SBD" => "SB",
            "ETB" => "ET",
            "SOS" => "SO",
            "ZWL" => "ZW",
            "SAR" => "SA",
            "ERN" => "ER",
            "MDL" => "MD",
            "MGA" => "MG",
            "MAD" => "MA",
            "UZS" => "UZ",
            "MMK" => "MM",
            "MOP" => "MO",
            "MNT" => "MN",
            "MKD" => "MK",
            "MUR" => "MU",
            "MWK" => "MW",
            "MVR" => "MV",
            "XCD" => "MS",
            "MRO" => "MR",
            "UGX" => "UG",
            "TZS" => "TZ",
            "MYR" => "MY",
            "MXN" => "MX",
            "ILS" => "IL",
            "SHP" => "SH",
            "FJD" => "FJ",
            "FKP" => "FK",
            "DKK" => "FO",
            "NIO" => "NI",
            "NOK" => "NO",
            "NAD" => "NA",
            "VUV" => "VU",
            "XPF" => "NC",
            "AUD" => "NF",
            "NGN" => "NG",
            "NZD" => "NZ",
            "NPR" => "NP",
            "AUD" => "NR",
            "NZD" => "NU",
            "NZD" => "CK",
            "CHF" => "CH",
            "COP" => "CO",
            "CNY" => "CN",
            "XAF" => "CM",
            "CLP" => "CL",
            "AUD" => "CC",
            "CAD" => "CA",
            "XAF" => "CG",
            "XAF" => "CF",
            "CDF" => "CD",
            "CZK" => "CZ",
            "AUD" => "CX",
            "CRC" => "CR",
            "ANG" => "CW",
            "CVE" => "CV",
            "CUP" => "CU",
            "SZL" => "SZ",
            "SYP" => "SY",
            "ANG" => "SX",
            "KGS" => "KG",
            "KES" => "KE",
            "SSP" => "SS",
            "SRD" => "SR",
            "AUD" => "KI",
            "KHR" => "KH",
            "XCD" => "KN",
            "KMF" => "KM",
            "STD" => "ST",
            "KRW" => "KR",
            "KPW" => "KP",
            "KWD" => "KW",
            "SLL" => "SL",
            "SCR" => "SC",
            "KZT" => "KZ",
            "KYD" => "KY",
            "SGD" => "SG",
            "SEK" => "SE",
            "SDG" => "SD",
            "DOP" => "DO",
            "XCD" => "DM",
            "DJF" => "DJ",
            "DKK" => "DK",
            "YER" => "YE",
            "DZD" => "DZ",
            "UYU" => "UY",
            "LBP" => "LB",
            "XCD" => "LC",
            "LAK" => "LA",
            "AUD" => "TV",
            "TWD" => "TW",
            "TTD" => "TT",
            "TRY" => "TR",
            "LKR" => "LK",
            "CHF" => "LI",
            "TOP" => "TO",
            "LTL" => "LT",
            "LRD" => "LR",
            "LSL" => "LS",
            "THB" => "TH",
            "XOF" => "TG",
            "XAF" => "TD",
            "USD" => "TC",
            "LYD" => "LY",
            "XCD" => "VC",
            "AED" => "AE",
            "XCD" => "AG",
            "AFN" => "AF",
            "XCD" => "AI",
            "USD" => "VI",
            "ISK" => "IS",
            "IRR" => "IR",
            "AMD" => "AM",
            "ALL" => "AL",
            "AOA" => "AO",
            "USD" => "AS",
            "ARS" => "AR",
            "AUD" => "AU",
            "AWG" => "AW",
            "INR" => "IN",
            "AZN" => "AZ",
            "IDR" => "ID",
            "UAH" => "UA",
            "QAR" => "QA",
            "MZN" => "MZ",
        );

        $cur = strtoupper($cur);
        if (isset($data[$cur])) return strtolower($data[$cur]);
        else return false;

    }

    /**
     * Converts iso code to currency code
     * @author Alex Corvi
     * @param  string $iso ISO code
     * @return string currency code
     */
    protected function iso2currency($iso){
        $data = array(
            "GB" =>"GBP",
            "BD" =>"BDT",
            "BE" =>"EUR",
            "BF" =>"XOF",
            "BG" =>"BGN",
            "BA" =>"BAM",
            "BB" =>"BBD",
            "WF" =>"XPF",
            "BL" =>"EUR",
            "BM" =>"BMD",
            "BN" =>"BND",
            "BO" =>"BOB",
            "BH" =>"BHD",
            "BI" =>"BIF",
            "BJ" =>"XOF",
            "BT" =>"BTN",
            "JM" =>"JMD",
            "BV" =>"NOK",
            "BW" =>"BWP",
            "WS" =>"WST",
            "BQ" =>"USD",
            "BR" =>"BRL",
            "BS" =>"BSD",
            "JE" =>"GBP",
            "BY" =>"BYR",
            "BZ" =>"BZD",
            "RU" =>"RUB",
            "RW" =>"RWF",
            "RS" =>"RSD",
            "TL" =>"USD",
            "RE" =>"EUR",
            "TM" =>"TMT",
            "TJ" =>"TJS",
            "RO" =>"RON",
            "TK" =>"NZD",
            "GW" =>"XOF",
            "GU" =>"USD",
            "GT" =>"GTQ",
            "GS" =>"GBP",
            "GR" =>"EUR",
            "GQ" =>"XAF",
            "GP" =>"EUR",
            "JP" =>"JPY",
            "GY" =>"GYD",
            "GG" =>"GBP",
            "GF" =>"EUR",
            "GE" =>"GEL",
            "GD" =>"XCD",
            "GA" =>"XAF",
            "SV" =>"USD",
            "GN" =>"GNF",
            "GM" =>"GMD",
            "GL" =>"DKK",
            "GI" =>"GIP",
            "GH" =>"GHS",
            "OM" =>"OMR",
            "TN" =>"TND",
            "JO" =>"JOD",
            "HR" =>"HRK",
            "HT" =>"HTG",
            "HU" =>"HUF",
            "HK" =>"HKD",
            "HN" =>"HNL",
            "HM" =>"AUD",
            "VE" =>"VEF",
            "PR" =>"USD",
            "PS" =>"ILS",
            "PW" =>"USD",
            "PT" =>"EUR",
            "SJ" =>"NOK",
            "PY" =>"PYG",
            "IQ" =>"IQD",
            "PA" =>"PAB",
            "PF" =>"XPF",
            "PG" =>"PGK",
            "PE" =>"PEN",
            "PK" =>"PKR",
            "PH" =>"PHP",
            "PN" =>"NZD",
            "PL" =>"PLN",
            "PM" =>"EUR",
            "ZM" =>"ZMK",
            "EH" =>"MAD",
            "EE" =>"EUR",
            "EG" =>"EGP",
            "ZA" =>"ZAR",
            "EC" =>"USD",
            "IT" =>"EUR",
            "VN" =>"VND",
            "SB" =>"SBD",
            "ET" =>"ETB",
            "SO" =>"SOS",
            "ZW" =>"ZWL",
            "SA" =>"SAR",
            "ES" =>"EUR",
            "ER" =>"ERN",
            "ME" =>"EUR",
            "MD" =>"MDL",
            "MG" =>"MGA",
            "MF" =>"EUR",
            "MA" =>"MAD",
            "MC" =>"EUR",
            "UZ" =>"UZS",
            "MM" =>"MMK",
            "ML" =>"XOF",
            "MO" =>"MOP",
            "MN" =>"MNT",
            "MH" =>"USD",
            "MK" =>"MKD",
            "MU" =>"MUR",
            "MT" =>"EUR",
            "MW" =>"MWK",
            "MV" =>"MVR",
            "MQ" =>"EUR",
            "MP" =>"USD",
            "MS" =>"XCD",
            "MR" =>"MRO",
            "IM" =>"GBP",
            "UG" =>"UGX",
            "TZ" =>"TZS",
            "MY" =>"MYR",
            "MX" =>"MXN",
            "IL" =>"ILS",
            "FR" =>"EUR",
            "IO" =>"USD",
            "SH" =>"SHP",
            "FI" =>"EUR",
            "FJ" =>"FJD",
            "FK" =>"FKP",
            "FM" =>"USD",
            "FO" =>"DKK",
            "NI" =>"NIO",
            "NL" =>"EUR",
            "NO" =>"NOK",
            "NA" =>"NAD",
            "VU" =>"VUV",
            "NC" =>"XPF",
            "NE" =>"XOF",
            "NF" =>"AUD",
            "NG" =>"NGN",
            "NZ" =>"NZD",
            "NP" =>"NPR",
            "NR" =>"AUD",
            "NU" =>"NZD",
            "CK" =>"NZD",
            "XK" =>"EUR",
            "CI" =>"XOF",
            "CH" =>"CHF",
            "CO" =>"COP",
            "CN" =>"CNY",
            "CM" =>"XAF",
            "CL" =>"CLP",
            "CC" =>"AUD",
            "CA" =>"CAD",
            "CG" =>"XAF",
            "CF" =>"XAF",
            "CD" =>"CDF",
            "CZ" =>"CZK",
            "CY" =>"EUR",
            "CX" =>"AUD",
            "CR" =>"CRC",
            "CW" =>"ANG",
            "CV" =>"CVE",
            "CU" =>"CUP",
            "SZ" =>"SZL",
            "SY" =>"SYP",
            "SX" =>"ANG",
            "KG" =>"KGS",
            "KE" =>"KES",
            "SS" =>"SSP",
            "SR" =>"SRD",
            "KI" =>"AUD",
            "KH" =>"KHR",
            "KN" =>"XCD",
            "KM" =>"KMF",
            "ST" =>"STD",
            "SK" =>"EUR",
            "KR" =>"KRW",
            "SI" =>"EUR",
            "KP" =>"KPW",
            "KW" =>"KWD",
            "SN" =>"XOF",
            "SM" =>"EUR",
            "SL" =>"SLL",
            "SC" =>"SCR",
            "KZ" =>"KZT",
            "KY" =>"KYD",
            "SG" =>"SGD",
            "SE" =>"SEK",
            "SD" =>"SDG",
            "DO" =>"DOP",
            "DM" =>"XCD",
            "DJ" =>"DJF",
            "DK" =>"DKK",
            "VG" =>"USD",
            "DE" =>"EUR",
            "YE" =>"YER",
            "DZ" =>"DZD",
            "US" =>"USD",
            "UY" =>"UYU",
            "YT" =>"EUR",
            "UM" =>"USD",
            "LB" =>"LBP",
            "LC" =>"XCD",
            "LA" =>"LAK",
            "TV" =>"AUD",
            "TW" =>"TWD",
            "TT" =>"TTD",
            "TR" =>"TRY",
            "LK" =>"LKR",
            "LI" =>"CHF",
            "LV" =>"EUR",
            "TO" =>"TOP",
            "LT" =>"LTL",
            "LU" =>"EUR",
            "LR" =>"LRD",
            "LS" =>"LSL",
            "TH" =>"THB",
            "TF" =>"EUR",
            "TG" =>"XOF",
            "TD" =>"XAF",
            "TC" =>"USD",
            "LY" =>"LYD",
            "VA" =>"EUR",
            "VC" =>"XCD",
            "AE" =>"AED",
            "AD" =>"EUR",
            "AG" =>"XCD",
            "AF" =>"AFN",
            "AI" =>"XCD",
            "VI" =>"USD",
            "IS" =>"ISK",
            "IR" =>"IRR",
            "AM" =>"AMD",
            "AL" =>"ALL",
            "AO" =>"AOA",
            "AS" =>"USD",
            "AR" =>"ARS",
            "AU" =>"AUD",
            "AT" =>"EUR",
            "AW" =>"AWG",
            "IN" =>"INR",
            "AX" =>"EUR",
            "AZ" =>"AZN",
            "IE" =>"EUR",
            "ID" =>"IDR",
            "UA" =>"UAH",
            "QA" =>"QAR",
            "MZ" =>"MZN",
        );

        $iso = strtoupper($iso);
        if(isset($data[$iso])) return $data[$iso];
        else return false;

    }
}