# Quiz Bonus and Penalties - Administrator Guide

## Overview

This guide explains how to configure and manage quiz bonus questions and penalties for late submissions in the CreActivity Hub platform.

## Table of Contents

1. [Configuring Bonus Questions](#configuring-bonus-questions)
2. [Setting Daily Penalties](#setting-daily-penalties)
3. [Assigning Quizzes to User Groups](#assigning-quizzes-to-user-groups)
4. [Viewing Quiz Results with Bonus and Penalties](#viewing-quiz-results-with-bonus-and-penalties)

## Configuring Bonus Questions

Bonus questions allow you to offer additional points for challenging questions without affecting the base quiz score.

### To create a bonus question:

1. Navigate to **Admin > Course Quiz > Add/Edit Question**
2. Fill in the regular question details (question text, options, correct answer)
3. Check the **Is Bonus Question** checkbox
4. Enter the **Bonus Points** value (e.g., 2.0 for a 2-point bonus)
5. Save the question

### Important Notes on Bonus Questions:

- Bonus questions are included in the quiz alongside regular questions
- Students won't explicitly know which questions are bonus questions (unless you mention it in the question text)
- Bonus points are added to the student's final score after any penalties are applied
- The maximum score for a quiz can exceed 100% if students answer bonus questions correctly

## Setting Daily Penalties

Daily penalties allow you to reduce a student's score for submissions made after the due date.

### To configure daily penalties for a quiz:

1. Navigate to **Admin > Quiz > Add/Edit Quiz**
2. Find the **Daily Penalty Percentage** field
3. Enter a value between 0 and 100 (e.g., 5 for a 5% penalty per day late)
4. Save the quiz

### How Penalties Are Calculated:

- If a student submits after the due date, the system calculates how many days late the submission is
- The penalty is calculated as: `Daily Penalty % × Days Late`
- The student's final score is reduced by this penalty percentage
- Example: 
  - Original Score: 80%
  - Daily Penalty: 5%
  - Days Late: 2
  - Penalty Applied: 10% (5% × 2)
  - Final Score: 72% (80% - 10% of 80)

## Assigning Quizzes to User Groups

You can assign quizzes to specific groups of users with customized due dates.

1. Navigate to **Admin > Quiz User Assignment > Add New**
2. Select the **Quiz** from the dropdown
3. Select the **User** or **Group** (if applicable)
4. Set the **Due Date** for this specific assignment
5. Set a custom **Penalty Rate** (optional - overrides the quiz default)
6. Save the assignment

## Viewing Quiz Results with Bonus and Penalties

When viewing quiz results, the system shows detailed information about score calculations:

1. Navigate to **Admin > Quiz Results**
2. Select a quiz result to view
3. The result page will display:
   - Original Score (before penalties)
   - Penalty Applied (percentage)
   - Days Late (if applicable)
   - Bonus Points Earned
   - Final Score (after penalties and bonuses)

## Troubleshooting

- **Q: Bonus points aren't being added to student scores**
  - A: Ensure the "Is Bonus Question" checkbox is checked for the question
  - A: Verify that the correct answer is properly set in the question

- **Q: Penalties aren't being applied for late submissions**
  - A: Check that the Daily Penalty Percentage is set for the quiz
  - A: Verify that the due date is correctly configured for the quiz assignment
  - A: Ensure the user's submission date is properly recorded

- **Q: The maximum score shows more than 100%**
  - A: This is normal when bonus points are included. The base score is still out of 100%, but bonus points can push the total above 100%

## Need Help?

For technical assistance or questions, please contact the system administrator or refer to the technical documentation at `My_application/docs/`.
