<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
        
//Include Admin Wrapper. Break down things abit
//include_once(APPPATH . "core/MY_Controller.php");

/**
 * Controller Wrapper Class.
 *
 * @package
 * @author
 * @version        1.0
 * @since        Version 1.0 2017
 * @comments    Please think of it as fun :P AND ENJOY
 */
class MY_Controller_Account extends MY_Controller
{
    public $navigation_data = array();
    
    public function __construct()
    {
        global $config;
        parent::__construct();

        $this->login_redirect_check_front();
        

        $this->view_pre = 'account/account_area_theme/';
        $this->layout = "my_plain_account";
        $this->add_script(array("theme-account_area.css"));
        $this->user_type = $this->layout_data['user_data']['user_type'];
        $this->navigation_data = $this->get_navigation();

        $this->register_plugins(array("bootstrap-toastr","common_files","my_cart"));
        //$this->package_id = $this->layout_data['user_data']['user_package_id'];
        //$this->register_plugins(array("flag_sprites"));

        // Country Code for Flag Sprites
        $country_code = empty($this->layout_data['user_data']['ui_country_id']) ? 223 : $this->layout_data['user_data']['ui_country_id'];
        $this->layout_data['country'] = $this->model_country->get_country_name($country_code);

        /*
        if($this->layout_data['user_data']['user_type'] == VENDOR_USER) {
            if($this->layout_data['user_data']['user_package_status'] == 1)
            {
                $this->layout_data['trigger_payment_msg'] = ($this->layout_data['user_data']['user_connected_status'] == 0) ? TRUE : FALSE;
                $this->layout_data['payment_msg_desc'] = 'Your account can\'t connect payment merchant, please complete your payment setup';
                $this->layout_data['payment_msg_url'] = l('account-area/connected-account');
            }
            else{
                $this->layout_data['trigger_payment_msg'] = TRUE;
                $this->layout_data['payment_msg_desc'] = 'Before using our '.g('site_title').' Marketplace Purchase Now '.price(g('db.admin.subscription_fee')).'/year';
                $this->layout_data['payment_msg_url'] = l('account-area/payment-subscription');
            }
        }
        else 
        {
            $this->layout_data['trigger_payment_msg'] = FALSE;
        }*/
        $this->layout_data['trigger_payment_msg'] = FALSE;
    }

    public function get_navigation()
    {
        $class = $this->router->fetch_class('');
        $method = $this->router->fetch_method('');

        $data = array();
        
        $data[] = array(
            'is_dropdown' => false,
            'is_dashboard'=>false,
            'class'=>$class=='dashboard' ? 'active' : '',
            'href'=>l('account-area'),
            'icon' => 'fa fa-list',
            'name' => 'Dashboard',
            );

        
        $data[] = array(
            'is_dropdown' => false,
            'is_dashboard'=>true,
            'class'=>($class=='profile' AND $method == 'index') ? 'active' : '',
            'href'=>l('account-area/profile/edit'),
            'icon' => 'fa fa-user',
            'name' => 'Account Info',
            );

        $data[] = array(
            'is_dropdown' => false,
            'is_dashboard'=>true,
            'class'=>$method=='change_password' ? 'active' : '',
            'href'=>l('account-area/change-password'),
            'icon' => 'fa fa-key',
            'name' => 'Password Change',
            );

        // $data[] = array(
        //     'is_dropdown' => false,
        //     'is_dashboard'=>false,
        //     'class'=>$method=='address_info' ? 'active' : '',
        //     'href'=>l('account-area/address-info'),
        //     'icon' => 'fa fa-map',
        //     'name' => 'Address Info',
        //     );

        // $data[] = array(
        //     'is_dropdown' => false,
        //     'is_dashboard'=>false,
        //     'class'=>$method=='about_us' ? 'active' : '',
        //     'href'=>l('account-area/change-profile'),
        //     'icon' => 'fa fa-edit',
        //     'name' => 'About',
        //     );

        

        $data[] = array(
            'is_dropdown' => false,
            'is_dashboard'=>true,
            'class'=>$class=='order' ? 'active' : '',
            'href'=>l('account-area/my-order'),
            'icon' => 'fa fa-book',
            'name' => 'My Orders',
            );

        // $data[] = array(
        //     'is_dropdown' => false,
        //     'is_dashboard'=>true,
        //     'class'=>$method=='chat' ? 'active' : '',
        //     'href'=>l('chat'),
        //     'icon' => 'fa fa-weixin',
        //     'name' => 'My Chat Room',
        //     );
        
        /*

        $data[] = array(
            'is_dropdown' => false,
            'is_dashboard'=>true,
            'class'=>$method=='inquiry_threading_listing' ? 'active' : '',
            'href'=>l('account-area/my-ticket'),
            'icon' => 'fa fa-envelope',
            'name' => 'My Ticket',
            );
        

        $data[] = array(
            'is_dropdown' => false,
            'is_dashboard'=>TRUE,
            'class'=>'',
            'href'=>l('chat'),
            'icon' => 'fa fa-weixin',
            'name' => 'Chat',
            );
        
        */
        if($this->layout_data['user_data']['user_type'] == LECTURER_USER):
            $classes = array('course','course_subject','course_quiz');
            $data[] = array(
                'is_dropdown' => false,
                'is_dashboard'=>true,
                'class'=>in_array($class,$classes) ? 'active' : '',
                'href'=>l('account/course'),
                'icon' => 'fa fa-sitemap',
                'name' => 'Course Management',
                );

            // $classes = array('course_grade');
            // $data[] = array(
            //     'is_dropdown' => false,
            //     'is_dashboard'=>true,
            //     'class'=>in_array($class,$classes) ? 'active' : '',
            //     'href'=>l('account/course_grade'),
            //     'icon' => 'fa fa-sitemap',
            //     'name' => 'Grades',
            //     );


        endif;


        if($this->layout_data['user_data']['user_type'] == CUSTOMER_USER):
            $data[] = array(
                'is_dropdown' => false,
                'is_dashboard'=>false,
                'class'=> $class=='my_courses' ? 'active' : '',
                'href'=>l('account-area/my-courses'),
                'icon' => 'fa fa-university',
                'name' => 'My Courses',
                );
        endif;

        $data[] = array(
            'is_dropdown' => false,
            'is_dashboard'=>false,
            'class'=>'',
            'href'=>l(''),
            'icon' => 'fa fa-reply',
            'name' => 'Go to Home Page',
            );

        $data[] = array(
            'is_dropdown' => false,
            'is_dashboard'=>true,
            'class'=>'',
            'href'=>l('signout'),
            'icon' => 'fa fa-lock',
            'name' => 'Logout',
            );

        return $data;
    }

    /*
    * Redirect If not logged in.
    * Access for all user {Factory/Supplier/Factory Employee}
    */
    public function login_redirect_check_front()
    {
        global $config;
        $login_session = $this->session->userdata('logged_in_front');
        
        if(isset($login_session) AND array_filled($login_session))
        {
            return true;
        }
        else
        {
            $url = urlencode(current_url());
            //redirect("/login");
            redirect(l('login')."?url={$url}&msgtype=error&msg=".urlencode('Please login first'),true);
            exit();
        }
    }



}

// END Controller class

/* End of file Controller.php */
/* Location: ./system/core/Controller.php */
