<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Stripe_payment extends MY_Controller {

	/**
	 * Default Controller
	 */

    private $authorizenet_salt_key;

	public function __construct()
    {
    	parent::__construct();

    }


    public function paynow()
    {
        $reponse = array();
        
        if ($_POST > 0) {
            
            try{
                require_once(APPPATH.'libraries/Stripe/lib/Stripe.php');//or you
                $order_id = $oid = $this->input->post("item_number");
                $page_token = $this->order_no_encrypt($order_id);
                $token = $this->input->post("token");
                $amount = $this->input->post("amount");
                Stripe::setApiKey(STRIPE_SECRET_KEY); //Replace with your Secret Key

                $strip_param = array(
                    "amount" => strip_payment($amount),
                    "currency" => CURRENCY,
                    'customer' => $strip_customer_id,
                    "card" => $token,
                    "description" => $this->input->post("item_name"),
                );

                $charge = Stripe_Charge::create($strip_param);
                
                $charge = str_replace("Stripe\Charge JSON: ", "", $charge);
                $response = json_decode($charge,true);

                // Update USER PROGRAM 
                $param = array();
                $param['order_payment_status'] = 1;
                $param['order_paypal_date'] = date("Y-m-d");
                $param['order_paypal_payment_status'] = $response['object'];
                $param['order_paypal_txn_id'] = $response[id];
                $param['order_paypal_ipn_track_id'] = $response[id];
                $param['order_payment_post'] = serialize($response);
                $param['order_payment_type'] = "STRIPE ACCOUNT";

                $this->save_order_with_payment($order_id,$param);
                
                $url = l('cart/success')."?id=".$order_id."&token=".$page_token;
            }

            catch(Stripe_CardError $e) {
                $title = "Error found in card"; 
                $url = l('cart/error')."?type=stripe&id=".$order_id."&token=".$page_token."&msg=".urlencode($title);
            }
            catch (Stripe_InvalidRequestError $e) {
                $title = "Invalid card";    
                $url = l('cart/error')."?type=stripe&id=".$order_id."&token=".$page_token."&msg=".urlencode($title);
        
            } 
            catch (Stripe_AuthenticationError $e) {
                $title = "Authentication Error Found";  
                $url = l('cart/error')."?type=stripe&id=".$order_id."&token=".$page_token."&msg=".urlencode($title);
            } 
            catch (Stripe_ApiConnectionError $e) {
                $title = "API Connection error found";  
                $url = l('cart/error')."?type=stripe&id=".$order_id."&token=".$page_token."&msg=".urlencode($title);
            } 
            catch (Stripe_Error $e) {
                $title = "Error Found"; 
                $url = l('cart/error')."?type=stripe&id=".$order_id."&token=".$page_token."&msg=".urlencode($title);
            } 
            catch (Exception $e) {
                $title = "Error Found"; 
                $url = l('cart/error')."?type=stripe&id=".$order_id."&token=".$page_token."&msg=".urlencode($title);
            }
            
            redirect($url,1);
            die();
        }
    }




    public function paynow_subscription()
    {
        $reponse = array();
        
        if ($_POST > 0) {
            
            try{
                require_once(APPPATH.'libraries/Stripe/lib/Stripe.php');//or you
                $order_id = $user_id = $oid = $this->input->post("item_number");
                $page_token = $this->order_no_encrypt($order_id);
                $token = $this->input->post("token");
                $amount = $this->input->post("amount");
                Stripe::setApiKey(STRIPE_SECRET_KEY); //Replace with your Secret Key

                // Customer Save APis
                $customer = Stripe_Customer::create([
                  "email" => $this->input->post('email'),
                  "source" => $token,
                ]);

                // Customer ID
                $strip_customer_id = $customer->id;

                // Payment API
                $strip_param = array(
                    "amount" => strip_payment($amount),
                    "currency" => CURRENCY,
                    'customer' => $strip_customer_id,
                    //"card" => $token,
                    "description" => $this->input->post("item_name"),
                );

                $charge = Stripe_Charge::create($strip_param);
                
                $charge = str_replace("Stripe\Charge JSON: ", "", $charge);
                $response = json_decode($charge,true);

                // Update USER PROGRAM 
                $param = array();
                $param['user_package_id'] = 1;
                $param['user_package_price'] = $amount;
                $param['user_package_startdate'] = date("Y-m-d");
                $param['user_package_enddate'] = date("Y-m-d",strtotime("+1 Year"));
                $param['user_package_status'] = 1;
                $param['user_stripe_customer_id'] = $strip_customer_id;

                $this->model_user->update_by_pk($user_id,$param);
                
                $url = l('cart/success')."?id=".$order_id."&token=".$page_token;
            }

            catch(Stripe_CardError $e) {
                $title = "Error found in card"; 
                $url = l('cart/error')."?type=stripe&id=".$order_id."&token=".$page_token."&msg=".urlencode($title);
            }
            catch (Stripe_InvalidRequestError $e) {
                $title = "Invalid card";    
                $url = l('cart/error')."?type=stripe&id=".$order_id."&token=".$page_token."&msg=".urlencode($title);
        
            } 
            catch (Stripe_AuthenticationError $e) {
                $title = "Authentication Error Found";  
                $url = l('cart/error')."?type=stripe&id=".$order_id."&token=".$page_token."&msg=".urlencode($title);
            } 
            catch (Stripe_ApiConnectionError $e) {
                $title = "API Connection error found";  
                $url = l('cart/error')."?type=stripe&id=".$order_id."&token=".$page_token."&msg=".urlencode($title);
            } 
            catch (Stripe_Error $e) {
                $title = "Error Found"; 
                $url = l('cart/error')."?type=stripe&id=".$order_id."&token=".$page_token."&msg=".urlencode($title);
            } 
            catch (Exception $e) {
                $title = "Error Found"; 
                $url = l('cart/error')."?type=stripe&id=".$order_id."&token=".$page_token."&msg=".urlencode($title);
            }
            
            redirect($url,1);
            die();
        }
    }



    /**
    * https://stripe.com/docs/payments/payment-intents
    * https://stripe.com/docs/payouts#payout-schedule
    * https://github.com/stripe/stripe-php
    * https://stripe.com/docs/payments/connected-accounts
    */
    public function paynow_with_connected_account()
    {
        $reponse = array();
        
        if ($_POST > 0) {
            
            try{
                // require_once(APPPATH.'libraries/Stripe/lib/Stripe.php');//or you {{OLD}}
                require_once(APPPATH.'libraries/Stripe_new/init.php');//or you {{ NEW }}

                $order_id = $oid = $this->input->post("item_number");
                $seller_detail = $this->model_shop_item->get_seller_detail($order_id);
                $payment_data = $this->_set_payment_data($seller_detail);

                $page_token = $this->order_no_encrypt($order_id);
                $token = $this->input->post("token");
                $amount = $this->input->post("amount");
                \Stripe\Stripe::setApiKey(STRIPE_SECRET_KEY); //Replace with your Secret Key


                // Receive Full amount in master account
                $charge = \Stripe\Charge::create([
                          "amount" => strip_payment($amount),
                          "currency" => CURRENCY,
                          //'customer' => $strip_customer_id,
                          "source" => $token,
                          "description"=>$this->input->post("item_name"),
                          'transfer_group' => 'ORDER # '.$order_id,
                          ]);
                $charge = str_replace("Stripe\Charge JSON: ", "", $charge);
                $response = json_decode($charge,true);
 
                // Transfer Amount START
                if(isset($payment_data) AND array_filled($payment_data)) {
                    foreach ($payment_data as $key => $value) {
                        // API to transfer Data
                        $transfer = \Stripe\Transfer::create([
                            'amount' => strip_payment($value['amount']),
                            'currency' => CURRENCY,
                            'destination' => $value['destination'],
                            'transfer_group' => 'ORDER # '.$order_id,
                        ]);

                        // Status changed in shop item when payment tranfered
                        if(isset($transfer['status']) AND ($transfer['status'] == 'paid')) {
                            if(isset($value['item_id']) AND array_filled($value['item_id'])) {
                                foreach($value['item_id'] as $item) {
                                    $param = array();
                                    $param['item_stripe_id'] = $transfer['id'];
                                    $param['item_stripe_data'] = serialize($transfer);
                                    $this->model_shop_item->update_by_pk($item,$param);
                                }
                            }
                        }
                    }
                }
                // Transfer Amount END

                // Update USER PROGRAM 
                $param = array();
                $param['order_payment_status'] = 1;
                $param['order_payment_date'] = date("Y-m-d");
                $param['order_payment_txn_id'] = $response[id];
                $param['order_paypal_ipn_track_id'] = $response[id];
                $param['order_payment_post'] = serialize($response);
                $param['order_payment_type'] = "STRIPE ACCOUNT";
                //$param['order_paypal_payment_status'] = $response['object'];

                $this->save_order_with_payment($order_id,$param);
                
                $url = l('cart/success')."?id=".$order_id."&token=".$page_token;
            }

            catch(Stripe_CardError $e) {
                $title = "Error found in card"; 
                $url = l('cart/error')."?type=stripe&id=".$order_id."&token=".$page_token."&msg=".urlencode($title);
            }
            catch (Stripe_InvalidRequestError $e) {
                $title = "Invalid card";    
                $url = l('cart/error')."?type=stripe&id=".$order_id."&token=".$page_token."&msg=".urlencode($title);
        
            } 
            catch (Stripe_AuthenticationError $e) {
                $title = "Authentication Error Found";  
                $url = l('cart/error')."?type=stripe&id=".$order_id."&token=".$page_token."&msg=".urlencode($title);
            } 
            catch (Stripe_ApiConnectionError $e) {
                $title = "API Connection error found";  
                $url = l('cart/error')."?type=stripe&id=".$order_id."&token=".$page_token."&msg=".urlencode($title);
            } 
            catch (Stripe_Error $e) {
                $title = "Error Found"; 
                $url = l('cart/error')."?type=stripe&id=".$order_id."&token=".$page_token."&msg=".urlencode($title);
            } 
            catch (Exception $e) {
                debug($e);
                $title = "Error Found"; 
                $url = l('cart/error')."?type=stripe&id=".$order_id."&token=".$page_token."&msg=".urlencode($title);
            }
            
            redirect($url,1);
            die();
        }
    }


    private function _set_payment_data($data)
    {
        $var = array();
        foreach($data as $value){
            $var[$value['user_id']]['amount'] = 0;
            $var[$value['user_id']]['destination'] = $value['user_connected_id'];
            if(isset($value['product']) AND array_filled($value['product'])) {
                foreach($value['product'] as $v){
                    $var[$value['user_id']]['item_id'][] = $v['item_id'];
                    $var[$value['user_id']]['amount'] += number_format($v['seller_amount'],2);
                }
            }
        }
        
        return $var;
    }
}
