<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Paypal extends MY_Controller {

	/**
	 * Paypal Controller. - The deafult controller
	 *
	 * @package		Paypal
	 * @author		Waqas Ahmed (waqasahmed.it@gmail.com)
	 * @version		2.0
	 * @since		23 AUG, 2017
	 */

	private $paypal_gateway_url;
	private $paypal_email;
	private $paypal_salt_key;
	
	public function __construct()
    {
    	// Call the Model constructor latest_product
        parent::__construct();

        $this->set_attributes();
    }

	private function set_attributes()
	{
		$this->paypal_gateway_url = PAYPAL_GATEWAY_URL;
		$this->paypal_email = g('db.admin.business_email');
		$this->paypal_salt_key = 'F!5#iN@#l_^$';
		return true;
	}

	// private function order_no_encrypt($id)
	// {
	// 	return md5($this->paypal_salt_key.$id);
	// }

	/*
	// Form Order Confirm page before Pay
	public function index()
	{
		if(isset($_GET['id']) AND (intval($_GET['id']) > 0))
		{
			$id = $_GET['id'];
			
			$data['paypal_gateway_url'] = $this->paypal_gateway_url;
			$data['paypal_email'] = $this->paypal_email;

			$data['discount_amount'] = isset($this->session->userdata['discount']['discount_amount']) ? $this->session->userdata['discount']['discount_amount'] : 0;

			$data['user_data'] = $this->session->userdata['logged_in_front'];
			$data['program_data'] = $this->model_user_program->get_result_data_by_pk_id($id);

			$data['success_url'] = l("paypal/paypal_success")."?id=".$id."&code=".$this->order_no_encrypt($id);
			$data['notify_url'] = l("paypal/paypal_notification")."?id=".$id."&code=".$this->order_no_encrypt($id);
			$data['cancel_url'] = l("paypal/paypal_error")."?id=".$id."&code=".$this->order_no_encrypt($id);
			

			$this->load_view('_form',$data);
		}
		else
		{
			die('Kill');
		}
	}
	*/

	// Form Order Confirm page after Pay
	public function paypal_success()
	{
		if(isset($_GET))
		{
			$generate_code = $this->order_no_encrypt($_GET['id']);
			if($generate_code == $_GET['code'])
			{
				redirect(l("cart/success/?token={$generate_code}&id=" . $_GET['id']) , true);
			}
			else
			{
				redirect(l('home/error' , true));
			}
		}
	}

	// If error found in payment
	public function paypal_error()
	{
		if(isset($_GET))
		{
			$generate_code = $this->order_no_encrypt($_GET['id']);
			if($generate_code == $_GET['code'])
			{
				redirect(l("cart/error/?token={$generate_code}&id=" . $_GET['id']) , true);
			}
			else
			{
				redirect(l('home/error' , true));
			}
		}
	}

	// Paypal Notification
	public function paypal_notification()
	{
		if(isset($_GET))
		{
			$generate_code = $this->order_no_encrypt($_GET['id']);
			if($generate_code == $_GET['code'])
			{
				$id = $_GET['id'];
				$status_codes = array("Default"=>0,"Completed"=>1,"Pending"=>2,"Denied"=>3,"Failed"=>4,"Reversed"=>5);
				$payment_status = $_POST['payment_status'];
				$order_payment_status = $status_codes[$payment_status];
				
				// Update USER PROGRAM 
				$data = array();
				if($order_payment_status == 1)
				{
					
					$param = array();
					$param['order_payment_status'] = $order_payment_status;
					$param['order_paypal_date'] = date("Y-m-d");
					$param['order_paypal_payment_status'] = $payment_status ;
					$param['order_paypal_txn_id'] = $_POST['payer_id'];
					$param['order_paypal_ipn_track_id'] = $_POST['ipn_track_id'];
					$param['order_payment_post'] = serialize($_POST);
					$param['order_payment_type'] = "PAYPAL ACCOUNT";

					$this->save_order_with_payment($id,$param);
					
					return true;
				}
			}
		}
	}


	
	public function paypal_notification2()
	{
		if(isset($_GET))
		{
			$generate_code = $this->order_no_encrypt($_GET['id']);
			if($generate_code == $_GET['code'])
			{
				$id = $_GET['id'];
				$status_codes = array("Default"=>0,"Completed"=>1,"Pending"=>2,"Denied"=>3,"Failed"=>4,"Reversed"=>5);
				$payment_status = $_POST['payment_status'];
				$order_payment_status = $status_codes[$payment_status];


				// Update USER PROGRAM 
				$data = array();
				if($order_payment_status == 1)
				{
					// online_quiz_expiry Start
					$param = array();
					$param['oqe_payment_status'] = $order_payment_status;
					$param['oqe_paypal_date'] = date("Y-m-d");
					$param['oqe_paypal_payment_status'] = $payment_status;
					$param['oqe_paypal_txn_id'] = $_POST['payer_id'];
					$where_param = array();
					$where_param['where']['oqe_id'] = $id;
					$this->model_online_quiz_expiry->update_model($where_param,$param);
					// online_quiz_expiry End


					// Email Start
					if(ENVIRONMENT != 'development')
					{
						// sent to user email
						//$this->model_email->notification_invoice($id , 'USER');

						// sent to admin email
						//$this->model_email->notification_invoice($id , 'ADMIN');
					}
					// Email END
					return true;
				}
			}
		}
	}
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */