<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Seo extends MY_Controller {

	/**
	 * SEO Module
	 *
	 * @package		SEO Module control from user table and user info table
	 * @author		Dalton Lambert
	 * @version		2.0 -- Robust , Advanced And More Frustating...
	 * @since		Version 2.0 2018
	 */

    public $_list_data = array();

    public $table_name = 'cms_page';
    private $this_class_name;

	public function __construct() {

		global $config;
		parent::__construct();
		$this->this_class_name = $this->router->fetch_class('');
		
        $this->dt_params['dt_headings'] = "cms_page_id,cms_page_name,cms_page_meta_title,cms_page_meta_keywords";
        $this->dt_params['searchable'] = explode(",", $this->dt_params['dt_headings']);
        
        $this->dt_params['action'] = array(
        								"hide_add_button" => true ,
                                        "hide" => false ,
                                        "show_delete" => false ,
                                        "show_edit" => false ,
                                        "order_field" => false ,
                                        "show_view" => false ,
                                        "is_hide_multi_action_dropdown" => true,
                                        "extra" => array(
											"add_btn" => '<a title="Edit" href="'.la($this->this_class_name).'/add/%d/"'.
															' target="_blank"><button class="btn btn-icon-only yellow" '.
															'data-model="model_'.$this->table_name.'" data-pk="'.$itemId.'" '.'>'.
															'<i class="fa fa-edit"></i></button></a>',
                                        	) ,
                                      );


        
        // $this->_list_data['user_status'] = array( 
        //                                 STATUS_INACTIVE => "<span class=\"label label-default\">Inactive</span>" ,  
        //                                 STATUS_ACTIVE =>  "<span class=\"label label-primary\">Active</span>"  
        //                             );

     

		// For use IN JS Files
		$config['js_config']['paginate'] = $this->dt_params['paginate'];

		//$this->_list_data['user_country'] = $this->model_country->find_all_list_active(array(),"country");


		$_POST = $this->input->post(NULL, true);

		$config['js_config']['paginate']['uri'] .= '?seo_module=1';
	}

	// @Overwrite Method
	public function set_class_name()
	{
		return $this->table_name;
	}


	// BeforeRender Hook to manipulate Overrides... for INdex Method
	public function before_index_render(&$data=array())
	{
		$data['page_title'] = 'SEO';

		$data['this_class_name'] = $this->this_class_name;

		$this->layout_data['bread_crumbs'] = array(
												array(
													"home/"=>"Home" , 
													'seo' => 'SEO',
												)
											);

		// To access from Child Class
		return true;
	}


	// // BeforeRender Hook to manipulate Overrides... for Add Method
	public function before_add_render(&$data)
	{
		$data['page_title'] = 'SEO';

		$data['this_class_name'] = $this->this_class_name;

		$this->layout_data['bread_crumbs'] = array(
												array(
													"home/"=>"Home" , 
													'seo' => 'SEO',
													"seo/add/" => "Add SEO",
												)
											);

		$this->form_params = array(
                "action" => array(
                    //"save_edit_attr" => "#tab_1" ,
                    "hide_save" => false ,
                    "hide_save_new" => false ,
                    "hide_cancel" => false ,
                ),
            );

		if(1==1)
		{
			$data['form_fields']['cms_page']['cms_page_page']['type'] = 'hidden';

			$data['form_fields']['cms_page']['cms_page_title']['type'] = 'hidden';
			$data['form_fields']['cms_page']['cms_page_title']['js_rules'] = '';
			$data['form_fields']['cms_page']['cms_page_title']['rules'] = 'trim|htmlentities';
			$data['form_fields']['cms_page']['cms_page_content']['type'] = 'hidden';
			$data['form_fields']['cms_page']['cms_page_content']['rules'] = 'trim|htmlentities';

			$data['form_fields']['cms_page']['cms_page_meta_title']['rules'] = 'required|trim|htmlentities';
			//$data['form_fields']['cms_page']['cms_page_meta_keywords']['rules'] = 'required|trim|htmlentities';
			$data['form_fields']['cms_page']['cms_page_meta_description']['rules'] = 'required|trim|htmlentities';
			$data['form_fields']['cms_page']['cms_page_meta_title']['js_rules'] = 'required';
			//$data['form_fields']['cms_page']['cms_page_meta_keywords']['js_rules'] = 'required';
			$data['form_fields']['cms_page']['cms_page_meta_description']['js_rules'] = 'required';
		}


		// To access from Child Class
		return true;
	}

	
	public function add($id='', $data=array())
    {
        // Popluated LISTDATA in constructor
        $this->add_script(array( "jquery.validate.js" , "form-validation-script.js") , "js" );
        $this->register_plugins("jquery-file-upload");

        if(isset($_POST) AND array_filled($_POST)) {
        	$_POST['cms_page']['cms_page_content'] = 'no content';

        }
        
       	parent::add($id, $data);
    }
	

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
