<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Quiz_user_assignment extends MY_Controller {

	/**
	 *
	 * @package		Quiz User Assignment
	 *
     * @version		1.0 --
     * @since		Version 1.0 2025
	 */

    public $_list_data = array();
    
    // Define model properties
    protected $model_quiz;
    protected $model_user;

	public function __construct() {

		global $config;

			parent::__construct();

		// Cargar modelo principal
		$this->load->model('model_quiz_user_assignment');

        // Configurar tabla y modelo
        $this->table_name = "tn_quiz_user_assignment";
        $this->model_name = "model_quiz_user_assignment";
        $this->model_obj = $this->model_quiz_user_assignment;

        $this->dt_params['dt_headings'] = "id,quiz_id,user_id,group_id,due_date,penalty_rate";
        $this->dt_params['searchable'] = explode(",", $this->dt_params['dt_headings']);
        
        $this->dt_params['action'] = array(
        							"hide_add_button" => false,
                                        "hide" => false,
                                        "show_delete" => true,
                                        "show_edit" => true,
                                        "order_field" => false,
                                        "show_view" => false,
                                        "width" => "11%",
                                        "extra" => array(),
                                      );

		// For use IN JS Files
		$config['js_config']['paginate'] = $this->dt_params['paginate'];

		// Cargar modelos adicionales
		$this->load->model('model_quiz');
		$this->load->model('model_user');
		
		// Inicializar modelos para callbacks
		$this->model_quiz = $this->model_quiz;
		$this->model_user = $this->model_user;

		// Cargar datos para dropdowns
		$param = array();
		$this->_list_data['quiz_id'] = $this->model_quiz->find_all_list_active($param,'quiz_name');

		$param = array();
		$this->_list_data['user_id'] = $this->model_user->find_all_list_active($param, 'CONCAT(user_firstname, " ", user_lastname)');

		$this->_list_data['status'] = array(
			'1' => '<span class="label label-success">Active</span>',
			'0' => '<span class="label label-danger">Inactive</span>',
		);

		$this->_list_data['user_type'] = array(
			'1' => 'Admin',
			'2' => 'Student',
		);
       
		$_POST = $this->input->post(NULL, true);
	}

	public function index()
	{
		// Generar breadcrumbs
		$this->breadcrumbs->push("Quiz User Assignments", base_url().'admin/quiz_user_assignment');

		// Preparar datos para la vista
		$this->layout_data["page_title"] = "Quiz User Assignments";
		$this->layout_data["module_title"] = "Quiz User Assignments";

		// Inicializar DT params
		$this->dt_params['action']['width'] = "11%";

		// Renderizar la vista principal usando el método heredado
		$this->index_listing();
	}

	// CALLBACK PARA RENDERIZAR EN TABLA
	public function _callback_format_data($field_data , $field_name , $rec)
	{
		if($field_name=='quiz_id')
		{
			$quiz_id = $rec[$field_name];
			$quiz = $this->model_quiz->find_by_pk($quiz_id);
			return $quiz ? $quiz->quiz_name : 'Quiz not found';
		}
		elseif($field_name=='user_id')
		{
			$user = $this->model_user->find_by_pk($rec[$field_name]);
			return $user ? $user->user_firstname . ' ' . $user->user_lastname : '';
		}
		elseif($field_name=='status')
		{
			return $field_data==1 ? "<span class='label label-success'>Active</span>" : "<span class='label label-danger'>Inactive</span>";
		}
		else
			return $field_data;
	}

	public function get_users_by_quiz($quiz_id=0)
	{
		$quiz_id = intval($quiz_id);
		if (!$quiz_id) {
			echo json_encode(['error' => 'ID de quiz inválido']);
			exit();
		}

		$params = array();
		$params['where']['quiz_id'] = $quiz_id;
		$data = $this->{$this->model_name}->find_all($params);
		
		echo json_encode($data);
		exit();
	}

}

/* End of file quiz_user_assignment.php */
/* Location: ./application/controllers/admin/quiz_user_assignment.php */
