<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Quiz_test extends MY_Controller {

    public function __construct() {
        parent::__construct();
        
        // Load required models
        $this->load->model('Model_course_quiz');
        $this->load->model('Model_quiz_category_config');
        $this->load->model('Model_quiz_categories');
        $this->load->model('Model_quiz_category_questions');
    }

    /**
     * Test the category-based question generation
     * 
     * @param int $quiz_id Quiz ID to test
     */
    public function test_category_questions($quiz_id = null) {
        if (!$quiz_id) {
            echo "Please provide a quiz ID to test";
            return;
        }
        
        // Get category configurations for the quiz
        $configurations = $this->Model_quiz_category_config->get_quiz_configurations($quiz_id);
        
        echo "<h2>Quiz Category Configuration Test</h2>";
        echo "<h3>Quiz ID: " . $quiz_id . "</h3>";
        
        if (empty($configurations)) {
            echo "<p>No category configurations found for this quiz.</p>";
            echo "<p>Using traditional question selection method.</p>";
            
            // Get questions using traditional method
            $questions = $this->Model_course_quiz->find_all_active([
                'where' => ['cq_quiz_id' => $quiz_id],
                'order' => 'RAND()'
            ]);
            
            echo "<h4>Questions selected (traditional method): " . count($questions) . "</h4>";
            echo "<ul>";
            foreach ($questions as $q) {
                echo "<li>Question ID: " . $q['cq_id'] . "</li>";
            }
            echo "</ul>";
        } else {
            // Display category configurations
            echo "<h4>Category Configurations:</h4>";
            echo "<table border='1' cellpadding='5'>";
            echo "<tr><th>Category ID</th><th>Category Name</th><th># Questions</th><th>Selection Method</th></tr>";
            
            foreach ($configurations as $config) {
                echo "<tr>";
                echo "<td>" . $config['qcc_category_id'] . "</td>";
                echo "<td>" . $config['qc_name'] . "</td>";
                echo "<td>" . $config['qcc_num_questions'] . "</td>";
                echo "<td>" . ($config['qcc_random_selection'] ? 'Random' : 'Sequential') . "</td>";
                echo "</tr>";
            }
            echo "</table>";
            
            // Get questions using category-based method
            $questions = $this->Model_course_quiz->generate_quiz($quiz_id);
            
            // Display selected questions
            echo "<h4>Questions selected (category-based method): " . count($questions) . "</h4>";
            echo "<table border='1' cellpadding='5'>";
            echo "<tr><th>Question ID</th><th>Category ID</th><th>Category Name</th></tr>";
            
            foreach ($questions as $q) {
                echo "<tr>";
                echo "<td>" . (isset($q['qb_id']) ? $q['qb_id'] : 'N/A') . "</td>";
                echo "<td>" . (isset($q['category_id']) ? $q['category_id'] : 'N/A') . "</td>";
                echo "<td>" . (isset($q['category_name']) ? $q['category_name'] : 'N/A') . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        }
    }
}
