<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Quiz_debug extends MY_Controller {

    /**
     * Controlador de diagnóstico para solucionar problemas con las categorías de quiz
     */
    public function __construct() {
        parent::__construct();
        $this->load->model('Model_quiz_categories');
        $this->load->model('Model_quiz_category_config');
    }

    /**
     * Verificar si hay categorías y crear una de prueba si no hay
     */
    public function check_categories() {
        // Verificar si hay categorías activas
        $categories = $this->Model_quiz_categories->get_data_active();
        
        echo "<h2>Diagnóstico de Categorías de Quiz</h2>";
        
        if (empty($categories)) {
            echo "<p>No hay categorías activas. Intentando crear una categoría de prueba...</p>";
            
            // Crear una categoría de prueba
            $data = array(
                'qc_name' => 'Categoría de Prueba',
                'qc_description' => 'Esta es una categoría de prueba creada automáticamente',
                'qc_status' => STATUS_ACTIVE
            );
            
            $result = $this->Model_quiz_categories->insert_record($data);
            
            if ($result) {
                echo "<p style='color:green'>¡Éxito! Se ha creado una categoría de prueba con ID: {$result}</p>";
            } else {
                echo "<p style='color:red'>Error al crear la categoría de prueba.</p>";
            }
            
            // Verificar nuevamente
            $categories = $this->Model_quiz_categories->get_data_active();
        }
        
        // Mostrar categorías existentes
        echo "<h3>Categorías Existentes:</h3>";
        echo "<table border='1' cellpadding='5'>";
        echo "<tr><th>ID</th><th>Nombre</th><th>Estado</th></tr>";
        
        if (!empty($categories)) {
            foreach ($categories as $cat) {
                echo "<tr>";
                echo "<td>" . $cat['qc_id'] . "</td>";
                echo "<td>" . $cat['qc_name'] . "</td>";
                echo "<td>" . ($cat['qc_status'] == STATUS_ACTIVE ? 'Activo' : 'Inactivo') . "</td>";
                echo "</tr>";
            }
        } else {
            echo "<tr><td colspan='3'>No se encontraron categorías</td></tr>";
        }
        
        echo "</table>";
        
        // Verificar la estructura de la tabla quiz_categories
        echo "<h3>Estructura de la tabla quiz_categories:</h3>";
        $fields = $this->db->list_fields('quiz_categories');
        echo "<pre>";
        print_r($fields);
        echo "</pre>";
        
        // Verificar la estructura de la tabla quiz_category_config
        echo "<h3>Estructura de la tabla quiz_category_config:</h3>";
        $fields = $this->db->list_fields('quiz_category_config');
        echo "<pre>";
        print_r($fields);
        echo "</pre>";
    }
    
    /**
     * Verificar configuraciones de categorías para un quiz específico
     */
    public function check_quiz_categories($quiz_id = 0) {
        if (!$quiz_id) {
            echo "<p>Por favor proporciona un ID de quiz válido</p>";
            return;
        }
        
        echo "<h2>Configuraciones de Categorías para Quiz ID: {$quiz_id}</h2>";
        
        // Obtener configuraciones existentes
        $configs = $this->Model_quiz_category_config->get_quiz_configurations($quiz_id);
        
        if (!empty($configs)) {
            echo "<h3>Configuraciones Existentes:</h3>";
            echo "<table border='1' cellpadding='5'>";
            echo "<tr><th>ID Config</th><th>Categoría ID</th><th>Num Preguntas</th><th>Selección Aleatoria</th></tr>";
            
            foreach ($configs as $cfg) {
                echo "<tr>";
                echo "<td>" . $cfg['qcc_id'] . "</td>";
                echo "<td>" . $cfg['qcc_category_id'] . "</td>";
                echo "<td>" . $cfg['qcc_num_questions'] . "</td>";
                echo "<td>" . ($cfg['qcc_random_selection'] ? 'Sí' : 'No') . "</td>";
                echo "</tr>";
            }
            
            echo "</table>";
        } else {
            echo "<p>No hay configuraciones para este quiz.</p>";
            
            // Intentar crear una configuración de prueba
            echo "<p>Intentando crear una configuración de prueba...</p>";
            
            // Obtener una categoría activa
            $categories = $this->Model_quiz_categories->get_data_active();
            
            if (!empty($categories)) {
                $cat_id = $categories[0]['qc_id'];
                
                $result = $this->Model_quiz_category_config->configure_category(
                    $quiz_id,
                    $cat_id,
                    5, // 5 preguntas
                    1  // selección aleatoria
                );
                
                if ($result) {
                    echo "<p style='color:green'>¡Éxito! Se ha creado una configuración de prueba para la categoría ID: {$cat_id}</p>";
                    
                    // Mostrar la configuración creada
                    $configs = $this->Model_quiz_category_config->get_quiz_configurations($quiz_id);
                    
                    echo "<h3>Nueva Configuración:</h3>";
                    echo "<table border='1' cellpadding='5'>";
                    echo "<tr><th>ID Config</th><th>Categoría ID</th><th>Num Preguntas</th><th>Selección Aleatoria</th></tr>";
                    
                    foreach ($configs as $cfg) {
                        echo "<tr>";
                        echo "<td>" . $cfg['qcc_id'] . "</td>";
                        echo "<td>" . $cfg['qcc_category_id'] . "</td>";
                        echo "<td>" . $cfg['qcc_num_questions'] . "</td>";
                        echo "<td>" . ($cfg['qcc_random_selection'] ? 'Sí' : 'No') . "</td>";
                        echo "</tr>";
                    }
                    
                    echo "</table>";
                } else {
                    echo "<p style='color:red'>Error al crear la configuración de prueba.</p>";
                }
            } else {
                echo "<p style='color:red'>No hay categorías disponibles para crear una configuración.</p>";
            }
        }
    }
}
