<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Quiz_bank extends MY_Controller {

	/**
	 *
	 * @package		Quiz
	 *
     * @version		1.0 --
     * @since		Version 1.0 2018
	 */

    public $_list_data = array();
    public $course_id;

	public function __construct() {

		global $config;
		
		parent::__construct();

        $this->dt_params['dt_headings'] = "quiz_id,quiz_course_id,quiz_subject_id,quiz_name,quiz_status";
        $this->dt_params['searchable'] = explode(",", $this->dt_params['dt_headings']);
        
        $this->dt_params['action'] = array(
        								"hide_add_button" => true ,
                                        "hide" => false ,
                                        "show_delete" => true ,
                                        "show_edit" => true ,
                                        "order_field" => false ,
                                        "show_view" => false ,
                                        "extra" => array() ,
                                      );
        $this->_list_data['quiz_status'] = array(
                                        STATUS_INACTIVE => "<span class=\"label label-default\">Inactive</span>" ,
                                        STATUS_ACTIVE =>  "<span class=\"label label-primary\">Active</span>"
                                    );
        // Following are common so, defined in MY_Controller_Admin
		// $this->dt_params['paginate']['class'] = $config['js_config']['ci_class'];
		// $this->dt_params['paginate']['uri'] = "paginate";
		// $this->dt_params['paginate']['update_status_uri'] = "update_status";

		// For use IN JS Files

		$config['js_config']['paginate'] = $this->dt_params['paginate'];

        $param = array();
        $this->_list_data['quiz_course_id'] = $this->model_course->find_all_list_active($param,'course_title');

        $param = array();
        $this->_list_data['quiz_subject_id'] = $this->model_course_subject->find_all_list_active($param,'course_subject_name');

        // Registrar plugins base en el constructor
        $this->register_plugins(array("datatables", "flag_sprites", "jquery-ui"));
        // NO cargar el script de question_bank.js aquí para evitar doble inicialización
        // Lo cargamos solo en el método index() donde se necesita

		$_POST = $this->input->post(NULL, true);
	}


    public function get_list()
    {
        $id = $this->input->post("search_val"); 
        $param['fields'] = "course_subject_id,course_subject_name";
        $param['where']['course_subject_course_id'] = $id ;
        $data = $this->_list_data['quiz_subject_id'] = $this->model_course_subject->find_all_active($param);
        echo json_encode($data);
    }

    public function index()
    {
        global $config;
        
        // Primero registramos todos los plugins que el controlador base registra en index()
        $this->register_plugins(array(
            "jquery-ui",
            "bootstrap",
            "bootstrap-hover-dropdown",
            "jquery-slimscroll",
            "uniform",
            "bootstrap-switch",
            "bootstrap-datepicker",
            "boots",
            "font-awesome",
            "simple-line-icons",
            "select2",
            "datatables",
            "bootbox",
            "bootstrap-toastr",
            "flag_sprites"
        ));
        
        // Agregar los scripts estándar que carga MY_Controller_Admin::index()
        $this->add_script("pages/tasks.css");
        $this->add_script(array("table-ajax.js", "datatable.js"), "js");
        
        // Agregar el JavaScript para el banco de preguntas
        $this->add_script(array("question_bank.js"), "js");
        
        // Preparar los datos para la vista de la misma manera que lo hace MY_Controller_Admin::index()
        $class_name = $this->class_name;
        $model_name = "model_" . $class_name;
        $model_obj = $this->$model_name;
        
        $this->layout_data['bread_crumbs'] = array(
            array(
                "home/" => "Home",
                $class_name => humanize($class_name)
            )
        );
        
        $data = array();
        $data['page_title_min'] = "Management";
        $data['page_title'] = $class_name;
        $data['class_name'] = $class_name;
        $data['model_name'] = $model_name;
        $data['model_obj'] = $model_obj;
        $data['model_fields'] = $model_obj->get_fields();
        $data['dt_params'] = $this->dt_params;
        $data['model'] = $model_name;
        
        // Preparar datos para los filtros en la vista (cursos y quizzes)
        $param = array();
        $data['course_list'] = $this->model_course->find_all_list_active($param, 'course_title');
        $data['quiz_list'] = $this->model_quiz->find_all_list_active($param, 'quiz_name');
        
        // Permitimos que los hooks modifiquen los datos antes de renderizar
        $this->before_index_render($data);
        
        // Cargar la vista _form en lugar de datatable, pero pasando todos los datos necesarios
        $this->load_view("_form", $data);
    }

    public function add($id=0 , $data = array())
    {
        // Registrar los plugins necesarios
        $this->register_plugins(array("datatables","flag_sprites", "jquery-ui"));
        
        // Agregar el JavaScript con la forma correcta - solo si realmente se necesita en el formulario de add
        // Si el formulario de add no usa question_bank.js, podemos comentar o eliminar esta línea
        // $this->add_script(array("question_bank.js"), "js");
        
        // Mantener el comportamiento original de add
        $insertId = parent::add($id, $data);
        
        return $insertId;
    }
    // mtech
    public function get_questions() 
    {
    $quiz_id = $this->input->get('cq_quiz_id'); // Or use POST if you're sending it via POST
    $param = array();
    $param['where']['cq_quiz_id'] = $quiz_id;
    $question_data = $this->model_course_quiz->find_all($param);
    
    echo json_encode($question_data);
    }
    // mtech
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
