<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Quiz extends MY_Controller {

	/**
	 *
	 * @package		Quiz
	 *
     * @version		1.0 --
     * @since		Version 1.0 2018
	 */

    public $_list_data = array();
    public $course_id;

	public function __construct() {

		global $config;
		
		parent::__construct();
		
		// Add extra action for category configuration
		$this->dt_params['action']['extra'][] = '<a href="' . base_url("admin/quiz/configure_categories/{quiz_id}") . '" class="btn btn-info btn-xs" data-toggle="tooltip" title="Configure Categories"><i class="fa fa-cog"></i> Categories</a>';

        $this->dt_params['dt_headings'] = "quiz_id,quiz_course_id,quiz_subject_id,assignment,quiz_name,quiz_status,quiz_createdon";
        $this->dt_params['searchable'] = explode(",", $this->dt_params['dt_headings']);
        
        $this->dt_params['action'] = array(
        								"hide_add_button" => false ,
                                        "hide" => false ,
                                        "show_delete" => true ,
                                        "show_edit" => true ,
                                        "order_field" => false ,
                                        "show_view" => false ,
                                        "extra" => array() ,
                                      );
        $this->_list_data['quiz_status'] = array(
                                        STATUS_ACTIVE => "Active",
                                        STATUS_INACTIVE => "Inactive",
        );

        // Following are common so, defined in MY_Controller_Admin
		// $this->dt_params['paginate']['class'] = $config['js_config']['ci_class'];
		// $this->dt_params['paginate']['uri'] = "paginate";
		// $this->dt_params['paginate']['update_status_uri'] = "update_status";

		// For use IN JS Files

		$config['js_config']['paginate'] = $this->dt_params['paginate'];

        $param = array();
        $this->_list_data['quiz_course_id'] = $this->model_course->find_all_list_active($param,'course_title');

        $param = array();
        $this->_list_data['quiz_subject_id'] = $this->model_course_subject->find_all_list_active($param,'course_subject_name');
        $param = array();
        $this->_list_data['assignment'] = $this->model_assignment_group->find_all_list_active($param,'assignment_group_name');


		$_POST = $this->input->post(NULL, true);
	}


    public function get_list()
    {
        $id = $this->input->post("search_val"); 
        $param['fields'] = "course_subject_id,course_subject_name";
        $param['where']['course_subject_course_id'] = $id ;
        $data = $this->_list_data['quiz_subject_id'] = $this->model_course_subject->find_all_active($param);
        echo json_encode($data);
    }

    /**
     * Obtener detalles del quiz para asignaciones personalizadas
     * @param int $id Quiz ID
     */
    public function get_quiz_details($id = 0)
    {
        $id = intval($id);
        if (!$id) {
            echo json_encode(['error' => 'Invalid ID']);
            exit;
        }
        
        $quiz = $this->model_quiz->find_by_pk($id);
        if (!$quiz) {
            echo json_encode(['error' => 'Quiz not found']);
            exit;
        }
        
        // Return dates and penalty rates
        $response = [
            'quiz_id' => $quiz->quiz_id,
            'quiz_name' => $quiz->quiz_name,
            'quiz_startdate' => $quiz->quiz_startdate,
            'quiz_enddate' => $quiz->quiz_enddate,
            'quiz_untildate' => $quiz->quiz_untildate,
            'quiz_daily_penalty' => $quiz->quiz_daily_penalty ?? 0
        ];
        
        echo json_encode($response);
        exit;
    }

    public function add($id = 0, $data = array())
    {
        // Always include base JS and plugins
        $this->add_script(array('quiz.js'), 'js');
        $this->register_plugins(array('datatables', 'flag_sprites'));
        
        // Load category models
        $this->load->model('Model_quiz_categories');
        $this->load->model('Model_quiz_category_config');

        // 1) POST – save quiz data and category configurations
        if ($this->input->post()) {
            // Save quiz using parent method
            $insertId = parent::add($id, $data);
            $quiz_id = $insertId ?: $id;

            // Collect selected categories and their question limits
            $cat_ids = (array)$this->input->post('categories');
            $num_questions = (array)$this->input->post('num_questions');

            // Prepare configurations
            $points_per_question = (array)$this->input->post('points_per_question');
            $configurations = array();
            foreach ($cat_ids as $cid) {
                $config = array(
                    'category_id' => (int)$cid,
                    'num_questions' => isset($num_questions[$cid]) ? (int)$num_questions[$cid] : 1,
                    'random_selection' => 1
                );
                // Agregar puntos si el input está presente (puede ser vacío)
                if (array_key_exists($cid, $points_per_question)) {
                    $val = trim($points_per_question[$cid]);
                    // Si está vacío o es 0, guardar como null
                    if ($val === '' || $val === '0' || $val === 0) {
                        $config['points_per_question'] = null;
                    } else {
                        $config['points_per_question'] = floatval($val);
                    }
                }
                $configurations[] = $config;
            }
            $this->Model_quiz_category_config->update_configurations($quiz_id, $configurations);

            // Redirect to edit after saving
            redirect('admin/quiz/edit/' . $quiz_id);
            return;
        }

        // 2) GET – show form with data
        $this->layout_data['categories'] = $this->Model_quiz_categories->get_data_active(array(
            'order' => 'qc_name ASC'
        ));
        if (empty($this->layout_data['categories'])) {
            $this->layout_data['categories'] = $this->Model_quiz_categories->get_data(array(
                'order' => 'qc_name ASC'
            ));
        }

        // Ensure categories is an array to avoid errors
        if (!is_array($this->layout_data['categories'])) {
            $this->layout_data['categories'] = array();
        }

        // Categories already selected with their question limit (edit mode only)
        // Get existing configurations and convert to cat_id => num array
        $selected = array();
        $selected_categories_points = array();
        $form_data = array();
        if ($id) {
            $configs = $this->Model_quiz_category_config->get_quiz_configurations($id);
            if (!empty($configs)) {
                foreach ($configs as $cfg) {
                    $selected[$cfg['qcc_category_id']] = $cfg['qcc_num_questions'];
                    // Guardar puntos si existen
                    if (isset($cfg['qcc_points_per_question'])) {
                        $selected_categories_points[$cfg['qcc_category_id']] = $cfg['qcc_points_per_question'];
                    }
                }
                error_log('DEBUG SELECTED CATEGORIES: ' . print_r($selected, true));
                error_log('DEBUG SELECTED CATEGORIES POINTS: ' . print_r($selected_categories_points, true));
            } else {
                error_log('No hay configuraciones para el quiz ID: ' . $id);
            }
            // Ensure form_data is present in edit mode
            $form_data = $this->model_quiz->find_by_pk($id);
        }
        $this->layout_data['selected_categories'] = $selected;
        $this->layout_data['selected_categories_points'] = $selected_categories_points;
        $this->layout_data['form_data'] = $form_data;

        // Merge layout_data into data so categories, selected_categories and form_data are available in the view
        $data = array_merge($data, $this->layout_data);
        return parent::add($id, $data);
    }

    // mtech
    public function get_questions() 
    {
    $quiz_id = $this->input->get('cq_quiz_id');
    $param = array();
    $param['where']['cq_quiz_id'] = $quiz_id;
    $question_data = $this->model_course_quiz->find_all($param);
    
    echo json_encode($question_data);
    }
    
    /**
     * Get a list of quizzes for the assignment modal
     * Used by the Question Bank to assign questions to quizzes
     */
    public function get_quizzes()
    {
        $course_id = $this->input->post('course_id');
        $subject_id = $this->input->post('subject_id');
        
        $params = array();
        $params['where']['quiz_status'] = STATUS_ACTIVE;
        
        // Apply course filter if provided
        if (!empty($course_id)) {
            $params['where']['quiz_course_id'] = $course_id;
        }
        
        // Apply subject filter if provided
        if (!empty($subject_id)) {
            $params['where']['quiz_subject_id'] = $subject_id;
        }
        
        $params['order_by'] = 'quiz_name ASC';
        $quizzes = $this->model_quiz->find_all($params);
        
        $formatted_quizzes = array();
        
        if (!empty($quizzes)) {
            foreach ($quizzes as $quiz) {
                $item = array();
                $item['id'] = $quiz['quiz_id'];
                $item['name'] = $quiz['quiz_name'];
                
                // Get course name
                $course = $this->model_course->find_by_pk($quiz['quiz_course_id']);
                $item['course'] = isset($course['c_title']) ? $course['c_title'] : '';
                
                // Get subject name
                $subject = $this->model_course_subject->find_by_pk($quiz['quiz_subject_id']);
                $item['subject'] = isset($subject['cs_title']) ? $subject['cs_title'] : '';
                
                $formatted_quizzes[] = $item;
            }
        }
        
        echo json_encode(array(
            'status' => true,
            'quizzes' => $formatted_quizzes
        ));
    }

    // Si existe un método edit, lo redirijo a add para asegurar el layout
    public function edit($id = 0)
    {
        // Llama internamente a add para cargar todo el formulario y datos
        return $this->add($id);
    }
    
    /**
     * Configure categories for a quiz
     * @param int $quiz_id Quiz ID
     */
    public function configure_categories($quiz_id = 0)
    {
        $quiz_id = intval($quiz_id);
        if (!$quiz_id) {
            $this->session->set_flashdata('error', 'Invalid quiz ID');
            redirect('admin/quiz');
        }
        
        // Get quiz details
        $quiz = $this->model_quiz->find_by_pk($quiz_id);
        if (!$quiz) {
            $this->session->set_flashdata('error', 'Quiz not found');
            redirect('admin/quiz');
        }
        
        // Load required models
        $this->load->model('Model_quiz_categories');
        $this->load->model('Model_quiz_category_config');
        
        // Add necessary scripts and plugins
        $this->add_script(array("admin/scripts/quiz_categories.js"), 'js');
        $this->register_plugins(array("datatables", "chosen-select"));

        // Process form submission
        if ($this->input->post('submit_config')) {
            // Get category configurations from the form
            $configurations = array();
            
            $num_questions = $this->input->post('num_questions');
            $points_per_question = $this->input->post('points_per_question');
            $random_selection = $this->input->post('random_selection');
            foreach ($this->input->post('categories') as $category_id) {
                if (empty($category_id)) continue;
                $configurations[] = array(
                    'category_id' => $category_id,
                    'num_questions' => isset($num_questions[$category_id]) ? $num_questions[$category_id] : null,
                    'random_selection' => isset($random_selection[$category_id]) ? 1 : 0,
                    'points_per_question' => (isset($points_per_question[$category_id]) && $points_per_question[$category_id] !== '') ? floatval($points_per_question[$category_id]) : null
                );
            }
            
            // Update the configurations
            $result = $this->Model_quiz_category_config->update_configurations($quiz_id, $configurations);
            
            if ($result['success'] > 0) {
                $this->session->set_flashdata('success', 'Quiz category configurations saved successfully');
            } else {
                $this->session->set_flashdata('error', 'No categories were configured');
            }
            
            redirect('admin/quiz/edit/' . $quiz_id);
        }
        
        // Get all available categories for the quiz's course/subject
        $categories = $this->Model_quiz_categories->get_data_active(array(
            'where' => array(
                'qc_course_id' => $quiz['quiz_course_id'],
                'qc_subject_id' => $quiz['quiz_subject_id']
            ),
            'order' => 'qc_name ASC'
        ));
        
        // Get existing category configurations for this quiz
        $existing_configs = $this->Model_quiz_category_config->get_quiz_configurations($quiz_id);
        
        // Prepare data for the view
        $data = array(
            'quiz' => $quiz,
            'categories' => $categories,
            'existing_configs' => $existing_configs,
            'total_questions' => $this->Model_quiz_category_config->count_total_questions($quiz_id)
        );
        
        // Load the view
        $this->layout->view('admin/quiz/configure_categories', $data);
    }
    
    /**
     * Generate quiz questions based on category configuration
     * Used by the quiz system to dynamically generate quizzes
     * @param int $quiz_id Quiz ID
     * @return array Generated questions
     */
    public function generate_quiz_questions($quiz_id)
    {
        $quiz_id = intval($quiz_id);
        if (!$quiz_id) {
            echo json_encode(array('status' => false, 'message' => 'Invalid quiz ID'));
            return;
        }
        
        // Load required model
        $this->load->model('Model_quiz_category_config');
        
        // Get the questions based on category configuration
        $questions = $this->Model_quiz_category_config->generate_quiz_questions($quiz_id);
        
        echo json_encode(array(
            'status' => true,
            'questions' => $questions,
            'count' => count($questions)
        ));
    }
    
    /**
     * Get questions assigned to a specific quiz (AJAX)
     */
    public function get_quiz_questions() {
        error_log('[DEBUG Quiz.php] get_quiz_questions method called!');
        
        $quiz_id = $this->input->post('quiz_id');
        error_log('[DEBUG Quiz.php] Received quiz_id: ' . var_export($quiz_id, true));
        
        if (empty($quiz_id)) {
            echo json_encode(array('status' => false, 'message' => 'Quiz ID required'));
            return;
        }
        
        // Load model
        $this->load->model('model_quiz_questions');
        
        // Get assigned questions with complete data
        $questions = $this->model_quiz_questions->get_quiz_questions($quiz_id);
        error_log('[DEBUG Quiz.php] Raw questions from model: ' . print_r($questions, true));
        
        // Format response for JavaScript
        $formatted_questions = array();
        foreach ($questions as $q) {
            $points = 1.0; // Default
            
            // Logic priority: qq_points (explicit customization) -> qb_gain_point (bank points) -> 1.0 (default)
            if (isset($q['qq_points']) && $q['qq_points'] !== null) {
                // Always use qq_points if it exists (even if it's 1, as it might be explicitly set)
                $points = floatval($q['qq_points']);
            } elseif (isset($q['qb_gain_point']) && $q['qb_gain_point'] !== null && floatval($q['qb_gain_point']) > 0) {
                // Use bank points if no custom points are set
                $points = floatval($q['qb_gain_point']);
            } else {
                // Default fallback
                $points = 1.0;
            }
            
            error_log('[DEBUG Quiz.php] Question ID ' . $q['qb_id'] . ' - qq_points: ' . ($q['qq_points'] ?? 'NULL') . ', qb_gain_point: ' . ($q['qb_gain_point'] ?? 'NULL') . ', final points: ' . $points);
            
            $formatted_questions[] = array(
                'qb_id' => $q['qb_id'],
                'question' => html_entity_decode($q['qb_text']),
                'type' => isset($q['type']) ? $q['type'] : 'N/A',
                'points' => $points,
                'qq_points' => $q['qq_points'] ?? null,
                'qb_gain_point' => $q['qb_gain_point'] ?? null
            );
        }
        
        error_log('[DEBUG Quiz.php] Final formatted response: ' . print_r($formatted_questions, true));
        
        echo json_encode(array(
            'status' => true,
            'questions' => $formatted_questions
        ));
    }
    
    /**
     * Remove a question from a quiz (AJAX)
     */
    public function remove_question_from_quiz() {
        $quiz_id = $this->input->post('quiz_id');
        $question_id = $this->input->post('question_id');
        
        // Validation
        if (empty($quiz_id) || empty($question_id)) {
            echo json_encode(array('status' => false, 'message' => 'Quiz ID and Question ID required'));
            return;
        }
        
        // Load model
        $this->load->model('model_quiz_questions');
        
        // Remove question from quiz
        $result = $this->model_quiz_questions->unassign_question($quiz_id, $question_id);
        
        if ($result) {
            echo json_encode(array('status' => true, 'message' => 'Question removed successfully'));
        } else {
            echo json_encode(array('status' => false, 'message' => 'Failed to remove question'));
        }
    }
    
    /**
     * Update points for a specific question in a quiz
     */
    public function update_question_points() {
        try {
            $quiz_id = $this->input->post('quiz_id');
            $question_id = $this->input->post('question_id');
            $points = $this->input->post('points');
            
            error_log('[DEBUG] update_question_points called with: quiz_id=' . $quiz_id . ', question_id=' . $question_id . ', points=' . $points);
            
            // Validation
            if (empty($quiz_id) || empty($question_id) || empty($points)) {
                echo json_encode(array('status' => false, 'message' => 'Quiz ID, Question ID and Points are required'));
                return;
            }
            
            if (!is_numeric($points) || $points <= 0) {
                echo json_encode(array('status' => false, 'message' => 'Points must be a positive number'));
                return;
            }
            
            // Load model
            $this->load->model('model_quiz_questions');
            
            // Check if question is assigned to this quiz
            $existing = $this->model_quiz_questions->get_question_assignment($quiz_id, $question_id);
            error_log('[DEBUG] Question assignment check: ' . print_r($existing, true));
            
            if (!$existing) {
                echo json_encode(array('status' => false, 'message' => 'Question is not assigned to this quiz'));
                return;
            }
            
            // Update points
            $result = $this->model_quiz_questions->update_question_points($quiz_id, $question_id, $points);
            error_log('[DEBUG] Update result: ' . ($result ? 'SUCCESS' : 'FAILED'));
            
            if ($result) {
                echo json_encode(array('status' => true, 'message' => 'Points updated successfully'));
            } else {
                echo json_encode(array('status' => false, 'message' => 'Failed to update points'));
            }
        } catch (Exception $e) {
            error_log('[ERROR] Exception in update_question_points: ' . $e->getMessage());
            echo json_encode(array('status' => false, 'message' => 'Internal error: ' . $e->getMessage()));
        }
    }
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
