<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Product_size extends MY_Controller {

	/**
	 *
	 * @package		Product_size
	 *
     * @version		1.0 --
     * @since		Version 1.0 2018
	 */

    public $_list_data = array();
    public $product_id;

	public function __construct() {

		global $config;
		
		parent::__construct();

        $this->product_id = isset($_GET['product_id']) ? intval($_GET['product_id']) : 0;

        $this->dt_params['dt_headings'] = "cq_id,cq_question,cq_status";
        $this->dt_params['searchable'] = array("cq_id","cq_question", "cq_status");
        
        $this->dt_params['action'] = array(
        								"hide_add_button" => false ,
                                        "hide" => false ,
                                        "show_delete" => true ,
                                        "show_edit" => true ,
                                        "order_field" => false ,
                                        "show_view" => false ,
                                        "extra" => array() ,
                                      );
        $this->_list_data['cq_status'] = array(
                                        STATUS_INACTIVE => "<span class=\"label label-default\">Inactive</span>" ,
                                        STATUS_ACTIVE =>  "<span class=\"label label-primary\">Active</span>"
                                    );
        // Following are common so, defined in MY_Controller_Admin
		// $this->dt_params['paginate']['class'] = $config['js_config']['ci_class'];
		// $this->dt_params['paginate']['uri'] = "paginate";
		// $this->dt_params['paginate']['update_status_uri'] = "update_status";

		// For use IN JS Files

		$config['js_config']['paginate'] = $this->dt_params['paginate'];


        /*$this->_list_data['cq_page'] = array(
            'home'=>'Home',
            'wireless'=>'Wireless',
            'accessories'=>'Accessories',
            'about_us'=>'About Us',
            'news_info'=>'News & Info',
            'contact_us'=>'Contact Us',
        );*/

		$this->_list_data['pc_product_id'] = $this->model_product->find_all_list_active(array(),"product_name");
        $this->_list_data['pc_size_id'] = $this->model_size->find_all_list_active(array(),"size_name");

        // $param = array();
        // $this->_list_data['cq_product_id'] = $this->model_course->find_all_list_active($param,'course_name');



		$_POST = $this->input->post(NULL, true);
	}


	public function add($id='', $data=array())
	{
        $this->form_data['product_size']['pc_product_id'] = $this->product_id;
        
        if(isset($_POST) AND array_filled($_POST)) {
            $_POST['product_size']['pc_product_id'] = $this->product_id;

            if($id == 0) :
                $dd = $this->model_product_size->already_exist($this->product_id,$_POST['product_size']['pc_size_id']);
                if(isset($dd) AND array_filled($dd)) {
                    redirect(la('product_size/add/'.$dd['pc_id'].'?product_id='.$this->product_id.'&msgtype=error&msg='.urlencode('Already Exist')));
                }
            endif;
        }
        
        
        // When edit record
        parent::add($id, $data);
    }


    public function add_redirect_success($id)
    {
        $sss = false;
        switch($_POST['submit'])
        {
            case "SaveNEdit":
                $path = $this->admin_current.$id;
            break;
            case "SaveNNew":
                $path = $this->admin_current;
            break;
            default:
                $sss = true;
                $path = $this->admin_path;
            break;
        }
        
        if($sss) {
            redirect(la('product/add/'.$this->product_id)."?&msgtype=success&msg=Record updated successfully.", 'refresh');
        }
        else {
            redirect($path."?product_id=".$this->product_id."&msgtype=success&msg=Record updated successfully.", 'refresh');
        }

        exit();
    }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
