<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Product_rating extends MY_Controller {

    /**
     * product page
     *
     *
     * @version		1.0
     * @since		2017
     */

    public $_list_data = array();

    public function __construct() {

        global $config;

        parent::__construct();
        $this->dt_params['dt_headings'] = "pr_id,pr_name,pr_product_id,pr_rating,pr_email,pr_status";
        $this->dt_params['searchable'] = explode(",", $this->dt_params['dt_headings']);
        $this->dt_params['action'] = array(
            "hide_add_button" => false ,
            "hide" => false ,
            "show_delete" => true ,
            "show_edit" => true ,
            "order_field" => false ,
            "show_view" => false ,
            "extra" => array() ,
        );

        $this->_list_data['pr_status'] = array(
            STATUS_INACTIVE => "<span class=\"label label-default\">Inactive</span>" ,
            STATUS_ACTIVE =>  "<span class=\"label label-primary\">Active</span>"
        );

        // For use IN JS Files
        $config['js_config']['paginate'] = $this->dt_params['paginate'];

        // Populating LISTDATA
        //$this->_list_data['product_brand_id'] = $this->model_brand->find_all_list_active(array(),"brand_name");

        //$this->_list_data['pr_product_id'] = $this->model_product->find_all_list_active(array(),"product_name");
        $this->_list_data['pr_product_id'] = $this->model_course->find_all_list_active(array(),"course_title");

        $this->_list_data['pr_user_id'] = $this->model_user->get_user_list_active();

        $this->_list_data['pr_vendor_id'] = $this->model_user->get_user_list_active();
        
        $_POST = $this->input->post(NULL, true);
    }

    public function index()
    {
        // Popluated LISTDATA in constructor
        parent::index();
    }



	// BeforeRender Hook to manipulate Overrides... for INdex Method
	public function before_index_render(&$data=array())
	{
		$data['page_title'] = 'Course Review';

		$this->layout_data['bread_crumbs'] = array(
												array(
													"home/"=>"Home" , 
													'product_rating' => 'Course Review',
												)
											);

		// To access from Child Class
		return true;
	}


	// // BeforeRender Hook to manipulate Overrides... for Add Method
	public function before_add_render(&$data)
	{
		$data['page_title'] = 'Course Review';

		$this->layout_data['bread_crumbs'] = array(
												array(
													"home/"=>"Home" , 
													'product_rating' => 'Course Review',
													"product_rating/add/" => "Add Course Review",
												)
											);


		// To access from Child Class
		return true;
	}
	
	

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */