<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Inquiry extends MY_Controller {

	/**
	 * CSL Achievements page
	 *
	 * @package		inquiry
	 * @author		Muhammad Uzair Khan (Muhammad.Uzair@tradekey.com)
	 * @version		2.0
	 * @since		Version 1.0 2014
	 */

    public $_list_data = array();

	public function __construct() {

		global $config;
		
		parent::__construct();
        $this->dt_params['dt_headings'] = "inquiry_id,inquiry_type,inquiry_name,inquiry_email,inquiry_phone,inquiry_status";
        $this->dt_params['searchable'] = explode(",",$this->dt_params['dt_headings']);//array("inquiry_id","inquiry_name","inquiry_email","inquiry_status");
        $this->dt_params['action'] = array(
										"hide_add_button" => true ,
                                        "hide" => false ,
                                        "order_field" => false ,
                                        "show_view" => true ,
                                        "extra" => array(
              //                           	"add_btn" => '<a title="Ticket" href="'.la('inquiry').'/ticket/%d/"
              //                           				target="_blank"><button class="btn btn-icon-only yellow">
														// <i class="fa fa-edit"></i></button></a>',
                                        	) ,
                                      );
        // Following are common so, defined in MY_Controller_Admin
		// $this->dt_params['paginate']['class'] = $config['js_config']['ci_class'];
		// $this->dt_params['paginate']['uri'] = "paginate";
		// $this->dt_params['paginate']['update_status_uri'] = "update_status";

		// For use IN JS Files

		$config['js_config']['paginate'] = $this->dt_params['paginate'];

		$_POST = $this->input->post(NULL, true);
	}

	public function add($id='', $data=array())
	{
		parent::add($id,$data);
	}

	public function ajax_view($id='')
	{
		if($id)
		{
			$this->model_inquiry->update_by_pk($id, array("inquiry_status" => 0));
		}
		parent::ajax_view($id);
	}


	public function ticket($id='', $data=array())
	{
		if($_POST)
		{
			//debug($_POST);
			//debug($id);exit;
		}
		global $config;
		$id = intval($id);
		$this->configure_add_page();
		$class_name = $this->class_name;//$this->router->class;
		$model_name = 'model_'.$class_name ;
		$model_obj = $this->$model_name ;
		$form_fields = $model_obj->get_fields();
		
		// Prepare models used in this action
		$model_array = array();
		//$model_array = $this->_extra_models_add;
		$model_array[] = $model_name;
		
		$this->_validation_models_add[] = $model_name;
		

		$pk = $model_obj->get_pk() ;

		if($id)
		{

			$params['where'][$pk] = $id;
			$this->form_data[$class_name] = $this->$model_name->find_one($params);
			
			// Load relation fields data
			$this->form_data['relation_data'] = $this->$model_name->get_relation_data($id);

			if(count($this->form_data[$class_name])==0)
			{
				redirect($this->admin_path."?msgtype=error&msg=404+-+Record+not+found.", 'refresh');
				exit();
			}
		}
	
		//$pg_config['order_field'] = $model_obj->get_order_field_name();


		$this->layout_data['bread_crumbs'] = array(
												array(
													"home/"=>"Home" , 
													$class_name => humanize($class_name),
													"#" => "Threading ".humanize($class_name),
												)
											);

		$user_data = $this->input->post(NULL, true);

		$data['form_data'] = (isset($this->form_data))?$this->form_data:array();

		$data['user_input'] = (isset($user_data['login']))?$user_data['login']:array();

		if($_POST)
		{
			//debug($_POST);
			//debug($id);exit;
			//debug($_POST,1);
			if( $this->bulk_validate($this->_validation_models_add) )
			{
				// Validation Successful
				
				$user_data = $_POST[$class_name]  ;
			
				// Merge FILES field with POST DATA
				if( (isset($user_data)) && (is_array($user_data)) && (isset($_FILES[$class_name]['name'])))
					$user_data = $user_data + $_FILES[$class_name]['name'] ;
				

				$this->$model_name->set_attributes($user_data);

				$insertId = $this->$model_name->save();

				if($insertId)
				{
					$this->$model_name->update_relations($insertId);
					$this->afterSave($insertId , $this->$model_name);

					// Prevent Return From Parent Add Method(current), 
					// since we need to perform operations in Child Class's Method
					if($this->prevent_return_on_success)
						return $insertId;

					$this->add_redirect_success($insertId);
				}
				else
				{
					redirect($this->admin_path."?msgtype=error&msg=Couldnt Save Data.", 'refresh');
			 		exit();
				}
			}
			else
			{
				$data['error'] = validation_errors();
			}
			
		}
		
		$data['page_title_min'] = "Management";
		$data['page_title'] = $class_name;
		$data['class_name'] = $class_name;
		$data['model_name'] = $model_name;
		$data['model_obj'] = $model_obj;
		$data['form_fields'][$class_name] = $form_fields;
		$data['dt_params'] = $this->dt_params ;
		$data['id'] = $id; 


		$config_info = $this->model_config->find_by_pk(6);

        if(array_filled($config_info))
            $data['sender_email'] = $config_info['config_value'];
        else
            $data['sender_email'] = 'dalton.developer@gmail.com';

		$param = array();
		$param['joins'][] = array(
                "table"=>"user" , 
                "joint"=>"user.user_id = inquiry.inquiry_user_id",
                );
		$data['inquiry_data'] = $this->model_inquiry->find_by_pk($id,false,$param);
		
		$param = array();
		$param['where']['it_inquiry_id'] = $id;
		$param['order'] = "it_id DESC";
		$data['threading_data'] = $this->model_inquiry_threading->find_all($param);

		$this->load_view("ticket",$data);
	}
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
