<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Grading_settings extends MY_Controller {

    public function __construct() {
        parent::__construct();
        // Load the model
        $this->load->model('Model_grading_settings');
    }

    // Display the form to create or update grading settings for a course
    public function create($course_id = NULL) {
        $response = [];  // Create a response array
    
        if ($this->input->post()) {
            // Collect form data
            $grading_data = [
                'course_id' => $course_id,
                'grading_system' => $this->input->post('grading_system'),
                'pass_percentage' => $this->input->post('pass_percentage'),
                'grade_a_percentage' => $this->input->post('grade_a_percentage'),
                'grade_b_percentage' => $this->input->post('grade_b_percentage'),
                'grade_c_percentage' => $this->input->post('grade_c_percentage'),
                'grade_d_percentage' => $this->input->post('grade_d_percentage'),
                'grade_f_percentage' => $this->input->post('grade_f_percentage'),
                'gpa_1_percentage' => $this->input->post('gpa_1_percentage'),
                'gpa_2_percentage' => $this->input->post('gpa_2_percentage'),
                'gpa_3_percentage' => $this->input->post('gpa_3_percentage'),
                'gpa_4_percentage' => $this->input->post('gpa_4_percentage'),
                'custom_grades' => json_encode($this->input->post('custom_grades'))
            ];
    
            // Insert or update grading settings
            if ($this->Model_grading_settings->create_or_update_grading_settings($grading_data, $course_id)) {
                $response['status'] = true;
                $response['message'] = 'Grading settings saved successfully.';
            } else {
                $response['status'] = false;
                $response['message'] = 'Failed to save grading settings.';
            }
        }
    
        // If course_id is provided, or you want to edit existing settings, fetch them
        if ($course_id) {
            $grading_settings = $this->Model_grading_settings->get_grading_settings($course_id);
            $response['grading_settings'] = $grading_settings;  // Include grading settings in the response
        } else {
            $response['grading_settings'] = null;  // No settings if course_id is NULL
        }
    
        // Return the response as JSON
        echo json_encode($response);
    }


    // View the grading settings for a particular course
    public function view($course_id) {
        $grading_settings = $this->Model_grading_settings->get_grading_settings($course_id);
        
        if (!$grading_settings) {
            $this->session->set_flashdata('error', 'No grading settings found for this course.');
            redirect('courses');
        }

        // Pass data to view
        echo json_encode($grading_settings);
        // $this->load->view('grading_settings/view', ['grading_settings' => $grading_settings]);
    }

    // Delete grading settings for a course
    // public function delete($course_id) {
    //     if ($this->Model_grading_settings->delete_grading_settings($course_id)) {
    //         $this->session->set_flashdata('success', 'Grading settings deleted successfully.');
    //     } else {
    //         $this->session->set_flashdata('error', 'Failed to delete grading settings.');
    //     }
    //     redirect('courses');
    // }
}
