<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Grade extends MY_Controller {

	/**
	 *
	 * @package		Quiz
	 *
     * @version		1.0 --
     * @since		Version 1.0 2018
	 */

    public $_list_data = array();
    public $course_id;

	public function __construct() {

		global $config;
		
		parent::__construct();

        $this->dt_params['dt_headings'] = "grade_id,grade_user_id,grade_course_id,grade_subject_id,grade_type,grade_assignment_id,grade_quiz_id,grade_marks,grade_total_marks,grade_percentage,grade_status";
                                            
        $this->dt_params['searchable'] = explode(",", $this->dt_params['dt_headings']);
    
        $this->dt_params['action'] = array(
        								"hide_add_button" => false ,
                                        "hide" => false ,
                                        "show_edit" => false ,
                                        "order_field" => false ,
                                        "show_view" => false ,
                                        // "extra" => array(
                                        //     "add_btn" =>'<a title="Release Grade" href="#"'.
                                        //                 'class="btn-icon-only green releasegrade" data-grade="%d">'.
                                        //                 '<i class="fa fa-check"></i></a>' ,
                                        //     ) ,
                                        "show_delete" => false ,
                                      );

        $this->_list_data['grade_status'] = array(
                                        STATUS_INACTIVE => "<span class=\"label label-default\">Not Released</span>" ,
                                        STATUS_ACTIVE =>  "<span class=\"label label-primary\">Released</span>",
                                    );
      
        // Following are common so, defined in MY_Controller_Admin
		// $this->dt_params['paginate']['class'] = $config['js_config']['ci_class'];
		// $this->dt_params['paginate']['uri'] = "paginate";
		// $this->dt_params['paginate']['update_status_uri'] = "update_status";

		// For use IN JS Files

		$config['js_config']['paginate'] = $this->dt_params['paginate'];
        
        
        $param = array();

        $this->_list_data['grade_course_id'] = $this->model_course->find_all_list_active($param,'course_title');

        $this->_list_data['grade_subject_id'] = $this->model_course_subject->find_all_list_active($param,'course_subject_name');
    
        $this->_list_data['grade_user_id'] = $this->model_user->find_all_list_active($param,'user_firstname');
    
        $this->_list_data['grade_assignment_id'] = $this->model_assignment->find_all_list_active($param,'assignment_title');
      
        $this->_list_data['grade_quiz_id'] = $this->model_quiz->find_all_list_active($param,'quiz_name');

		$_POST = $this->input->post(NULL, true);
	}
	
   
    public function get_list()
    {
        $data['page_title'] = 'Course';
        $data['page_title_min'] = 'Details';
        $id = $this->input->post("search_val"); 
        $param['fields'] = "course_subject_id,course_subject_name";
        $param['where']['course_subject_course_id'] = $id ;
        $data = $this->_list_data['grade_subject_id'] = $this->model_course_subject->find_all_active($param);
        echo json_encode($data);
    }
    
    public function gradebook($course_id) {
        //  $this->register_plugins(array("datatables"));
        $this->configure_add_page();
        $this->load->model('model_grade');
        $this->load->model('Model_grading_settings');
        $data = $this->model_grade->getGradebook($course_id);
        $data['page_title'] = 'Course';
        $data['course_id'] = $course_id;
        $param = array();
        $param['where']['course_id'] = $course_id;
        $data['gradesetting'] = $this->model_grade_setting->find_all($param);
        $data['grading_settings'] = $this->Model_grading_settings->get_grading_settings($course_id);
        if (empty($data['grading_settings'])) {
            // Set default grading settings if not found
            $data['grading_settings'] = [
                'grading_system' => 'pass_fail', // or other default system
                'pass_percentage' => 33,         // Example default pass percentage
                'grade_a_percentage' => NULL,      // Example default thresholds for letter grading
                'grade_b_percentage' => NULL,
                'grade_c_percentage' => NULL,
                'grade_d_percentage' => NULL,
                'grade_f_percentage' => NULL,
                'gpa_1_percentage' => NULL,
                'gpa_2_percentage' => NULL,
                'gpa_3_percentage' => NULL,
                'gpa_4_percentage' => NULL,
                'custom_grades' => NULL
            ];
        }
        $data['settingid'] = $gradesetting[0]['grade_setting_id'];
        $data['page_title_min'] = 'Gradebook';
        $this->load_view('gradebook_view', $data);
    }
    
    public function get_student_grade($percentage, $grading_settings) {

    $grading_system = $grading_settings['grading_system'];
    
    switch ($grading_system) {
        case 'pass_fail':

            return ($percentage >= $grading_settings['pass_percentage']) ? 'Pass' : 'Fail';

        case 'letter_grade':

            if ($percentage >= $grading_settings['grade_a_percentage']) {
                return 'A';
            } elseif ($percentage >= $grading_settings['grade_b_percentage']) {
                return 'B';
            } elseif ($percentage >= $grading_settings['grade_c_percentage']) {
                return 'C';
            } elseif ($percentage >= $grading_settings['grade_d_percentage']) {
                return 'D';
            } else {
                return 'F';
            }

        case 'gpa':
    
            if ($percentage >= $grading_settings['gpa_4_percentage']) {
                return '4.0';
            } elseif ($percentage >= $grading_settings['gpa_3_percentage']) {
                return '3.0';
            } elseif ($percentage >= $grading_settings['gpa_2_percentage']) {
                return '2.0';
            } elseif ($percentage >= $grading_settings['gpa_1_percentage']) {
                return '1.0';
            } else {
                return '0.0'; 
            }

        case 'custom':

            $custom_grades = json_decode($grading_settings['custom_grades'], true);
            foreach ($custom_grades as $grade => $threshold) {
                if ($percentage >= $threshold) {
                    return $grade;
                }
            }
            return 'No Grade'; 
    }

    return 'Invalid grading system';
}

    
    public function getGradeData($course_id) {
        $this->load->model('model_grade');
        $data = $this->model_grade->getGradebook($course_id);
       
        $jsonData = json_encode($data);
    
        // Check if encoding failed and handle the error
        if (json_last_error() !== JSON_ERROR_NONE) {
            // Log the error or print the error message for debugging
            echo json_last_error_msg();  // This will print the error
            return;
        }
    
        // Return the encoded data
        echo $jsonData;
    }

    public function add($id=0 , $data = array())
    {
        $this->register_plugins(array("datatables","flag_sprites"));
        
        $insertId = parent::add($id,$data);

    }
    
    // public function release(){
      
    //     $gradeid = $_POST['grade_id'];
       
    //     $param = array();
    //     $param['grade_status'] = 1;
    //     $this->model_grade->update_by_pk($gradeid,$param);
        
    //     $this->json_param['status'] = true;
    //     $this->json_param['message'] = 'Grade is released for all student(s).';
    //     echo json_encode($this->json_param);
    // }
    
   public function release() {

    if (isset($_POST['grade_related_id']) && is_numeric($_POST['grade_related_id'])) {
        $graderelatedid = intval($_POST['grade_related_id']);
        $gradetype = intval($_POST['grade_type']);
        
        $param = array(
            'where' => array(
                'grade_related_id' => $graderelatedid,
                'grade_type' => $gradetype
            )
        );

        $currentGrades = $this->model_grade->find_all($param);
        
        $successCount = 0;
        $failureCount = 0;

        foreach ($currentGrades as $currentGrade) {
       
            if ($currentGrade) {
                $newStatus = ($currentGrade['grade_status'] == 1) ? 0 : 1;

                $updateParam = [
                    'grade_status' => $newStatus
                ];

                $updateResult = $this->model_grade->update_by_pk($currentGrade['grade_id'], $updateParam); 
                if ($updateResult) {
                    $successCount++;
                } else {
                    $failureCount++;
                }
            }
        }

        if ($successCount > 0) {
            $this->json_param = [
                'status' => true,
                'message' => "$successCount grade(s) status updated successfully." . ($failureCount > 0 ? " $failureCount update(s) failed." : "")
            ];
        } else {
            $this->json_param = [
                'status' => false,
                'message' => 'No grades were updated.'
            ];
        }
    } else {
        $this->json_param = [
            'status' => false,
            'message' => 'Invalid grade ID provided.'
        ];
    }
    echo json_encode($this->json_param);
}

    
    public function grade_setting(){
    
       
       if($_POST['grade_setting_id'] != null){

        $param = array();
        $param['missing_percentage_status'] = $_POST['missing_percentage_status']; 
        $param['missing_percentage'] = $_POST['missing_percentage']; 
        $param['course_id'] = $_POST['course_id'];
        $param['late_percentage'] = $_POST['late_percentage']; 
        $param['late_percentage_status'] = $_POST['late_percentage_status']; 
        
        $_POST['missing_percentage'] = ($_POST['missing_percentage_status'] !== 0 ? $_POST['missing_percentage'] : NULL );
        $_POST['late_percentage'] = ( $_POST['late_percentage_status']  !== 0 ? $_POST['late_percentage'] : NULL );
       
        $this->model_grade_setting->update_by_pk($_POST['grade_setting_id'],$_POST);
           
       }else{
            $data = array();
            $data = $_POST;
            unset($data['grade_setting_id']);
            $this->model_grade_setting->set_attributes($data);
            $inserted_id = $this->model_grade_setting->save();
       }
       
        
        $this->json_param['status'] = true;
        $this->json_param['txt'] = 'Grade Settings Updated!';
        echo json_encode($this->json_param);
    }
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
