<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Course_quiz_question extends MY_Controller {

	/**
	 *
	 * @package		Course Quiz Question
	 *
     * @version		1.0 --
     * @since		Version 1.0 2025
	 */

    public $_list_data = array();

	public function __construct() {

		global $config;
		
		parent::__construct();

        // Configurar tabla y modelo
        $this->table_name = "tn_course_quiz";
        $this->model_obj = $this->model_course_quiz;

        $this->dt_params['dt_headings'] = "cq_id,cq_quiz_id,cq_question,cq_gain_point,cq_is_bonus,cq_bonus_points,cq_status";
        $this->dt_params['searchable'] = explode(",", $this->dt_params['dt_headings']);
        
        $this->dt_params['action'] = array(
        							"hide_add_button" => false,
                                        "hide" => false,
                                        "show_delete" => true,
                                        "show_edit" => true,
                                        "order_field" => false,
                                        "show_view" => false,
                                        "width" => "11%",
                                        "extra" => array(),
                                      );

		// Cargar modelos adicionales
		$this->load->model('model_quiz');
		$this->load->model('model_course');
		$this->load->model('model_course_subject');

		// Cargar datos para dropdowns
		$param = array();
		$this->_list_data['cq_quiz_id'] = $this->model_quiz->find_all_list_active($param,'quiz_name');

		$param = array();
		$this->_list_data['cq_course_id'] = $this->model_course->find_all_list_active($param,'course_title');

		$param = array();
		$this->_list_data['cq_subject_id'] = $this->model_course_subject->find_all_list_active($param,'course_subject_name');

		$this->_list_data['status'] = array(
			'1' => '<span class="label label-success">Active</span>',
			'0' => '<span class="label label-danger">Inactive</span>',
		);

		$this->_list_data['cq_is_bonus'] = array(
			'1' => '<span class="label label-info">Su00ed</span>',
			'0' => '<span class="label label-default">No</span>',
		);

		$_POST = $this->input->post(NULL, true);
	}

	public function index()
	{
		// Generar breadcrumbs
		$this->breadcrumbs->push("Preguntas de Quiz", base_url().'admin/course_quiz_question');

		$this->layout_data["page_title"] = "Preguntas de Quiz";
		$this->layout_data["module_title"] = "Preguntas de Quiz";

		// Renderizar la vista principal
		$this->_list();
	}

	/**
	 * Agregar una nueva pregunta
	 *
	 * @param int $quiz_id ID del quiz (opcional)
	 */
	public function add($quiz_id = 0)
	{
		// Generar breadcrumbs
		$this->breadcrumbs->push("Preguntas de Quiz", base_url().'admin/course_quiz_question');
		$this->breadcrumbs->push("Agregar Pregunta", base_url().'admin/course_quiz_question/add');

		$data = array();
		$data['quiz_id'] = $quiz_id;
		$data['question_types'] = array(
			'single' => 'Selecciu00f3n u00danica',
			'multiple' => 'Selecciu00f3n Mu00faltiple'
		);
		
		$this->layout_data["page_title"] = "Agregar Pregunta de Quiz";
		$this->layout_data["module_title"] = "Agregar Pregunta de Quiz";
		$this->layout_data["additional_tools"] = array('switchery');
		
		$this->load_view('form_question', $data);
	}

	/**
	 * Editar una pregunta existente
	 *
	 * @param int $id ID de la pregunta
	 */
	public function edit($id)
	{
		// Generar breadcrumbs
		$this->breadcrumbs->push("Preguntas de Quiz", base_url().'admin/course_quiz_question');
		$this->breadcrumbs->push("Editar Pregunta", base_url().'admin/course_quiz_question/edit/' . $id);

		$data = array();
		$data['question'] = $this->model_course_quiz->find_by_pk($id);
		$data['quiz_id'] = $data['question']->cq_quiz_id;
		$data['question_types'] = array(
			'single' => 'Selecciu00f3n u00danica',
			'multiple' => 'Selecciu00f3n Mu00faltiple'
		);

		$this->layout_data["page_title"] = "Editar Pregunta de Quiz";
		$this->layout_data["module_title"] = "Editar Pregunta de Quiz";
		$this->layout_data["additional_tools"] = array('switchery');
		
		$this->load_view('form_question', $data);
	}

	/**
	 * Guardar pregunta de quiz
	 */
	public function save_question()
	{
		$question = $this->input->post('question');
		
		if (!$question) {
			redirect('admin/course_quiz_question', 'refresh');
		}

		// Preparar datos para guardar
		$save_data = array();
		$save_data['cq_quiz_id'] = $question['cq_quiz_id'];
		$save_data['cq_course_id'] = $this->model_quiz->get_course_id($question['cq_quiz_id']);
		$save_data['cq_subject_id'] = $this->model_quiz->get_subject_id($question['cq_quiz_id']);
		$save_data['cq_type'] = $question['cq_type'];
		$save_data['cq_question'] = htmlentities($question['cq_question']);
		$save_data['cq_gain_point'] = floatval($question['cq_gain_point']);
		$save_data['cq_status'] = 1;

		// Campos para bonus
		$save_data['cq_is_bonus'] = isset($question['cq_is_bonus']) ? intval($question['cq_is_bonus']) : 0;
		$save_data['cq_bonus_points'] = ($save_data['cq_is_bonus'] == 1 && isset($question['cq_bonus_points'])) ? 
			floatval($question['cq_bonus_points']) : 0;

		// Opciones de respuesta
		for ($i = 1; $i <= 6; $i++) {
			if (isset($question['cq_option'][$i]) && !empty($question['cq_option'][$i])) {
				$save_data['cq_option_' . $i] = $question['cq_option'][$i];
			} else {
				$save_data['cq_option_' . $i] = '';
			}
		}

		// Respuestas correctas
		if (isset($question['cq_correct_answer']) && !empty($question['cq_correct_answer'])) {
			if (is_array($question['cq_correct_answer'])) {
				$save_data['cq_correct_answer'] = implode(',', $question['cq_correct_answer']);
			} else {
				$save_data['cq_correct_answer'] = $question['cq_correct_answer'];
			}
		} else {
			$save_data['cq_correct_answer'] = '';
		}

		// Guardar o actualizar
		if (isset($question['cq_id']) && !empty($question['cq_id'])) {
			// Actualizar
			$where = array('cq_id' => $question['cq_id']);
			$this->model_course_quiz->update_model(array('where' => $where), $save_data);
			$this->session->set_flashdata('success', 'Pregunta actualizada correctamente');
		} else {
			// Crear nueva
			$this->model_course_quiz->set_attributes($save_data);
			$this->model_course_quiz->save();
			$this->session->set_flashdata('success', 'Pregunta creada correctamente');
		}

		redirect('admin/course_quiz/edit/' . $question['cq_quiz_id'], 'refresh');
	}

	/**
	 * Ver preguntas de un quiz especu00edfico
	 *
	 * @param int $quiz_id ID del quiz
	 */
	public function view_quiz_questions($quiz_id)
	{
		// Generar breadcrumbs
		$this->breadcrumbs->push("Quices", base_url().'admin/quiz');
		$this->breadcrumbs->push("Preguntas de Quiz", base_url().'admin/course_quiz_question/view_quiz_questions/' . $quiz_id);

		$quiz = $this->model_quiz->find_by_pk($quiz_id);
		if (!$quiz) {
			redirect('admin/quiz', 'refresh');
		}

		// Paru00e1metros para obtener preguntas
		$params = array(
			'where' => array(
				'cq_quiz_id' => $quiz_id,
				'cq_status' => 1
			),
			'order' => 'cq_id ASC'
		);

		$data = array();
		$data['quiz'] = $quiz;
		$data['questions'] = $this->model_course_quiz->find_all_active($params);

		$this->layout_data["page_title"] = "Preguntas del Quiz: " . $quiz->quiz_name;
		$this->layout_data["module_title"] = "Preguntas del Quiz";
		
		$this->load_view('view_quiz_questions', $data);
	}

	/**
	 * CALLBACK PARA RENDERIZAR EN TABLA
	 */
	public function _callback_format_data($field_data, $field_name, $rec)
	{
		if($field_name=='cq_quiz_id') {
			$quiz = $this->model_quiz->find_by_pk($rec[$field_name]);
			return $quiz ? $quiz->quiz_name : '';
		}
		elseif($field_name=='cq_course_id') {
			$course = $this->model_course->find_by_pk($rec[$field_name]);
			return $course ? $course->course_title : '';
		}
		elseif($field_name=='cq_subject_id') {
			$subject = $this->model_course_subject->find_by_pk($rec[$field_name]);
			return $subject ? $subject->course_subject_name : '';
		}
		elseif($field_name=='cq_question') {
			return html_entity_decode(mb_substr($field_data, 0, 50)) . (mb_strlen($field_data) > 50 ? '...' : '');
		}
		elseif($field_name=='cq_is_bonus') {
			return $field_data==1 ? "<span class='label label-info'>Su00ed</span>" : "<span class='label label-default'>No</span>";
		}
		elseif($field_name=='cq_gain_point' || $field_name=='cq_bonus_points') {
			return number_format($field_data, 1);
		}
		elseif($field_name=='cq_status') {
			return $field_data==1 ? "<span class='label label-success'>Active</span>" : "<span class='label label-danger'>Inactive</span>";
		}
		else {
			return $field_data;
		}
	}
}

/* End of file Course_quiz_question.php */
/* Location: ./application/controllers/admin/Course_quiz_question.php */
