<?php
if (!defined('BASEPATH'))
	exit('No direct script access allowed');

class Course_quiz extends MY_Controller {

	/**
	 *
	 * @package		Course_quiz
	 *
     * @version		1.0 --
     * @since		Version 1.0 2018
	 */

    public $_list_data = array();
    public $course_id;

	public function __construct() {

		global $config;
		
		parent::__construct();

        $this->course_id = isset($_GET['course_id']) ? intval($_GET['course_id']) : 0;

        $this->dt_params['dt_headings'] = "cq_id,cq_course_id,cq_question,cq_status";
        $this->dt_params['searchable'] = array("cq_id","cq_course_id","cq_question", "cq_status");
        
        $this->dt_params['action'] = array(
        								"hide_add_button" => false ,
                                        "hide" => false ,
                                        "show_delete" => true ,
                                        "show_edit" => true ,
                                        "order_field" => false ,
                                        "show_view" => false ,
                                        "extra" => array() ,
                                      );
        $this->_list_data['cq_status'] = array(
                                        STATUS_INACTIVE => "<span class=\"label label-default\">Inactive</span>" ,
                                        STATUS_ACTIVE =>  "<span class=\"label label-primary\">Active</span>"
                                    );
        // Following are common so, defined in MY_Controller_Admin
		// $this->dt_params['paginate']['class'] = $config['js_config']['ci_class'];
		// $this->dt_params['paginate']['uri'] = "paginate";
		// $this->dt_params['paginate']['update_status_uri'] = "update_status";

		// For use IN JS Files

		$config['js_config']['paginate'] = $this->dt_params['paginate'];


        /*$this->_list_data['cq_page'] = array(
            'home'=>'Home',
            'wireless'=>'Wireless',
            'accessories'=>'Accessories',
            'about_us'=>'About Us',
            'news_info'=>'News & Info',
            'contact_us'=>'Contact Us',
        );*/

		//$this->_list_data['cq_category_id'] = $this->model_category->find_all_list_active(array(),"category_name");
		//$this->_list_data['cq_product_id'] = $this->model_product->find_all_list_active(array(),"product_name");

        $param = array();
        $this->_list_data['cq_course_id'] = $this->model_course->find_all_list_active($param,'course_title');

        $param = array();
        $this->_list_data['cq_quiz_id'] = $this->model_quiz->find_all_list_active($param,'quiz_name');

        //$this->_list_data['cq_subject_id'] = $this->_get_subject_list();

        $this->_list_data['cq_correct_answer'] = array(
            '1'=>'Option # 1',
            '2'=>'Option # 2',
            '3'=>'Option # 3',
            '4'=>'Option # 4',
            //'5'=>'Option # 5',
        );

		$_POST = $this->input->post(NULL, true);
	}


    public function get_list()
    {
        $id = $this->input->post("search_val"); 
        $param['fields'] = "course_subject_id,course_subject_name";
        $param['where']['course_subject_course_id'] = $id ;
        $data = $this->_list_data['cq_subject_id'] = $this->model_course_subject->find_all_active($param);
        echo json_encode($data);
    }


	public function addnew($id='', $data=array())
	{
        // $this->form_data['course_quiz']['cq_course_id'] = $this->course_id;
        
        // if(isset($_POST) AND array_filled($_POST)) {
        //     $_POST['course_quiz']['cq_course_id'] = $this->course_id;
        // }
        

        $this->configure_add_page();
        $this->load_view("_form_new", $data);
    }


    // 05/12/2023
    public function addquiz(){
        $data = $json_param = array();
        $data['index'] = $index = $this->input->post('index');
        $data['quiz_id'] = $quiz_id = $this->input->post('quiz_id');
        // Use new question type source if available
        $this->load->model('model_question_bank');
        $data['question_type'] = $this->model_question_bank->question_type();
        $data['courses'] = $this->model_course->find_all_list_active(array(),'course_title');
        $data['quiz_data'] = $this->model_quiz->find_by_pk($quiz_id);
        $json_param['html'] = $this->load->view("admin/course_quiz/_quiz",$data,true);
        $json_param['status'] = true;
        $json_param['nextindex'] = $index+1;
        echo json_encode($json_param);
    }

    public function get_subject_list()
    {
        $list = array();
        $param = array();
        $param['where']['course_subject_course_id'] = $this->input->post('course_id');
        $lists = $this->model_course_subject->find_all_active($param);
        if(isset($lists) AND array_filled($lists))
        {
            $i=0;
            foreach($lists as $value)
            {
                $list[$i]['ITEMID'] = $value['course_subject_id'];
                $list[$i]['ITEMDESC'] = $value['course_subject_name'];
                $i++;
            }
        }

        echo json_encode($list);
        // $json_param = array();
        // $json_param[] = $list;
        //return $list;
    }
    public function get_assignment_group_list()
    {
        $list = array();
        $param = array();
        $param['where']['assignment_group_course_id'] = $this->input->post('course_id');
        $lists = $this->model_assignment_group->find_all_active($param);
        if(isset($lists) AND array_filled($lists))
        {
            $i=0;
            foreach($lists as $value)
            {
                $list[$i]['ITEMID'] = $value['assignment_group_id'];
                $list[$i]['ITEMDESC'] = $value['assignment_group_name'];
                $i++;
            }
        }

        echo json_encode($list);
        // $json_param = array();
        // $json_param[] = $list;
        //return $list;
    }


    public function ajax_save_question(){
        $post = isset($_POST['question_bank']) ? $_POST['question_bank'] : array();
        $quiz_questions = isset($_POST['quiz_questions']) ? $_POST['quiz_questions'] : array();
            $this->load->model('model_question_bank');
        $this->load->model('model_quiz_questions');
        $saved_qb_ids = array();
        foreach($post as $index => $qb_data) {
            // Prepare options and correct answer
            if (isset($qb_data['qb_options']) && is_array($qb_data['qb_options'])) {
                $qb_data['qb_options'] = json_encode(array_values($qb_data['qb_options']));
                    }
            if (isset($qb_data['qb_correct_answer']) && is_array($qb_data['qb_correct_answer'])) {
                $qb_data['qb_correct_answer'] = implode(',', $qb_data['qb_correct_answer']);
            }
            // Save or update question in question_bank
                    $qb_id = $this->model_question_bank->save_question($qb_data);
            $saved_qb_ids[$index] = $qb_id;
        }
        // Now assign questions to quiz
        foreach($quiz_questions as $index => $qq_data) {
            $qq_data['qq_question_id'] = isset($saved_qb_ids[$index]) ? $saved_qb_ids[$index] : null;
            if ($qq_data['qq_question_id'] && isset($qq_data['qq_quiz_id'])) {
                $qq_data['qq_status'] = 1;
                $this->model_quiz_questions->assign_question($qq_data['qq_quiz_id'], $qq_data['qq_question_id'], $qq_data);
            }
        }
        // Redirect back to quiz edit page
        $quiz_id = isset($quiz_questions[0]['qq_quiz_id']) ? $quiz_questions[0]['qq_quiz_id'] : 0;
        $this->admin_path = 'admin/quiz/add/'.$quiz_id;
        redirect($this->admin_path."?msgtype=success&msg=Record updated successfully.", 'refresh');
        die();
    }


    public function add_redirect_success($id)
    {
        $quiz_id = isset($_POST['course_quiz']['cq_quiz_id']) ? $_POST['course_quiz']['cq_quiz_id'] : 0;
        switch($_POST['submit'])
        {
            case "SaveNEdit":
                $path = $this->admin_current.$id;
            break;
            case "SaveNNew":
                $path = $this->admin_current;
            break;
            default:
                $path = $this->admin_path;
            break;
        }
        $path = 'admin/quiz/add/'.$quiz_id;
        redirect($path."?msgtype=success&msg=Record updated successfuly.", 'refresh');
        return $id;
    }


    public function ajax_delete_question()
    {
      if(intval($this->input->post('id')) > 0) {
        $id = $this->input->post('id');
        $this->model_course_quiz->delete_by_pk($id);
        $json_param = array();
        $json_param['status'] = true;
        echo json_encode($json_param);
      }
    }
    
    /**
     * Import questions to a quiz from the question bank
     * Accepts JSON data with array of question IDs to import
     */
    public function ajax_import_quizes()
    {
        $rawData = file_get_contents("php://input");
        $data = json_decode($rawData, true);
        if (isset($data['questions'])) {
            $questions = $data['questions'];
            if (!is_array($questions)) {
                echo json_encode(['status' => false, 'message' => 'Invalid input data']);
                return;
            }
            $this->load->model('model_question_bank');
            $this->load->model('model_quiz_questions');
            $success_count = 0;
            $error_count = 0;
            $error_details = array();
            foreach ($questions as $question) {
                $quiz_id = $question['quiz_id'];
                $question_id = $question['question_id'];
                // Buscar la pregunta en el banco de preguntas
                $qb = $this->model_question_bank->find_by_pk($question_id);
                if (!$qb) {
                    $error_count++;
                    $error_details[] = [
                        'question_id' => $question_id,
                        'reason' => 'not_found',
                        'message' => 'Question not found in question bank.'
                    ];
                    continue;
                        }
                $qb_id = $qb['qb_id'];
                // Verificar si ya está asignada
                $existing = $this->model_quiz_questions->db->where('qq_quiz_id', $quiz_id)
                    ->where('qq_question_id', $qb_id)
                    ->get('tn_quiz_questions')
                    ->row();
                if ($existing) {
                        $error_count++;
                    $error_details[] = [
                            'question_id' => $question_id,
                            'reason' => 'already_assigned',
                            'message' => 'Question already assigned to this quiz.'
                    ];
                        continue;
                    }
                // Asignar en tn_quiz_questions
                $result = $this->model_quiz_questions->assign_question($quiz_id, $qb_id);
                if ($result) {
                        $success_count++;
                } else {
                    $error_count++;
                    $error_details[] = [
                        'question_id' => $question_id,
                        'reason' => 'save_error',
                        'message' => 'Failed to assign question to quiz.'
                    ];
                }
            }
            $json_param = array();
            $json_param['status'] = ($success_count > 0);
            $json_param['success_count'] = $success_count;
            $json_param['error_count'] = $error_count;
            $json_param['errors'] = $error_details;
            $json_param['message'] = "Successfully assigned $success_count questions. Failed to assign $error_count questions.";
            echo json_encode($json_param);
            return;
        }
        echo json_encode(['status' => false, 'message' => 'No questions provided']);
    }


    /**
     * Add a single question to a quiz
     */
    public function ajax_add_quizes()
    {
        $json_param = array();
        $quiz_id = $this->input->post('quiz_id');
        $question_id = $this->input->post('question_id');
        $table_name = $this->input->post('table_name');

        $model_name = 'model_'.$table_name;
        $model_obj = $this->$model_name;

        $quiz_data = $model_obj->find_by_pk($question_id);
        
        if(isset($quiz_data) AND !empty($quiz_data))
        {
            // --- 1. Verificar/crear en question_bank ---
            $this->load->model('model_question_bank');
            $qb_search = array(
                'qb_text' => trim(html_entity_decode($quiz_data['cq_question'])),
                'qb_type' => $quiz_data['cq_type'],
                'qb_course_id' => $quiz_data['cq_course_id'],
                'qb_subject_id' => $quiz_data['cq_subject_id'],
                'qb_status' => 1
            );
            $this->db->where($qb_search);
            $existing_qb = $this->db->get('question_bank')->row_array();
            if ($existing_qb) {
                $qb_id = $existing_qb['qb_id'];
            } else {
                $qb_data = array(
                    'qb_text' => trim(html_entity_decode($quiz_data['cq_question'])),
                    'qb_type' => $quiz_data['cq_type'],
                    'qb_course_id' => $quiz_data['cq_course_id'],
                    'qb_subject_id' => $quiz_data['cq_subject_id'],
                    'qb_status' => 1,
                    'qb_is_bonus' => isset($quiz_data['cq_is_bonus']) ? $quiz_data['cq_is_bonus'] : 0,
                    'qb_gain_point' => isset($quiz_data['cq_gain_point']) ? $quiz_data['cq_gain_point'] : 0,
                );
                // Opciones
                $qb_options = array();
                for ($i = 1; $i <= 6; $i++) {
                    if (isset($quiz_data['cq_option_' . $i]) && !empty($quiz_data['cq_option_' . $i])) {
                        $qb_options[] = $quiz_data['cq_option_' . $i];
                    }
                }
                if (!empty($qb_options)) {
                    $qb_data['qb_options'] = json_encode($qb_options);
                }
                if (isset($quiz_data['cq_correct_answer'])) {
                    $qb_data['qb_correct_answer'] = $quiz_data['cq_correct_answer'];
                }
                $qb_id = $this->model_question_bank->save_question($qb_data);
            }
            // --- 2. Verificar si ya está asignada al quiz ---
            $exists_param = array();
            $exists_param['where']['cq_quiz_id'] = $quiz_id;
            $exists_param['where']['cq_question'] = $quiz_data['cq_question'];
            $exists = $this->model_course_quiz->find_one($exists_param);
            if ($exists) {
                // Question already exists in this quiz
                $json_param['status'] = false;
                $json_param['message'] = 'This question is already added to the selected quiz.';
                $json_param['errors'] = array(
                    array(
                        'question_id' => $question_id,
                        'reason' => 'already_assigned',
                        'message' => 'Question already assigned to this quiz.'
                    )
                );
                echo json_encode($json_param);
                return;
            }
            unset($quiz_data['cq_id']);
            unset($quiz_data['cq_createdon']);
            $data = $quiz_data;
            $data['cq_quiz_id'] = $quiz_id;
            $data['cq_question_bank_id'] = $qb_id;
            $model_obj->set_attributes($data);
            if ($model_obj->save()) {
                $json_param['status'] = true;
                $json_param['message'] = 'Question successfully added to quiz.';
            } else {
                $json_param['status'] = false;
                $json_param['message'] = 'Failed to save question.';
            }
        }
        else
        {
            $json_param['status'] = false;
            $json_param['message'] = 'Question not found.';
        }

        echo json_encode($json_param);
    }
    
    /**
     * Get question bank data for the DataTable
     * Handles filtering, searching, and pagination
     */
    public function get_question_bank_data()
    {
        // Manejo de errores para asegurar una respuesta JSON válida incluso en caso de error
        try {
            // Process DataTables request parameters
            $draw = intval($this->input->post('draw'));
            $start = intval($this->input->post('start'));
            $length = intval($this->input->post('length'));
            $search = isset($this->input->post('search')['value']) ? $this->input->post('search')['value'] : '';
            
            // Get filter parameters from the request
            $course_id = $this->input->post('course_id');
            $subject_id = $this->input->post('subject_id');
            $question_type = $this->input->post('question_type');
            
            // Debug: Guardar los valores originales recibidos para identificar el problema
            error_log('Filter - course_id: ' . $course_id);
            error_log('Filter - subject_id: ' . $subject_id);
            error_log('Filter - question_type: ' . $question_type);
            
            // Valores por defecto para respuestas vacías
            if ($length < 1) $length = 10;
            
            // Base query params
            $params = array();
            $base_params = array(); // Para el conteo total de registros que coinciden con cq_quiz_id = 0
            
            $params['where']['cq_quiz_id'] = 0; // Only get questions not assigned to any quiz
            $params['where']['cq_status'] = 1; // Only active questions
            
            // Usar el mismo filtro base para el conteo total
            $base_params['where']['cq_quiz_id'] = 0;
            $base_params['where']['cq_status'] = 1;
            
            // Apply filters if provided and not empty
            // Verificamos si la cadena NO está vacía y si el valor es mayor que 0 (para valores numéricos)
            if (!empty($course_id) && $course_id !== '' && intval($course_id) > 0) {
                $params['where']['cq_course_id'] = intval($course_id);
            }
            
            if (!empty($subject_id) && $subject_id !== '' && intval($subject_id) > 0) {
                $params['where']['cq_subject_id'] = intval($subject_id);
            }
            
            if (!empty($question_type) && $question_type !== '' && intval($question_type) > 0) {
                $params['where']['cq_type'] = intval($question_type);
            }
            
            // Apply search if provided
            if (!empty($search)) {
                $params['like'] = array(
                    'cq_question' => $search
                );
            }
            
            // Obtener el conteo total solo de las preguntas elegibles para el banco (cq_quiz_id = 0)
            $total_records = $this->model_course_quiz->find_count($base_params);
            
            // Get total filtered records
            $total_filtered = $this->model_course_quiz->find_count($params);
            
            // Get paginated data
            $params['limit'] = $length;
            $params['offset'] = $start;
            $params['order_by'] = 'cq_id DESC';
            
            $data = $this->model_course_quiz->find_all($params);
            
            $output = array(
                'draw' => $draw,
                'recordsTotal' => (int)$total_records,
                'recordsFiltered' => (int)$total_filtered,
                'data' => array()
            );
            
            // Definir los tipos de preguntas fuera del bucle
            $types = array(
                1 => 'Multiple Choice',
                2 => 'True/False',
                3 => 'Fill in the blank',
                4 => 'Short Answer',
                5 => 'Essay'
            );
            
            if (!empty($data)) {
                foreach ($data as $item) {
                    // Manejar posibles errores en los datos
                    try {
                        // Obtener curso y asignatura con manejo de errores
                        $course = array('c_title' => 'Unknown');
                        $subject = array('cs_title' => 'Unknown');
                        
                        if (!empty($item['cq_course_id'])) {
                            $course_result = $this->model_course->find_by_pk($item['cq_course_id']);
                            if ($course_result) {
                                $course = $course_result;
                            }
                        }
                        
                        if (!empty($item['cq_subject_id'])) {
                            $subject_result = $this->model_course_subject->find_by_pk($item['cq_subject_id']);
                            if ($subject_result) {
                                $subject = $subject_result;
                            }
                        }
                        
                        // Preparar la pregunta con manejo de errores
                        $question = isset($item['cq_question']) ? $item['cq_question'] : '';
                        if ($question) {
                            $question = html_entity_decode($question);
                            $question_display = mb_strlen($question) > 100 ? mb_substr($question, 0, 100) . '...' : $question;
                        } else {
                            $question_display = 'No question text';
                        }
                        
                        // Preparar acciones
                        $actions = '<div class="btn-group">
';
                        $actions .= '<button type="button" class="btn btn-sm btn-info view-question" data-id="'.$item['cq_id'].'" data-table="course_quiz"><i class="fa fa-eye"></i></button>
';
                        // Botón de asignar pregunta eliminado para limpieza y separación de responsabilidades entre módulos.
                        $actions .= '<button type="button" class="btn btn-sm btn-danger delete-question" data-id="'.$item['cq_id'].'" data-table="course_quiz"><i class="fa fa-trash"></i></button>
';
                        $actions .= '</div>';
                        
                        // Crear objeto con propiedades nombradas que coincidan con la configuración de DataTables
                        $output['data'][] = array(
                            'cq_id' => $item['cq_id'],
                            'cq_type' => isset($item['cq_type']) && isset($types[$item['cq_type']]) ? $types[$item['cq_type']] : 'Unknown',
                            'course_title' => isset($course['c_title']) ? $course['c_title'] : 'Unknown',
                            'subject_name' => isset($subject['cs_title']) ? $subject['cs_title'] : 'Unknown',
                            'cq_question' => $question_display,
                            'cq_option_1' => isset($item['cq_option_1']) ? $item['cq_option_1'] : '',
                            'cq_option_2' => isset($item['cq_option_2']) ? $item['cq_option_2'] : '',
                            'cq_option_3' => isset($item['cq_option_3']) ? $item['cq_option_3'] : '',
                            'cq_option_4' => isset($item['cq_option_4']) ? $item['cq_option_4'] : '',
                            'cq_option_5' => isset($item['cq_option_5']) ? $item['cq_option_5'] : '',
                            'cq_option_6' => isset($item['cq_option_6']) ? $item['cq_option_6'] : '',
                            'cq_correct_answer' => isset($item['cq_correct_answer']) ? $item['cq_correct_answer'] : '',
                            'cq_gain_point' => isset($item['cq_gain_point']) ? $item['cq_gain_point'] : 0,
                            'cq_is_bonus' => isset($item['cq_is_bonus']) ? $item['cq_is_bonus'] : 0,
                            'cq_bonus_points' => isset($item['cq_bonus_points']) ? $item['cq_bonus_points'] : 0,
                            'cq_quiz_id' => isset($item['cq_quiz_id']) ? $item['cq_quiz_id'] : 0,
                            'actions' => $actions
                        );
                    } catch (Exception $e) {
                        // Si hay un error procesando un elemento individual, simplemente lo omitimos
                        // y continuamos con el siguiente
                        continue;
                    }
                }
            }
            
            // Asegurar que la salida sea un JSON válido
            header('Content-Type: application/json');
            echo json_encode($output);
            
        } catch (Exception $e) {
            // En caso de cualquier error, devolver una respuesta JSON válida con un mensaje de error
            header('Content-Type: application/json');
            echo json_encode(array(
                'draw' => isset($draw) ? $draw : 0,
                'recordsTotal' => 0,
                'recordsFiltered' => 0,
                'data' => array(),
                'error' => 'Error: ' . $e->getMessage()
            ));
        }
    }
    
    /**
     * Get questions assigned to a specific quiz
     */
    public function get_quiz_questions()
    {
        $quiz_id = $this->input->post('quiz_id');
        if (empty($quiz_id)) {
            echo json_encode(array('status' => false, 'message' => 'Quiz ID is required'));
            return;
        }
        
        // Usar el modelo nuevo para obtener las preguntas asignadas con datos completos y tipo mapeado
        $questions = $this->model_quiz_questions->get_quiz_questions($quiz_id);
        error_log('[DEBUG] get_quiz_questions RAW: ' . print_r($questions, true));
        $formatted_questions = array();
        if (!empty($questions)) {
            foreach ($questions as $question) {
                $item = array();
                $item['id'] = isset($question['qq_id']) ? $question['qq_id'] : null;
                $item['qb_id'] = isset($question['qb_id']) ? $question['qb_id'] : null;
                $item['question'] = isset($question['qb_text']) ? html_entity_decode($question['qb_text']) : '';
                $item['type'] = isset($question['type']) ? $question['type'] : '-'; // texto descriptivo
                $item['type_text'] = isset($question['type']) ? $question['type'] : '-'; // para compatibilidad frontend
                $item['points'] = isset($question['qq_points']) && $question['qq_points'] !== null ? $question['qq_points'] : 
                                 (isset($question['qb_gain_point']) && $question['qb_gain_point'] !== null ? $question['qb_gain_point'] : 1.0);
                $item['order'] = isset($question['qq_order']) ? $question['qq_order'] : 0;
                $formatted_questions[] = $item;
            }
        }
        error_log('[DEBUG] get_quiz_questions FORMATTED: ' . print_r($formatted_questions, true));
        echo json_encode(array(
            'status' => true,
            'questions' => $formatted_questions
        ));
    }
    
    /**
     * Remove a question from a quiz
     */
    public function remove_question_from_quiz()
    {
        $question_id = $this->input->post('question_id'); // Debe ser el ID del banco de preguntas
        $quiz_id = $this->input->post('quiz_id');

        if (empty($question_id) || empty($quiz_id)) {
            echo json_encode(array('status' => false, 'message' => 'Question ID and Quiz ID are required'));
            return;
        }

        // Usar el modelo centralizado para eliminar la relación
        $this->load->model('model_quiz_questions');
        $deleted = $this->model_quiz_questions->unassign_question($quiz_id, $question_id);
        if ($deleted) {
            echo json_encode(array('status' => true, 'message' => 'Question removed successfully'));
        } else {
            echo json_encode(array('status' => false, 'message' => 'Failed to remove question'));
        }
    }
    
    /**
     * Save the order of questions in a quiz
     */
    public function save_question_order()
    {
        $questions = $this->input->post('questions');
        
        if (empty($questions) || !is_array($questions)) {
            echo json_encode(array('status' => false, 'message' => 'Invalid questions data'));
            return;
        }
        
        $success = true;
        
        foreach ($questions as $order => $question_id) {
            $data = array('cq_order' => $order + 1); // 1-based indexing for order
            if (!$this->model_course_quiz->update_by_pk($question_id, $data)) {
                $success = false;
            }
        }
        
        if ($success) {
            echo json_encode(array('status' => true, 'message' => 'Question order saved successfully'));
        } else {
            echo json_encode(array('status' => false, 'message' => 'Failed to save question order'));
        }
    }
}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
